/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.ui.refactoring.AbstractElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.CopyElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.CopyNamesHandler;
import org.eclipse.statet.ltk.ui.refactoring.CutElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.DeleteElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.PasteElementsHandler;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class SourceEditor2OutlinePage
extends SourceEditor1OutlinePage {
    private final CommonRefactoringFactory refactoring;

    public SourceEditor2OutlinePage(SourceEditor1 editor, String mainType, CommonRefactoringFactory refactoring, String contextMenuId) {
        super(editor, mainType, contextMenuId);
        this.refactoring = refactoring;
    }

    protected CommonRefactoringFactory getRefactoringFactory() {
        return this.refactoring;
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        AbstractElementsHandler handler = new CutElementsHandler(this.refactoring);
        handlers.addActivate("org.eclipse.ui.edit.cut", (IHandler2)handler);
        this.registerHandlerToUpdate((IHandler2)handler);
        handler = new CopyElementsHandler(this.refactoring);
        handlers.addActivate("org.eclipse.ui.edit.copy", (IHandler2)handler);
        this.registerHandlerToUpdate((IHandler2)handler);
        handler = new CopyNamesHandler(this.refactoring);
        handlers.addActivate("org.eclipse.statet.workbench.commands.CopyElementName", (IHandler2)handler);
        this.registerHandlerToUpdate((IHandler2)handler);
        handler = new PasteElementsHandler(this.getSourceEditor(), this.refactoring);
        handlers.addActivate("org.eclipse.ui.edit.paste", (IHandler2)handler);
        handler = new DeleteElementsHandler(this.refactoring);
        handlers.addActivate("org.eclipse.ui.edit.delete", (IHandler2)handler);
    }

    @Override
    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        IPageSite site = this.getSite();
        menuManager.add((IAction)new SelectCodeRangeAction(this.refactoring));
        menuManager.add((IContributionItem)new Separator("edit.copypaste"));
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.cut", 8)));
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.copy", 8)));
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.workbench.commands.CopyElementName", 8)));
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.ui.edit.paste", 8)));
        super.contextMenuAboutToShow(menuManager);
    }

    protected class SelectCodeRangeAction
    extends Action {
        public SelectCodeRangeAction(CommonRefactoringFactory refactoring) {
            this.setText(EditingMessages.SelectSourceCode_label);
            this.setEnabled(!SourceEditor2OutlinePage.this.getSelection().isEmpty());
        }

        public void run() {
            @NonNull Object[] elementArray = LTKSelectionUtils.getSelectedSourceStructElements(SourceEditor2OutlinePage.this.getSelection());
            if (elementArray != null) {
                ImList elements;
                IRegion range;
                RefactoringAdapter adapter = SourceEditor2OutlinePage.this.refactoring.createAdapter((Object)elementArray);
                if (adapter == null) {
                    adapter = SourceEditor2OutlinePage.this.refactoring.createAdapter(null);
                }
                if ((range = adapter.getContinuousSourceRange((List)(elements = ImCollections.newList((Object[])elementArray, (Comparator)adapter.getModelElementComparator())))) != null) {
                    SourceEditor2OutlinePage.this.selectInEditor((ISelection)new TextSelection(range.getOffset(), range.getLength()));
                }
            }
        }
    }
}

