/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlockPreferencePage;
import org.eclipse.statet.ecommons.preferences.ui.ProjectSelectionDialog;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.ecommons.preferences.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class PropertyAndPreferencePage
extends ConfigurationBlockPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    private Composite parentComposite;
    protected Button useProjectSettings;
    private Link changeWorkspaceSettings;
    private ControlEnableState blockEnableState;
    private IProject project = null;
    private Map<String, Object> data = null;

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    @Override
    protected abstract ConfigurationBlock createConfigurationBlock() throws CoreException;

    protected abstract boolean hasProjectSpecificSettings(IProject var1);

    protected final boolean supportsProjectSpecificSettings() {
        return this.getPropertyPageID() != null;
    }

    protected final boolean supportsInstanceSettings() {
        return this.getPreferencePageID() != null;
    }

    protected boolean offerLink() {
        return this.data == null || !Boolean.TRUE.equals(this.data.get(DATA_NO_LINK));
    }

    protected boolean isProjectSupported(IProject project) throws CoreException {
        return true;
    }

    protected final boolean useProjectSettings() {
        return this.isProjectPreferencePage() && (!this.supportsInstanceSettings() || this.useProjectSettings.getSelection());
    }

    protected final boolean isProjectPreferencePage() {
        return this.project != null;
    }

    protected final IProject getProject() {
        return this.project;
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.parentComposite = parent;
        if (this.isProjectPreferencePage()) {
            if (this.supportsInstanceSettings() && this.offerLink()) {
                Composite composite = new Composite(parent, 0);
                composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                composite.setLayout((Layout)LayoutUtils.newCompositeGrid(2));
                this.useProjectSettings = new Button(composite, 32);
                this.useProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                this.useProjectSettings.setText(Messages.PropertyAndPreference_UseProjectSettings_label);
                this.useProjectSettings.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        PropertyAndPreferencePage.this.doEnableProjectSpecificSettings(PropertyAndPreferencePage.this.useProjectSettings.getSelection());
                    }
                });
                if (this.offerLink()) {
                    this.changeWorkspaceSettings = this.createLink(composite, Messages.PropertyAndPreference_ShowWorkspaceSettings_label);
                }
                Label horizontalLine = new Label(composite, 258);
                horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            }
        } else if (this.supportsProjectSpecificSettings() && this.offerLink()) {
            this.changeWorkspaceSettings = this.createLink(parent, Messages.PropertyAndPreference_ShowProjectSpecificSettings_label);
        }
        return super.createDescriptionLabel(parent);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 131072);
        link.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        link.setText("<a>" + text + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    final void doLinkActivated(Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            try {
                Set<IProject> all = this.getAllProjects();
                HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
                for (IProject proj : all) {
                    if (!this.hasProjectSpecificSettings(proj.getProject())) continue;
                    projectsWithSpecifics.add(proj);
                }
                ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), all, projectsWithSpecifics);
                if (dialog.open() == 0) {
                    IProject proj = (IProject)dialog.getFirstResult();
                    this.openProjectProperties(proj, data);
                }
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "An error occurred when opening the project properties page.", (Throwable)e));
            }
        }
    }

    private Set<IProject> getAllProjects() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> collected = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isProjectSupported(project)) {
                collected.add(project);
            }
            ++n2;
        }
        return collected;
    }

    @Override
    protected Control createContents(Composite parent) {
        if (this.getBlock() == null) {
            this.init(null);
        }
        Control control = super.createContents(parent);
        if (this.isProjectPreferencePage()) {
            this.doEnableProjectSpecificSettings(this.hasProjectSpecificSettings(this.getProject()));
        }
        return control;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void doEnableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.getBlock() != null) {
            this.getBlock().setUseProjectSpecificSettings(useProjectSpecificSettings);
        }
        if (this.useProjectSettings != null) {
            this.useProjectSettings.setSelection(useProjectSpecificSettings);
        }
        if (useProjectSpecificSettings) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.getBlockControl());
        }
        this.updateLinkVisibility();
        this.updateStatus();
    }

    private void updateLinkVisibility() {
        if (this.changeWorkspaceSettings == null || this.changeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.changeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    @Override
    protected void updateStatus() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.getBlockStatus());
        } else {
            this.updateStatus((IStatus)new StatusInfo());
        }
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.data = (Map)data;
        }
        if (this.changeWorkspaceSettings != null && !this.offerLink()) {
            this.changeWorkspaceSettings.dispose();
            this.parentComposite.layout(true, true);
        }
    }

    protected Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public void performDefaults() {
        if (this.isProjectPreferencePage() && !this.useProjectSettings()) {
            return;
        }
        super.performDefaults();
    }
}

