/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.jface;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public class RadioGroupObservable
extends AbstractSWTObservableValue
implements SelectionListener {
    private final Button[] fButtons;
    private int fIdx;

    public RadioGroupObservable(Realm realm, Button[] buttons) {
        super(realm, (Widget)buttons[0]);
        this.fButtons = buttons;
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)this);
            ++n2;
        }
        this.fIdx = -1;
    }

    public Object getValueType() {
        return Integer.class;
    }

    protected Object doGetValue() {
        return this.fIdx;
    }

    protected void doSetValue(Object value) {
        int idx = (Integer)value;
        if (idx < 0 || idx > this.fButtons.length) {
            idx = 0;
        }
        this.fIdx = idx;
        int i = 0;
        while (i < this.fButtons.length) {
            this.fButtons[i].setSelection(idx == i);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (((Button)e.widget).getSelection()) {
            int i = 0;
            while (i < this.fButtons.length) {
                if (e.widget == this.fButtons[i]) {
                    int old = this.fIdx;
                    if (i != old) {
                        this.fIdx = i;
                        this.fireValueChange(Diffs.createValueDiff((Object)old, (Object)i));
                    }
                    return;
                }
                ++i;
            }
        }
    }
}

