/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.docmlet.wikitext.core.source.BlockWeaveParticipant;
import org.eclipse.statet.ltk.core.SourceContent;

public class RegexBlockWeaveParticipant
extends BlockWeaveParticipant {
    private final String foreignTypeId;
    private final byte embedDescr;
    private final Matcher startMatcher;
    private final Matcher endMatcher;

    public RegexBlockWeaveParticipant(String foreignTypeId, byte embedDescr, Pattern startPattern, Pattern endPattern) {
        this.foreignTypeId = foreignTypeId;
        this.embedDescr = embedDescr;
        this.startMatcher = startPattern.matcher("");
        this.endMatcher = endPattern.matcher("");
    }

    @Override
    public String getForeignTypeId() {
        return this.foreignTypeId;
    }

    @Override
    public int getEmbedDescr() {
        return this.embedDescr;
    }

    @Override
    public void reset(SourceContent sourceContent) {
        String text = sourceContent != null ? sourceContent.getString() : "";
        this.startMatcher.reset(text);
        this.endMatcher.reset(text);
    }

    @Override
    public boolean checkStartLine(int startOffset, int endOffset) {
        this.startMatcher.region(startOffset, endOffset);
        return this.startMatcher.matches();
    }

    @Override
    public int getStartOffset() {
        return this.startMatcher.start();
    }

    @Override
    public boolean checkEndLine(int startOffset, int endOffset) {
        this.endMatcher.region(startOffset, endOffset);
        return this.endMatcher.matches();
    }
}

