/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.launcher.SubmitEntireCommandHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.ui.statushandlers.StatusManager;

public class SubmitEntireCommandAndGotoNextCommandHandler
extends SubmitEntireCommandHandler {
    public SubmitEntireCommandAndGotoNextCommandHandler() {
        super(false);
    }

    @Override
    protected void postLaunch(final SubmitEntireCommandHandler.Data data) {
        try {
            ImList<RAstNode> nodes = data.nodes;
            final int offset = this.getNextOffset((RAstNode)nodes.get(nodes.size() - 1), (IDocument)data.document);
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    data.editor.selectAndReveal(offset, 0);
                }
            });
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "Error occurred when updating selection", null));
        }
    }

    protected int getNextOffset(RAstNode node, IDocument doc) throws BadLocationException {
        RAstNode parent;
        while ((parent = node.getRParent()) != null) {
            int lastIdx = parent.getChildIndex((AstNode)node);
            if (lastIdx + 1 < parent.getChildCount()) {
                return parent.getChild(lastIdx + 1).getStartOffset();
            }
            node = parent;
        }
        int line = doc.getLineOfOffset(node.getEndOffset());
        if (line + 1 < doc.getNumberOfLines()) {
            return doc.getLineOffset(line + 1);
        }
        return doc.getLength();
    }
}

