/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.Bundles;
import org.eclipse.statet.jcommons.status.ErrorStatus;

@NonNullByDefault
public abstract class BundleEntryProvider {
    private final ImList<Path> baseDirectories;
    private final List<Closeable> closeables;

    protected BundleEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
        this.baseDirectories = baseDirectories;
        this.closeables = closeables;
    }

    public void dispose() {
        Bundles.close(this.closeables);
    }

    protected ImList<Path> getBaseDirectories() {
        return this.baseDirectories;
    }

    public void getEntries(List<BundleEntry> entries) {
        for (Path baseDirectory : this.baseDirectories) {
            try {
                this.getEntries(baseDirectory, entries);
            }
            catch (Exception e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("An error occurred when looking for path entries in '%1$s'.", baseDirectory), e));
            }
        }
    }

    protected void getEntries(Path baseDirectory, List<BundleEntry> entries) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> children = Files.newDirectoryStream(baseDirectory);){
            for (Path child : children) {
                BundleEntry entry = this.createEntry(child);
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected @Nullable BundleEntry createEntry(Path candidate) {
        return null;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.baseDirectories.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            BundleEntryProvider other = (BundleEntryProvider)obj;
            return this.baseDirectories.equals(other.baseDirectories);
        }
        return false;
    }

    public static class DevBinPathEntryProvider
    extends BundleEntryProvider {
        public DevBinPathEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
            super(baseDirectories, closeables);
        }

        public DevBinPathEntryProvider(Path baseDirectory, List<Closeable> closeables) {
            this(ImCollections.newList(ObjectUtils.nonNullAssert(baseDirectory)), closeables);
        }

        @Override
        protected @Nullable BundleEntry createEntry(Path candidate) {
            Path devBin = candidate.resolve("target/classes");
            if (Files.isDirectory(devBin, new LinkOption[0])) {
                String bundleId = ObjectUtils.nonNullAssert(candidate.getFileName()).toString();
                return new BundleEntry.Dir(bundleId, candidate, devBin);
            }
            return null;
        }

        public String toString() {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("DevBinPathEntryProvider", this.getClass());
            sb.addProp("baseDirectories", this.getBaseDirectories());
            return sb.toString();
        }
    }

    public static class JarFilePathEntryProvider
    extends BundleEntryProvider {
        private final Pattern namePattern;

        public JarFilePathEntryProvider(ImList<Path> baseDirectories, Pattern namePattern, List<Closeable> closeables) {
            super(baseDirectories, closeables);
            this.namePattern = namePattern;
        }

        public JarFilePathEntryProvider(Path baseDirectory, Pattern namePattern, List<Closeable> closeables) {
            this(ImCollections.newList(ObjectUtils.nonNullAssert(baseDirectory)), namePattern, closeables);
        }

        @Override
        protected @Nullable BundleEntry createEntry(Path candidate) {
            Matcher nameMatcher = this.namePattern.matcher(ObjectUtils.nonNullAssert(candidate.getFileName()).toString());
            if (nameMatcher.matches() && Files.isRegularFile(candidate, new LinkOption[0])) {
                String bundleId = ObjectUtils.nonNullAssert(nameMatcher.group(1));
                return new BundleEntry.Jar(bundleId, candidate);
            }
            return null;
        }

        @Nullable String getBundleId(String fileName) {
            Matcher nameMatcher = this.namePattern.matcher(fileName);
            if (nameMatcher.matches()) {
                return nameMatcher.group(1);
            }
            return null;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.namePattern.hashCode() * 17;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) && this.namePattern.pattern().equals(((JarFilePathEntryProvider)obj).namePattern.pattern());
        }

        public String toString() {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("JarFileBundleEntryProvider", this.getClass());
            sb.addProp("baseDirectories", this.getBaseDirectories());
            sb.addProp("namePattern", this.namePattern);
            return sb.toString();
        }
    }
}

