/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.ui.matcher.LetterOrDigitKeyEventMatcher;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NatCombo
extends Composite {
    public static final String DEFAULT_MULTI_SELECT_VALUE_SEPARATOR = ", ";
    public static final String DEFAULT_MULTI_SELECT_PREFIX = "[";
    public static final String DEFAULT_MULTI_SELECT_SUFFIX = "]";
    public static final int DEFAULT_NUM_OF_VISIBLE_ITEMS = 5;
    protected final IStyle cellStyle;
    protected int maxVisibleItems;
    protected List<String> itemList;
    protected Text text;
    protected Shell dropdownShell;
    protected Table dropdownTable;
    protected Image iconImage;
    protected final int style;
    protected boolean freeEdit;
    protected boolean multiselect;
    protected boolean useCheckbox;
    protected String multiselectValueSeparator = ", ";
    protected String multiselectTextPrefix = "[";
    protected String multiselectTextSuffix = "]";
    private boolean hasFocus = false;
    private boolean focusLostRunnableActive = false;
    private final List<FocusListener> focusListener = new ArrayList<FocusListener>();

    public NatCombo(Composite parent, IStyle cellStyle, int style) {
        this(parent, cellStyle, 5, style, GUIHelper.getImage("down_2"));
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"));
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage) {
        super(parent, 0);
        this.cellStyle = cellStyle;
        this.maxVisibleItems = maxVisibleItems;
        this.iconImage = iconImage;
        this.style = style;
        this.freeEdit = (style & 8) == 0;
        this.multiselect = (style & 2) != 0;
        this.useCheckbox = (style & 0x20) != 0;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createTextControl(style);
        this.createDropdownControl(style);
    }

    public void dispose() {
        super.dispose();
        this.dropdownShell.dispose();
        this.text.dispose();
    }

    public void setItems(String[] items) {
        if (items != null) {
            this.itemList = Arrays.asList(items);
            if (!this.dropdownTable.isDisposed()) {
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    TableItem tableItem = new TableItem(this.dropdownTable, 0);
                    tableItem.setText(item);
                    ++n2;
                }
            }
        }
    }

    protected void createTextControl(int style) {
        int widgetStyle = style | CellStyleUtil.getHorizontalAlignmentSWT(this.cellStyle, 0);
        this.text = new Text((Composite)this, widgetStyle);
        this.text.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.text.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.text.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000001) {
                    NatCombo.this.showDropdownControl();
                    int selectionIndex = NatCombo.this.dropdownTable.getSelectionIndex();
                    if ((selectionIndex += event.keyCode == 0x1000002 ? 1 : -1) < 0) {
                        selectionIndex = 0;
                    }
                    NatCombo.this.dropdownTable.select(selectionIndex);
                } else if (!LetterOrDigitKeyEventMatcher.isLetterOrDigit(event.character)) {
                    if (NatCombo.this.freeEdit) {
                        if (!NatCombo.this.dropdownTable.isDisposed()) {
                            NatCombo.this.dropdownTable.deselectAll();
                        }
                    } else {
                        NatCombo.this.showDropdownControl();
                    }
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!NatCombo.this.freeEdit) {
                    if (NatCombo.this.dropdownTable.isDisposed() || !NatCombo.this.dropdownTable.isVisible()) {
                        NatCombo.this.showDropdownControl();
                    } else {
                        NatCombo.this.dropdownTable.forceFocus();
                    }
                }
            }
        });
        this.text.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                NatCombo.this.calculateBounds();
            }

            public void controlMoved(ControlEvent e) {
                NatCombo.this.calculateBounds();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusListenerWrapper());
        final Canvas iconCanvas = new Canvas(this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                return new Point(iconImageBounds.width + 2, iconImageBounds.height + 2);
            }
        };
        gridData = new GridData(1, 4, false, true);
        iconCanvas.setLayoutData((Object)gridData);
        iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Rectangle iconCanvasBounds = iconCanvas.getBounds();
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                long horizontalAlignmentPadding = CellStyleUtil.getHorizontalAlignmentPadding(HorizontalAlignment.CENTER, iconCanvasBounds.width, (long)iconImageBounds.width);
                long verticalAlignmentPadding = CellStyleUtil.getVerticalAlignmentPadding(VerticalAlignment.MIDDLE, iconCanvasBounds.height, (long)iconImageBounds.height);
                gc.drawImage(NatCombo.this.iconImage, GraphicsUtils.safe(horizontalAlignmentPadding), GraphicsUtils.safe(verticalAlignmentPadding));
                Color originalFg = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_WIDGET_BORDER);
                gc.drawRectangle(0, 0, iconCanvasBounds.width - 1, iconCanvasBounds.height - 1);
                gc.setForeground(originalFg);
            }
        });
        iconCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (NatCombo.this.dropdownShell != null && !NatCombo.this.dropdownShell.isDisposed()) {
                    if (NatCombo.this.dropdownShell.isVisible()) {
                        NatCombo.this.text.forceFocus();
                        NatCombo.this.hideDropdownControl();
                    } else {
                        NatCombo.this.showDropdownControl();
                    }
                }
            }
        });
    }

    protected void createDropdownControl(int style) {
        this.dropdownShell = new Shell(this.getShell(), 0);
        this.dropdownShell.setLayout((Layout)new FillLayout());
        int dropdownListStyle = style | 0x200 | 0x10000 | CellStyleUtil.getHorizontalAlignmentSWT(this.cellStyle, 0);
        this.dropdownTable = new Table((Composite)this.dropdownShell, dropdownListStyle);
        this.dropdownTable.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.dropdownTable.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.dropdownTable.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        this.dropdownTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = e.detail != 32;
                TableItem item = (TableItem)e.item;
                if (!selected) {
                    if (!item.getChecked()) {
                        NatCombo.this.dropdownTable.deselect(NatCombo.this.itemList.indexOf(item.getText()));
                    } else {
                        NatCombo.this.dropdownTable.select(NatCombo.this.itemList.indexOf(item.getText()));
                    }
                } else if (NatCombo.this.useCheckbox) {
                    TableItem[] tableItemArray = NatCombo.this.dropdownTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        tableItem.setChecked(NatCombo.this.dropdownTable.isSelected(NatCombo.this.itemList.indexOf(tableItem.getText())));
                        ++n2;
                    }
                }
                NatCombo.this.updateTextControl(false);
            }
        });
        this.dropdownTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    NatCombo.this.updateTextControl(true);
                } else if (event.keyCode == 0x100000B && NatCombo.this.freeEdit) {
                    NatCombo.this.text.forceFocus();
                    NatCombo.this.hideDropdownControl();
                }
            }
        });
        this.dropdownTable.addFocusListener((FocusListener)new FocusListenerWrapper());
        if (this.itemList != null) {
            this.setItems(this.itemList.toArray(new String[0]));
        }
        this.setDropdownSelection(this.getTextAsArray());
    }

    protected void updateTextControl(boolean hideDropdown) {
        this.text.setText(this.getTransformedTextForSelection());
        if (hideDropdown) {
            this.hideDropdownControl();
        }
    }

    public void showDropdownControl() {
        this.showDropdownControl(false);
    }

    public void showDropdownControl(boolean focusOnText) {
        if (this.dropdownShell.isDisposed()) {
            this.createDropdownControl(this.style);
        }
        this.calculateBounds();
        this.dropdownShell.open();
        if (focusOnText) {
            this.text.forceFocus();
            this.text.setSelection(this.text.getText().length());
        }
    }

    public void hideDropdownControl() {
        if (!this.dropdownShell.isDisposed()) {
            this.dropdownShell.setVisible(false);
        }
    }

    protected int getVisibleItemCount() {
        int itemCount = this.dropdownTable.getItemCount();
        if (itemCount > 0) {
            int visibleItemCount = itemCount;
            if (this.maxVisibleItems > 0) {
                visibleItemCount = Math.min(itemCount, this.maxVisibleItems);
            }
            itemCount = visibleItemCount;
        }
        return itemCount;
    }

    protected void calculateBounds() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            Point size = this.getSize();
            int listHeight = (this.getVisibleItemCount() > 0 ? this.getVisibleItemCount() : 3) * this.dropdownTable.getItemHeight() + 2;
            int listWidth = this.dropdownTable.computeSize((int)-1, (int)listHeight, (boolean)true).x;
            if (listWidth < size.x) {
                listWidth = size.x;
            }
            this.dropdownTable.setSize(listWidth, listHeight);
            Point textPosition = this.text.toDisplay(this.text.getLocation());
            int dropdownShellStartingY = textPosition.y + this.text.getBounds().height;
            int shellBottomY = textPosition.y + this.text.getBounds().height + listHeight;
            if (shellBottomY > Display.getCurrent().getBounds().height) {
                dropdownShellStartingY = textPosition.y - listHeight;
            }
            this.dropdownShell.setBounds(textPosition.x, dropdownShellStartingY, listWidth, listHeight);
        }
    }

    public int getSelectionIndex() {
        if (!this.dropdownTable.isDisposed()) {
            return this.dropdownTable.getSelectionIndex();
        }
        if (!this.text.isDisposed()) {
            return this.itemList.indexOf(this.text.getText());
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        if (!this.dropdownTable.isDisposed()) {
            return this.dropdownTable.getSelectionIndices();
        }
        String[] selectedItems = this.getTextAsArray();
        int[] result = new int[selectedItems.length];
        int i = 0;
        while (i < selectedItems.length) {
            result[i] = this.itemList.indexOf(selectedItems[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        if (!this.dropdownTable.isDisposed()) {
            return this.dropdownTable.getSelectionCount();
        }
        return this.getTextAsArray().length;
    }

    public String[] getSelection() {
        String[] result = this.getTransformedSelection();
        if (result == null || result.length == 0 && this.text.getText().length() > 0) {
            result = this.getTextAsArray();
        }
        return result;
    }

    public void setSelection(String[] items) {
        String textValue = "";
        if (items != null) {
            if (!this.dropdownTable.isDisposed()) {
                this.setDropdownSelection(items);
                textValue = this.freeEdit && this.dropdownTable.getSelectionCount() == 0 ? this.getTransformedText(items) : this.getTransformedTextForSelection();
            } else {
                textValue = this.getTransformedText(items);
            }
        }
        this.text.setText(textValue);
    }

    public void select(int index) {
        if (!this.dropdownTable.isDisposed()) {
            this.dropdownTable.select(index);
            this.text.setText(this.getTransformedTextForSelection());
        } else if (index >= 0) {
            this.text.setText(this.itemList.get(index));
        }
    }

    public void select(int[] indeces) {
        if (!this.dropdownTable.isDisposed()) {
            this.dropdownTable.select(indeces);
            this.text.setText(this.getTransformedTextForSelection());
        } else {
            String[] selectedItems = new String[indeces.length];
            int i = 0;
            while (i < indeces.length) {
                if (indeces[i] >= 0) {
                    selectedItems[i] = this.itemList.get(indeces[i]);
                }
                ++i;
            }
            this.text.setText(this.getTransformedText(selectedItems));
        }
    }

    public void addKeyListener(KeyListener listener) {
        this.text.addKeyListener(listener);
        this.dropdownTable.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.text.removeKeyListener(listener);
        this.dropdownTable.removeKeyListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.text.addTraverseListener(listener);
        this.dropdownTable.addTraverseListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.text.removeTraverseListener(listener);
        this.dropdownTable.removeTraverseListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.dropdownTable.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.dropdownTable.removeMouseListener(listener);
    }

    public void notifyListeners(int eventType, Event event) {
        this.dropdownTable.notifyListeners(eventType, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.dropdownTable.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.dropdownTable.removeSelectionListener(listener);
    }

    public void addShellListener(ShellListener listener) {
        this.dropdownShell.addShellListener(listener);
    }

    public void removeShellListener(ShellListener listener) {
        this.dropdownShell.removeShellListener(listener);
    }

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public boolean forceFocus() {
        return this.text.forceFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListener.add(listener);
    }

    public void removeFocusListener(final FocusListener listener) {
        if (this.focusLostRunnableActive) {
            try {
                new Thread(){

                    @Override
                    public void run() {
                        NatCombo.this.focusListener.remove(listener);
                    }
                }.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.focusListener.remove(listener);
        }
    }

    protected String[] getTransformedSelection() {
        String[] selection = null;
        if (!this.dropdownTable.isDisposed()) {
            TableItem[] selectedItems = this.dropdownTable.getSelection();
            selection = new String[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                selection[i] = selectedItems[i].getText();
                ++i;
            }
        }
        return selection;
    }

    protected void setDropdownSelection(String[] selection) {
        if (selection.length > 0) {
            List<String> selectionList = Arrays.asList(selection);
            ArrayList<TableItem> selectedItems = new ArrayList<TableItem>();
            TableItem[] tableItemArray = this.dropdownTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (selectionList.contains(item.getText())) {
                    selectedItems.add(item);
                    if (this.useCheckbox) {
                        item.setChecked(true);
                    }
                }
                ++n2;
            }
            this.dropdownTable.setSelection(selectedItems.toArray(new TableItem[0]));
        }
    }

    protected String[] getTextAsArray() {
        String transform;
        if (!this.text.isDisposed() && (transform = this.text.getText()).length() > 0) {
            if (this.multiselect) {
                int prefixLength = this.multiselectTextPrefix.length();
                int suffixLength = this.multiselectTextSuffix.length();
                if (this.freeEdit) {
                    if (!transform.startsWith(this.multiselectTextPrefix)) {
                        prefixLength = 0;
                    }
                    if (!transform.endsWith(this.multiselectTextSuffix)) {
                        suffixLength = 0;
                    }
                }
                transform = transform.substring(prefixLength, transform.length() - suffixLength);
            }
            if (transform.length() > 0) {
                return transform.split(this.multiselectValueSeparator);
            }
        }
        return new String[0];
    }

    protected String getTransformedTextForSelection() {
        String result = "";
        String[] selection = this.getTransformedSelection();
        if (selection != null) {
            result = this.getTransformedText(selection);
        }
        return result;
    }

    protected String getTransformedText(String[] values) {
        String result = "";
        if (this.multiselect) {
            int i = 0;
            while (i < values.length) {
                String selection = values[i];
                result = String.valueOf(result) + selection;
                if (i + 1 < values.length) {
                    result = String.valueOf(result) + this.multiselectValueSeparator;
                }
                ++i;
            }
            result = String.valueOf(this.multiselectTextPrefix) + result + this.multiselectTextSuffix;
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    public void setMultiselectValueSeparator(String multiselectValueSeparator) {
        this.multiselectValueSeparator = multiselectValueSeparator == null ? DEFAULT_MULTI_SELECT_VALUE_SEPARATOR : multiselectValueSeparator;
    }

    public void setMultiselectTextBracket(String multiselectTextPrefix, String multiselectTextSuffix) {
        this.multiselectTextPrefix = multiselectTextPrefix == null ? DEFAULT_MULTI_SELECT_PREFIX : multiselectTextPrefix;
        this.multiselectTextSuffix = multiselectTextSuffix == null ? DEFAULT_MULTI_SELECT_SUFFIX : multiselectTextSuffix;
    }

    class FocusListenerWrapper
    implements FocusListener {
        FocusListenerWrapper() {
        }

        public void focusLost(final FocusEvent e) {
            NatCombo.this.hasFocus = false;
            Display.getCurrent().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    if (!((FocusListenerWrapper)FocusListenerWrapper.this).NatCombo.this.hasFocus) {
                        ((FocusListenerWrapper)FocusListenerWrapper.this).NatCombo.this.focusLostRunnableActive = true;
                        for (FocusListener f : ((FocusListenerWrapper)FocusListenerWrapper.this).NatCombo.this.focusListener) {
                            f.focusLost(e);
                        }
                        ((FocusListenerWrapper)FocusListenerWrapper.this).NatCombo.this.focusLostRunnableActive = false;
                    }
                }
            });
        }

        public void focusGained(FocusEvent e) {
            NatCombo.this.hasFocus = true;
            for (FocusListener f : NatCombo.this.focusListener) {
                f.focusGained(e);
            }
        }
    }
}

