/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.rsource.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.StdBinary;

@NonNullByDefault
public abstract class Assignment
extends StdBinary {
    Assignment() {
    }

    public abstract RAstNode getTargetChild();

    public abstract RAstNode getSourceChild();

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    public abstract boolean isSearchOperator();

    abstract Expression getTargetExpr();

    abstract Expression getSourceExpr();

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (element instanceof Assignment) {
            Assignment other = (Assignment)element;
            RAstNode thisTarget = this.getTargetExpr().node;
            RAstNode otherTarget = other.getTargetExpr().node;
            return this.isSearchOperator() == other.isSearchOperator() && (thisTarget == otherTarget || thisTarget != null && thisTarget.equalsSingle(otherTarget));
        }
        return false;
    }

    @Override
    public final boolean equalsValue(RAstNode element) {
        if (this.getOperator(0) == element.getOperator(0)) {
            Assignment other = (Assignment)element;
            return this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node);
        }
        return false;
    }

    static final class LeftC
    extends Assignment {
        LeftC() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_COLON;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.leftExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.rightExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.leftExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.rightExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.COLON_EQUAL;
        }

        @Override
        public final boolean isSearchOperator() {
            return false;
        }
    }

    static final class LeftD
    extends Assignment {
        LeftD() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_LEFT;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.leftExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.rightExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.leftExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.rightExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.ARROW_LEFT_D;
        }

        @Override
        public final boolean isSearchOperator() {
            return true;
        }
    }

    static final class LeftE
    extends Assignment {
        LeftE() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_EQUALS;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.leftExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.rightExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.leftExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.rightExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.EQUAL;
        }

        @Override
        public final boolean isSearchOperator() {
            return false;
        }
    }

    static final class LeftS
    extends Assignment {
        LeftS() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_LEFT;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.leftExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.rightExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.leftExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.rightExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.ARROW_LEFT_S;
        }

        @Override
        public final boolean isSearchOperator() {
            return false;
        }
    }

    static final class RightD
    extends Assignment {
        RightD() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_RIGHT;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.rightExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.leftExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.rightExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.leftExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.ARROW_RIGHT_D;
        }

        @Override
        public final boolean isSearchOperator() {
            return true;
        }
    }

    static final class RightS
    extends Assignment {
        RightS() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.A_RIGHT;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.rightExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.leftExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.rightExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.leftExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.ARROW_RIGHT_S;
        }

        @Override
        public final boolean isSearchOperator() {
            return false;
        }
    }
}

