/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ConsoleRunnable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.statet.r.nico.IRSrcref;

public class SubmitEntireCommandRunnable
implements ConsoleRunnable {
    private final String[] fLines;
    private final String fLabel;
    private final IRSrcref fSrcref;

    public SubmitEntireCommandRunnable(String[] lines, IRSrcref srcref) {
        this.fLines = lines;
        this.fLabel = this.createLabel();
        this.fSrcref = srcref;
        if (this.fSrcref instanceof RCodeLaunching.SourceRegion) {
            ((RCodeLaunching.SourceRegion)this.fSrcref).installMarker();
        }
    }

    private String createLabel() {
        String label = this.fLines[0];
        if (this.fLines.length > 0) {
            return String.valueOf(label) + " \u2026";
        }
        return label;
    }

    public String getTypeId() {
        return "r/console/runCommand";
    }

    public SubmitType getSubmitType() {
        return SubmitType.EDITOR;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public boolean canRunIn(Tool tool) {
        return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
    }

    public boolean changed(int event, Tool process) {
        switch (event) {
            case 288: 
            case 290: 
            case 336: 
            case 340: 
            case 344: {
                if (!(this.fSrcref instanceof RCodeLaunching.SourceRegion)) break;
                ((RCodeLaunching.SourceRegion)this.fSrcref).disposeMarker();
            }
        }
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        AbstractRController r = (AbstractRController)service;
        r.briefAboutToChange();
        try {
            r.submitCommandToConsole(this.fLines, this.fSrcref, m);
        }
        finally {
            r.briefChanged(1);
        }
    }
}

