/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.rsource.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.StdBinary;

@NonNullByDefault
public abstract class Pipe
extends StdBinary {
    Pipe() {
    }

    public abstract RAstNode getTargetChild();

    public abstract RAstNode getSourceChild();

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    abstract Expression getTargetExpr();

    abstract Expression getSourceExpr();

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return this.getNodeType() == element.getNodeType();
    }

    @Override
    public final boolean equalsValue(RAstNode element) {
        if (this.getOperator(0) == element.getOperator(0)) {
            Pipe other = (Pipe)element;
            return this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node);
        }
        return false;
    }

    @Override
    int getMissingExprStatus(Expression expr) {
        if (this.leftExpr == expr) {
            return 70440;
        }
        if (this.rightExpr == expr) {
            return 70584;
        }
        throw new IllegalArgumentException();
    }

    static final class Forward
    extends Pipe {
        Forward() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.PIPE_FORWARD;
        }

        @Override
        public final RAstNode getTargetChild() {
            return this.rightExpr.node;
        }

        @Override
        public final RAstNode getSourceChild() {
            return this.leftExpr.node;
        }

        @Override
        final Expression getTargetExpr() {
            return this.rightExpr;
        }

        @Override
        final Expression getSourceExpr() {
            return this.leftExpr;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.PIPE_RIGHT;
        }
    }
}

