/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.snippets;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.snippets.RSnippets;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class SubmitRSnippetsContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    private final RSnippets snippets = RConsoleUIPlugin.getInstance().getRSnippets();

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        List<Template> filtered = this.snippets.validate(this.snippets.getTemplateStore().getTemplates());
        IServiceLocator serviceLocator = this.serviceLocator;
        if (serviceLocator == null) {
            serviceLocator = PlatformUI.getWorkbench();
        }
        IContributionItem[] items = new IContributionItem[filtered.size()];
        int i = 0;
        while (i < items.length) {
            Template template = filtered.get(i);
            String label = MessageUtils.escapeForMenu((String)template.getDescription());
            String mnemonic = null;
            if (i < 9) {
                mnemonic = Integer.toString(i + 1);
                label = String.valueOf(mnemonic) + ' ' + label;
            }
            items[i] = new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.r.commands.SubmitRSnippet", Map.of("snippet", template.getName()), null, null, null, label, mnemonic, null, 8, null, false));
            ++i;
        }
        return items;
    }
}

