/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.operations;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

@NonNullByDefault
public class OpenUsingEclipseOperation
extends DocProcessingOperation {
    public static final String ID = "org.eclipse.statet.docmlet.base.docProcessing.OpenUsingEclipseOperation";
    private IFile file;
    private int failSeverity = 4;

    public OpenUsingEclipseOperation() {
    }

    public OpenUsingEclipseOperation(IFile file) {
        this.file = file;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getLabel() {
        return Messages.ProcessingOperation_OpenUsingEclipse_label;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFailSeverity(int severity) {
        this.failSeverity = severity;
    }

    @Override
    public void init(DocProcessingToolConfig.StepConfig stepConfig, Map<String, String> settings, SubMonitor m) throws CoreException {
        super.init(stepConfig, settings, m);
        IFile file = (IFile)ObjectUtils.nullable((Object)this.file);
        if (file == null) {
            this.file = file = stepConfig.getInputFile();
        }
    }

    @Override
    public int getTicks() {
        return 15;
    }

    @Override
    public IStatus run(DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        IFile file = this.file;
        if (ObjectUtils.isNull((Object)file)) {
            throw new IllegalStateException("not initialized");
        }
        m.beginTask(NLS.bind((String)Messages.ProcessingOperation_OpenUsingEclipse_task, (Object)file.getName()), 10);
        class UIRunnable
        implements Runnable {
            private @Nullable Exception error;
            private final /* synthetic */ IFile val$file;

            UIRunnable(IFile iFile) {
                this.val$file = iFile;
            }

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = OpenUsingEclipseOperation.this.getStepConfig().getToolConfig().getWorkbenchPage();
                    if (page == null || UIAccess.isOkToUse((Control)page.getWorkbenchWindow().getShell())) {
                        page = UIAccess.getActiveWorkbenchPage((boolean)true);
                    }
                    IDE.openEditor((IWorkbenchPage)page, (IFile)this.val$file);
                }
                catch (Exception e) {
                    this.error = e;
                }
            }
        }
        UIRunnable runnable = new UIRunnable(file);
        UIAccess.getDisplay().syncExec((Runnable)runnable);
        if (runnable.error != null) {
            return new Status(this.failSeverity, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)Messages.ProcessingOperation_OpenUsingEclipse_error_message, (Object)file.getName(), (Object)this.getStepConfig().getLabel()), (Throwable)runnable.error);
        }
        return Status.OK_STATUS;
    }
}

