/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.ecommons.debug.ui.breakpoints.AbstractBreakpointDetailEditor;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfigurator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;

public class RLineBreakpointDetailEditor
extends AbstractBreakpointDetailEditor {
    private RLineBreakpoint breakpoint;
    private Button conditionEnabledControl;
    private SnippetEditor conditionCodeEditor;
    private IObservableValue<Boolean> conditionEnabledValue;
    private IObservableValue<String> conditionCodeValue;

    public RLineBreakpointDetailEditor(boolean mnemonics, boolean autosave, IdentitySet<IPropertyListener> listeners) {
        super(mnemonics, autosave, listeners);
    }

    protected void addContent(Composite composite) {
        Composite options = this.createConditionOptions(composite);
        options.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Composite createConditionOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.conditionEnabledControl = new Button(composite, 32);
        this.conditionEnabledControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.conditionEnabledControl.setText(this.checkLabel("&Conditional / Expression:"));
        RSourceViewerConfigurator viewerConfigurator = new RSourceViewerConfigurator(RCore.WORKBENCH_ACCESS, new RSourceViewerConfiguration(0, null));
        this.conditionCodeEditor = new SnippetEditor((SourceEditorViewerConfigurator)viewerConfigurator);
        this.conditionCodeEditor.create(composite, 0x2000902);
        this.conditionCodeEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    protected void addBindings(DataBindingContext dbc, Realm realm) {
        super.addBindings(dbc, realm);
        this.conditionEnabledValue = new WritableValue(realm, (Object)Boolean.FALSE, Boolean.class);
        this.conditionCodeValue = new WritableValue(realm, (Object)"", String.class);
        this.enableAutosave(dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.conditionEnabledControl), this.conditionEnabledValue));
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.conditionCodeEditor.getTextControl()), this.conditionCodeValue);
        dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.conditionCodeEditor.getTextControl()), this.conditionEnabledValue);
    }

    public void doSetInput(Object input) {
        super.doSetInput(input);
        this.breakpoint = null;
        boolean control = false;
        boolean enabled = false;
        String code = "";
        if (input instanceof RLineBreakpoint) {
            this.breakpoint = (RLineBreakpoint)input;
            int type = 9;
            try {
                type = this.breakpoint.getElementType();
                enabled = this.breakpoint.isConditionEnabled();
                code = this.breakpoint.getConditionExpr();
                if (code == null) {
                    code = "";
                }
            }
            catch (CoreException e) {
                this.logLoadError(e);
            }
            if (type == 9) {
                enabled = false;
                control = false;
            } else {
                control = true;
            }
        }
        this.conditionEnabledControl.setEnabled(control);
        this.conditionEnabledValue.setValue((Object)enabled);
        this.conditionCodeValue.setValue((Object)code);
    }

    public void doSave() {
        super.doSave();
        if (this.breakpoint != null) {
            try {
                this.breakpoint.setConditionEnabled(((Boolean)this.conditionEnabledValue.getValue()).booleanValue());
                this.breakpoint.setConditionExpr((String)this.conditionCodeValue.getValue());
            }
            catch (CoreException e) {
                this.logSaveError(e);
            }
        }
    }
}

