/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableViewer;
import org.eclipse.statet.r.ui.dataeditor.RLiveDataEditorInput;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.services.BasicFQRObjectRef;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RDataEditor {
    public static final String RDATA_EDITOR_ID = "org.eclipse.statet.r.editors.RData";

    private static FQRObjectRef<? extends RTool> createFQRef(RTool tool, RElementName elementName) {
        RElementName envName = elementName.getScope();
        RElementName objName = elementName;
        if (envName == null && RElementName.isScopeType((int)elementName.getType())) {
            envName = elementName;
            objName = elementName.getNextSegment();
        }
        if (envName == null) {
            throw new IllegalArgumentException("elementName not FQ.");
        }
        RElementName next = objName.getNextSegment();
        while (next != null) {
            if (next.getType() == 17) {
                objName = next;
            }
            next = next.getNextSegment();
        }
        envName = RElementName.create((RElementName)envName, (RElementName)objName, (boolean)true);
        objName = RElementName.create((RElementName)objName, null, (boolean)false);
        return new BasicFQRObjectRef((Object)tool, (RObject)new RLanguageImpl(3, envName.getDisplayName(3), null), (RObject)new RLanguageImpl(3, objName.getDisplayName(2), null));
    }

    public static void open(IWorkbenchPage page, RTool tool, RElementName elementName, long[] indexes) {
        RDataEditor.open(page, elementName, RDataEditor.createFQRef(tool, elementName), indexes);
    }

    public static void open(IWorkbenchPage page, RElementName elementName, FQRObjectRef<? extends RTool> elementRef, long[] indexes) {
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new RLiveDataEditorInput(elementName, elementRef), (String)RDATA_EDITOR_ID, (boolean)true);
            RDataTableViewer table = (RDataTableViewer)((Object)editor.getAdapter(RDataTableViewer.class));
            if (indexes != null && table != null) {
                switch (indexes.length) {
                    case 1: {
                        table.setAnchorDataIdxs(0L, indexes[0]);
                        break;
                    }
                    case 2: {
                        table.setAnchorDataIdxs(indexes[1], indexes[0]);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", "Failed to open the R element in the data editor.", (Throwable)e));
        }
    }
}

