/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.statet.internal.r.ui.datafilterview.ExpandableRowComposite;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

@NonNullByDefault
public class ScrolledPageComposite
extends SharedScrolledComposite {
    private static @Nullable FormToolkit gDialogsFormToolkit;
    private final FormToolkit toolkit;
    private @Nullable IExpansionListener expansionListener;
    private int delayReflowCounter;

    private static FormToolkit getViewFormToolkit() {
        FormToolkit toolkit = gDialogsFormToolkit;
        if (toolkit == null) {
            FormColors colors = new FormColors(Display.getCurrent());
            gDialogsFormToolkit = toolkit = new FormToolkit(colors);
        }
        return toolkit;
    }

    public ScrolledPageComposite(Composite parent) {
        this(parent, 768);
    }

    public ScrolledPageComposite(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x100) == 0) {
            this.setExpandHorizontal(true);
        }
        this.setFont(parent.getFont());
        this.toolkit = ScrolledPageComposite.getViewFormToolkit();
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        Composite body = new Composite((Composite)this, 0);
        this.setContent((Control)body);
        this.setFont(parent.getFont());
        this.setBackground(this.toolkit.getColors().getBackground());
    }

    public Composite getContent() {
        return (Composite)super.getContent();
    }

    public void setDelayedReflow(boolean delayedReflow) {
        this.delayReflowCounter = delayedReflow ? ++this.delayReflowCounter : --this.delayReflowCounter;
        super.setDelayedReflow(this.delayReflowCounter > 0);
    }

    public void adaptChild(Control childControl) {
        if (childControl instanceof ExpandableRowComposite) {
            this.toolkit.adapt(childControl, true, false);
            Object expansionListener = this.expansionListener;
            if (expansionListener == null) {
                this.expansionListener = expansionListener = new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        ScrolledPageComposite.this.expandedStateChanged();
                    }
                };
            }
            ((ExpandableRowComposite)childControl).addExpansionListener((IExpansionListener)expansionListener);
        } else if (childControl instanceof Composite) {
            Composite composite = (Composite)childControl;
            this.toolkit.adapt((Control)composite, false, false);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.toolkit.adapt(child, true, false);
                ++n2;
            }
        } else {
            this.toolkit.adapt(childControl, true, false);
        }
    }

    protected void expandedStateChanged() {
        this.reflow(true);
    }
}

