/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class LevelVariableFilter
extends VariableFilter {
    private @Nullable RStore<?> availableValues;
    private final IObservableSet<Object> selectedValues;

    public LevelVariableFilter(FilterSet set, RDataTableColumn column) {
        super(set, column);
        this.selectedValues = new WritableSet(set.getRealm());
        this.registerObservable((IObservable)this.selectedValues);
    }

    @Override
    public FilterType getType() {
        return FilterType.LEVEL;
    }

    @Override
    public void load(VariableFilter filter) {
        if (filter.getType() == FilterType.LEVEL && filter.getColumn().getDataStore().getStoreType() == this.getColumn().getDataStore().getStoreType()) {
            LevelVariableFilter levelFilter = (LevelVariableFilter)filter;
            this.runInRealm(() -> {
                if (this.availableValues == null) {
                    this.availableValues = levelVariableFilter.availableValues;
                }
                this.selectedValues.addAll((Collection)levelFilter.getSelectedValues());
            });
        } else if (filter.getType() == FilterType.TEXT) {
            TextVariableFilter textFilter = (TextVariableFilter)filter;
            this.runInRealm(() -> this.selectedValues.addAll(textFilter.getSelectedValues()));
        }
    }

    @Override
    public void reset() {
        this.runInRealm(() -> this.selectedValues.clear());
    }

    @Override
    protected void updateData(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableColumn column = this.getColumn();
        FunctionCall fcall = r.createFunctionCall("rj:::.getDataLevelValues");
        fcall.add(column.getRExpression());
        fcall.addInt("max", 2000);
        RObject data = fcall.evalData(m);
        if (data.getRObjectType() == 1) {
            this.setStatus((IStatus)new StatusInfo(1, Messages.LevelFilter_TooMuch_message));
            return;
        }
        RDataUtils.checkRVector((RObject)data);
        if (column.getDataStore().getStoreType() == 10) {
            this.setFilterData(RDataUtils.checkData((RStore)data.getData(), (byte)5));
        } else {
            this.setFilterData(RDataUtils.checkData((RStore)data.getData(), (byte)column.getDataStore().getStoreType()));
        }
    }

    @Override
    protected void setStatus(IStatus status) {
        this.runInRealm(() -> {
            this.availableValues = NO_VALUES;
            this.doSetStatus(status);
            this.updateFilter(1);
            this.notifyListeners();
        });
    }

    protected void setFilterData(RStore<?> values) {
        this.runInRealm(() -> {
            if (!values.equals(this.availableValues) || this.getStatus() != null) {
                this.availableValues = values;
                this.clearStatus();
                this.updateFilter(1);
                this.notifyListeners();
            }
        });
    }

    @Override
    protected @Nullable String createFilter(String varExpression) {
        return LevelVariableFilter.createLevelFilter(this.availableValues, this.selectedValues, varExpression);
    }

    static @Nullable String createLevelFilter(@Nullable RStore<?> availableValues, Collection<?> selectedValues, String varExpression) {
        if (availableValues == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int num = 0;
        int na = 0;
        int i = 0;
        while ((long)i < availableValues.getLength()) {
            Object element = availableValues.get(i);
            if (element == null) {
                na = selectedValues.contains(element) ? 1 : -1;
            } else if (selectedValues.contains(element)) {
                if (num > 0) {
                    sb.append(" | ");
                }
                sb.append(varExpression);
                sb.append(" == ");
                if (element instanceof String) {
                    sb.append('\"').append(RUtil.escapeCompletely((String)((String)element))).append('\"');
                } else {
                    sb.append(element);
                }
                ++num;
            }
            ++i;
        }
        if (num > 0 || na > 0) {
            if (na >= 0) {
                if (num > 0) {
                    sb.append(" | ");
                }
                sb.append("is.na(").append(varExpression).append(')');
            } else {
                if (num > 1) {
                    sb.insert(0, '(');
                    sb.append(')');
                }
                if (num > 0) {
                    sb.append(" & ");
                }
                sb.append("!is.na(").append(varExpression).append(')');
            }
            if (na == 1) {
                ++num;
            }
        }
        sb.append(')');
        return sb.length() <= 2 || (long)num == availableValues.getLength() ? "" : sb.toString();
    }

    public RStore<?> getAvailableValues() {
        RCharacter32Store availableValues = this.availableValues;
        return availableValues != null ? availableValues : NO_VALUES;
    }

    public IObservableSet getSelectedValues() {
        return this.selectedValues;
    }
}

