/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.ecommons.debug.core.util.LaunchConfigurationCollector;
import org.eclipse.statet.ecommons.io.win.DDE;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.DocViewerLaunchConfig;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DocViewerCloseDelegate
extends LaunchConfigurationCollector {
    private final List<RestoreRunnable> restoreRunnables = new ArrayList<RestoreRunnable>();

    public static boolean isAvailable() {
        return DDE.isSupported();
    }

    public DocViewerCloseDelegate() {
        super("org.eclipse.statet.docmlet.launchConfigurations.DocViewer");
    }

    protected boolean include(ILaunchConfiguration configuration) throws CoreException {
        return super.include(configuration) && !configuration.getAttribute("org.eclipse.statet.docmlet.base/viewer/PreProduceOutput/DDE.Command.message", "").isEmpty();
    }

    public void run(DocViewerLaunchConfig config, SubMonitor m) throws CoreException {
        ImList configurations = this.getConfigurations();
        if (configurations.isEmpty()) {
            return;
        }
        int workRemaining = configurations.size() * 2 + 1;
        m.beginTask(Messages.PreProduceOutput_task, workRemaining);
        RestoreRunnable runnable = new RestoreRunnable(Display.getDefault());
        runnable.runCheck();
        block8: for (ILaunchConfiguration configuration : configurations) {
            m.setWorkRemaining(workRemaining);
            workRemaining -= 2;
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            try {
                DocViewerLaunchConfig.DDETask ddeTask = config.loadDDETask(configuration, "org.eclipse.statet.docmlet.base/viewer/PreProduceOutput", Messages.DDE_PreProduceOutput_label, m.newChild(1));
                if (ddeTask == null) continue;
                m.newChild(1);
                try {
                    ddeTask.exec();
                    runnable.setLastOK(System.nanoTime());
                }
                catch (CoreException e) {
                    switch (e.getStatus().getCode()) {
                        case 1: {
                            return;
                        }
                        case 2: {
                            continue block8;
                        }
                        default: {
                            throw e;
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        m.setWorkRemaining(workRemaining);
        runnable.scheduleRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelFocus() {
        List<RestoreRunnable> list = this.restoreRunnables;
        synchronized (list) {
            for (RestoreRunnable runnable : this.restoreRunnables) {
                runnable.dispose(false);
            }
            this.restoreRunnables.clear();
        }
    }

    private class RestoreRunnable
    implements Runnable {
        private static final int CHECK = 0;
        private static final int RESTORE = 1;
        private static final int DISPOSED = 2;
        private final Display display;
        private volatile int run = 0;
        private long lastTime = 0L;
        private Shell activeShell;

        public RestoreRunnable(Display display) {
            this.display = display;
        }

        @Override
        public void run() {
            switch (this.run) {
                case 0: {
                    this.run = 1;
                    this.activeShell = this.display.getActiveShell();
                    return;
                }
                case 1: {
                    long diff = (System.nanoTime() - this.lastTime) / 1000000L;
                    if (diff < 500L && this.display.getActiveShell() == null) {
                        Shell shell = null;
                        if (!this.activeShell.isDisposed()) {
                            shell = this.activeShell;
                        } else {
                            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (activeWindow == null) {
                                this.dispose(true);
                                return;
                            }
                            shell = activeWindow.getShell();
                        }
                        if (shell != null && !shell.isDisposed()) {
                            shell.forceActive();
                        }
                    } else if (diff < 200L) {
                        this.display.timerExec(50, (Runnable)this);
                        return;
                    }
                    this.dispose(true);
                    return;
                }
            }
        }

        public void runCheck() {
            if (this.display != null) {
                this.display.syncExec((Runnable)this);
            }
        }

        public void setLastOK(long time) {
            this.lastTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose(boolean remove) {
            this.run = 2;
            if (remove) {
                List<RestoreRunnable> list = DocViewerCloseDelegate.this.restoreRunnables;
                synchronized (list) {
                    DocViewerCloseDelegate.this.restoreRunnables.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRestore() {
            if (this.display != null && this.run > 0 && this.lastTime != 0L && this.activeShell != null) {
                List<RestoreRunnable> list = DocViewerCloseDelegate.this.restoreRunnables;
                synchronized (list) {
                    DocViewerCloseDelegate.this.restoreRunnables.add(this);
                }
                this.display.asyncExec((Runnable)this);
            }
        }
    }
}

