/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public abstract class ControlNode
extends TexAstNode {
    private final String word;
    @Nullable TexCommand command;

    private ControlNode(String word) {
        this.word = word;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONTROL;
    }

    @Override
    public final void acceptInTex(TexAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    public final String getText() {
        return this.word;
    }

    public final @Nullable TexCommand getCommand() {
        return this.command;
    }

    public abstract int getArgsStartOffset();

    static final class Char
    extends ControlNode {
        Char(String word) {
            super(word);
        }

        public boolean hasChildren() {
            return false;
        }

        public int getChildCount() {
            return 0;
        }

        @Override
        public TexAstNode getChild(int index) {
            throw new IndexOutOfBoundsException();
        }

        public int getChildIndex(AstNode element) {
            return -1;
        }

        @Override
        public int getArgsStartOffset() {
            return Integer.MIN_VALUE;
        }

        public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        }

        @Override
        public void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
        }
    }

    static final class Word
    extends ControlNode {
        TexAstNode[] arguments = NO_CHILDREN;

        Word(String word) {
            super(word);
        }

        public boolean hasChildren() {
            return this.arguments.length > 0;
        }

        public int getChildCount() {
            return this.arguments.length;
        }

        @Override
        public TexAstNode getChild(int index) {
            return this.arguments[index];
        }

        public int getChildIndex(AstNode element) {
            int i = 0;
            while (i < this.arguments.length) {
                if (this.arguments[i] == element) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getArgsStartOffset() {
            return this.getStartOffset() + 1 + this.getText().length();
        }

        public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            TexAstNode[] texAstNodeArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                TexAstNode child = texAstNodeArray[n2];
                visitor.visit((AstNode)child);
                ++n2;
            }
        }

        @Override
        public void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
            TexAstNode[] texAstNodeArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                TexAstNode child = texAstNodeArray[n2];
                child.acceptInTex(visitor);
                ++n2;
            }
        }
    }
}

