/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs.groups;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.ecommons.ui.dialogs.groups.Layouter;
import org.eclipse.statet.ecommons.ui.dialogs.groups.OptionsGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class SelectionOptionsGroup<ItemT>
implements OptionsGroup {
    private final boolean fGrabSelectionHorizontal;
    private final boolean fGrabVertical;
    private final List<ItemT> fSelectionModel = new ArrayList<ItemT>();
    private Composite fComposite;

    public SelectionOptionsGroup(boolean grabSelectionHorizontal, boolean grabVertical) {
        this.fGrabSelectionHorizontal = grabSelectionHorizontal;
        this.fGrabVertical = grabVertical;
    }

    public List<ItemT> getListModel() {
        return this.fSelectionModel;
    }

    @Override
    public void createGroup(Composite parent, int hSpan) {
        Layouter layouter = new Layouter(new Composite(parent, 0), 2);
        this.fComposite = layouter.composite;
        this.fComposite.setLayoutData((Object)new GridData(4, 4, true, this.fGrabVertical, hSpan, 1));
        Control selectionControl = this.createSelectionControl(this.fComposite);
        selectionControl.setLayoutData((Object)this.createSelectionGridData());
        Control optionControl = this.createOptionsControl(this.fComposite);
        optionControl.setLayoutData((Object)this.createOptionsGridData());
    }

    protected abstract Control createSelectionControl(Composite var1);

    protected GridData createSelectionGridData() {
        return new GridData(4, 4, this.fGrabSelectionHorizontal, true);
    }

    protected abstract Control createOptionsControl(Composite var1);

    protected GridData createOptionsGridData() {
        return new GridData(4, 4, !this.fGrabSelectionHorizontal, true);
    }

    @Override
    public void initFields() {
    }
}

