/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.util.annotation.ManagedAttribute;

public class MultiplexHttpDestination
extends HttpDestination
implements HttpDestination.Multiplexed {
    public MultiplexHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    @ManagedAttribute(value="The maximum number of concurrent requests per connection")
    public int getMaxRequestsPerConnection() {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof ConnectionPool.Multiplexable) {
            return ((ConnectionPool.Multiplexable)((Object)connectionPool)).getMaxMultiplex();
        }
        return 1;
    }

    @Override
    public void setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof ConnectionPool.Multiplexable) {
            ((ConnectionPool.Multiplexable)((Object)connectionPool)).setMaxMultiplex(maxRequestsPerConnection);
        }
    }
}

