/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.yaml.core.model.ContainerSourceElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.model.YamlCompositeSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;

@NonNullByDefault
public class CompositeSourceElement
extends ContainerSourceElement.SourceContainer
implements YamlCompositeSourceElement {
    private final ImList<? extends YamlSourceElement> compositeElements;
    private final TextRegion sourceRange;
    private volatile @Nullable List<SourceStructElement<?, ?>> allSourceChildren;

    public CompositeSourceElement(List<? extends YamlSourceElement> elements, SourceUnit su, TextRegion sourceRange) {
        super(su, null);
        this.compositeElements = ImCollections.toList(elements);
        this.sourceRange = sourceRange;
    }

    @Override
    public ImList<? extends YamlSourceElement> getCompositeElements() {
        return this.compositeElements;
    }

    @Override
    public TextRegion getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        for (YamlSourceElement element : this.compositeElements) {
            if (!element.hasSourceChildren(filter)) continue;
            return true;
        }
        return false;
    }

    public List<SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        if (filter == null) {
            ImList children = this.allSourceChildren;
            if (children == null) {
                Collection[] compositeLists = new List[this.compositeElements.size()];
                int i = 0;
                while (i < compositeLists.length) {
                    compositeLists[i] = ((YamlSourceElement)this.compositeElements.get(i)).getSourceChildren(null);
                    ++i;
                }
                children = this.allSourceChildren = ImCollections.concatList((Collection[])compositeLists);
            }
            return children;
        }
        ArrayList children = new ArrayList();
        for (YamlSourceElement element : this.compositeElements) {
            List list = element.getSourceChildren(null);
            for (SourceStructElement child : list) {
                if (!filter.include((LtkModelElement)child)) continue;
                children.add(child);
            }
        }
        return children;
    }
}

