/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.util.Set;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.runtime.bundle.Bundles;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class RefClassBundleResolver
implements BundleResolver {
    public static final String ID = "RefClass";

    @Override
    public boolean resolveBundle(BundleSpec bundleSpec, Set<BundleEntry> resolved, MultiStatus status) {
        Class<?> refClass = bundleSpec.getRefClass();
        if (refClass != null) {
            try {
                resolved.add(Bundles.detectEntry(refClass));
                return true;
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("BundleResolver", this.getClass());
        sb.append(' ', ID);
        return sb.toString();
    }
}

