/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.ecommons.emf.ui.forms.EFDataBindingSupport;
import org.eclipse.statet.ecommons.emf.ui.forms.EFEditor;
import org.eclipse.statet.ecommons.emf.ui.forms.EFFormSection;
import org.eclipse.statet.ecommons.emf.ui.forms.EFLayoutUtil;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFModelDescriptor;
import org.eclipse.statet.ecommons.emf.ui.forms.MasterDetailComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class EFFormPage
extends FormPage
implements IEFFormPage {
    private final List<EFFormSection> sections = new ArrayList<EFFormSection>();
    private ISelectionProvider selectionProvider;

    public EFFormPage(EFEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    @Override
    public EFEditor getEditor() {
        return (EFEditor)super.getEditor();
    }

    protected void registerSection(EFFormSection section) {
        this.sections.add(section);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        IToolBarManager manager = form.getToolBarManager();
        this.getEditor().contributeToPages(manager);
        IEFModelDescriptor descriptor = this.getEditor().getModelDescriptor();
        form.setImage(descriptor.getImage());
        form.setText(descriptor.getName());
        Composite body = form.getBody();
        body.setLayout(this.createBodyLayout());
        this.createFormBodyContent(body);
        this.initBindings();
        form.updateToolBar();
        body.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EFFormPage.this.getManagedForm().reflow(true);
            }
        });
    }

    @Override
    public EFToolkit getToolkit() {
        return (EFToolkit)this.getManagedForm().getToolkit();
    }

    protected void initBindings() {
        EFDataBindingSupport databinding = this.getEditor().getDataBinding();
        for (EFFormSection section : this.sections) {
            section.addBindings(databinding);
        }
    }

    protected Layout createBodyLayout() {
        return EFLayoutUtil.createBodyTableLayout(1);
    }

    protected Composite addBodyComposite() {
        IManagedForm managedForm = this.getManagedForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        Composite composite = toolkit.createComposite(body);
        TableWrapData layoutData = new TableWrapData(256);
        layoutData.colspan = ((TableWrapLayout)body.getLayout()).numColumns;
        composite.setLayoutData((Object)layoutData);
        return composite;
    }

    protected MasterDetailComposite addBodySashComposite() {
        IManagedForm managedForm = this.getManagedForm();
        Composite body = managedForm.getForm().getBody();
        MasterDetailComposite composite = new MasterDetailComposite(body, managedForm);
        TableWrapData layoutData = new TableWrapData(256);
        layoutData.colspan = ((TableWrapLayout)body.getLayout()).numColumns;
        composite.setLayoutData(layoutData);
        managedForm.getToolkit().adapt((Composite)composite);
        return composite;
    }

    protected void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.getEditor().getSelectionProvider().update();
    }

    protected abstract void createFormBodyContent(Composite var1);

    @Override
    public void reflow(boolean flushCache) {
        this.getManagedForm().reflow(flushCache);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.equals(ISelectionProvider.class)) {
            return (T)this.selectionProvider;
        }
        return (T)super.getAdapter(adapterType);
    }
}

