/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorProgressHandler;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.rsource.RSourceIndenter;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class RCorrectIndentHandler
extends SourceEditorProgressHandler {
    private @Nullable RSourceIndenter indenter;

    public RCorrectIndentHandler(SourceEditor editor) {
        super(editor);
    }

    protected String getTaskLabel() {
        return RUIMessages.CorrectIndent_task_label;
    }

    protected boolean isEditTask() {
        return true;
    }

    protected void doExecute(final SourceEditor editor, SourceUnit su, ITextSelection selection, IProgressMonitor monitor) throws Exception {
        int n;
        AbstractDocument document = su.getDocument(monitor);
        AstInfo ast = su.getAstInfo(null, true, monitor);
        if (ast == null || monitor.isCanceled()) {
            return;
        }
        monitor.subTask(String.valueOf(this.getTaskLabel()) + "...");
        RSourceIndenter indenter = this.indenter;
        if (indenter == null) {
            this.indenter = indenter = new RSourceIndenter(RHeuristicTokenScanner.create((DocContentSections)editor.getDocumentContentInfo()));
        }
        int startLine = selection.getStartLine();
        final MultiTextEdit edits = new MultiTextEdit();
        List<? extends TextRegion> codeRanges = this.getCodeRanges(document, selection);
        for (TextRegion textRegion : codeRanges) {
            int rStartLine = document.getLineOfOffset(Math.max(selection.getOffset(), textRegion.getStartOffset()));
            int rEndLine = document.getLineOfOffset(Math.min(selection.getOffset() + selection.getLength(), textRegion.getEndOffset()));
            int rEndLineOffset = document.getLineOffset(rEndLine);
            if (rEndLineOffset == textRegion.getEndOffset() || rStartLine < rEndLine && rEndLineOffset == selection.getOffset() + selection.getLength()) {
                --rEndLine;
            }
            if (rStartLine > rEndLine) continue;
            indenter.setup(su instanceof RSourceUnit ? ((RSourceUnit)su).getRCoreAccess() : RCore.getWorkbenchAccess());
            TextEdit rEdits = indenter.getIndentEdits(document, ast.getRoot(), textRegion.getStartOffset(), rStartLine, rEndLine);
            if (rEdits.getChildrenSize() <= 0) continue;
            edits.addChild(rEdits);
        }
        if (edits.getChildrenSize() > 0) {
            su.syncExec(new SourceDocumentRunnable(document, ast.getStamp().getContentStamp(), DocumentRewriteSessionType.SEQUENTIAL){

                public void run() throws InvocationTargetException {
                    try {
                        edits.apply((IDocument)this.getDocument(), 0);
                    }
                    catch (BadLocationException | MalformedTreeException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        if (selection.getLength() == 0 && (n = indenter.getNewIndentOffset(startLine)) >= 0) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIAccess.isOkToUse((Viewer)editor.getViewer())) {
                        editor.selectAndReveal(n, 0);
                    }
                }
            });
        }
    }

    protected List<? extends TextRegion> getCodeRanges(AbstractDocument document, ITextSelection selection) throws BadLocationException {
        ArrayList<BasicTextRegion> regions = new ArrayList<BasicTextRegion>(1);
        regions.add(new BasicTextRegion(0, document.getLength()));
        return regions;
    }
}

