/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.StatusDetail;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

@NonNullByDefault
public class RSourceMessageUtil {
    private static final int FULL_TEXT_LIMIT = 100;
    private static final int START_TEXT_LIMIT = 25;
    private final StringBuilder tmpBuilder = new StringBuilder();
    private SourceContent sourceContent = (SourceContent)ObjectUtils.nonNullLateInit();

    public RSourceMessageUtil(SourceContent sourceContent) {
        this.setSourceContent(sourceContent);
    }

    public RSourceMessageUtil() {
    }

    public void setSourceContent(SourceContent sourceContent) {
        this.sourceContent = (SourceContent)ObjectUtils.nonNullAssert((Object)sourceContent);
    }

    protected final StringBuilder getStringBuilder() {
        this.tmpBuilder.setLength(0);
        return this.tmpBuilder;
    }

    public String getFullText(RAstNode node) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            if (text.length() > 100) {
                StringBuilder sb = this.getStringBuilder();
                sb.append(text, 0, 100);
                sb.append('\u2026');
                return sb.toString();
            }
            return text;
        }
        if (node.getLength() > 100) {
            StringBuilder sb = this.getStringBuilder();
            this.sourceContent.appendStringTo(sb, node.getStartOffset(), node.getStartOffset() + 100);
            sb.append('\u2026');
            return sb.toString();
        }
        return this.sourceContent.getString(node.getStartOffset(), node.getEndOffset());
    }

    public String getStartText(RAstNode node, int offset) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            if (text.length() > 25) {
                StringBuilder sb = this.getStringBuilder();
                sb.append(text, 0, 25);
                sb.append('\u2026');
                return sb.toString();
            }
            return text;
        }
        if (node.getLength() - offset > 25) {
            StringBuilder sb = this.getStringBuilder();
            this.sourceContent.appendStringTo(sb, node.getStartOffset() + offset, node.getStartOffset() + offset + 25);
            sb.append('\u2026');
            return sb.toString();
        }
        return this.sourceContent.getString(node.getStartOffset() + offset, node.getEndOffset());
    }

    public String getDetailText(RAstNode node, int offset, StatusDetail detail) throws BadLocationException {
        String text = node.getText();
        if (text != null) {
            int begin = detail.getStartOffset() - node.getStartOffset() - offset;
            return text.substring(begin, begin + detail.getLength());
        }
        return this.sourceContent.getString(detail.getStartOffset(), detail.getEndOffset());
    }
}

