/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.ecommons.collections.IntMap;
import org.eclipse.statet.ecommons.edb.core.EmbeddedDB;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.CompositeFrame;
import org.eclipse.statet.internal.r.core.builder.RBuildReconciler;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.builder.RPkgReconciler;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelIndexOrder;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.build.RModelIndexUpdate;
import org.eclipse.statet.r.core.model.build.RSourceUnitModelContainer;

@NonNullByDefault
public class RModelIndex {
    private final SourceUnitManager sourceUnitManager;
    private final RBuildReconciler reconciler;
    private final RPkgReconciler pkgParser;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private int dbInitialized;
    private DataSource dbConnectionPool;
    private @Nullable DbTools dbTools;
    private final Map<String, Integer> modelType2Id = new HashMap<String, Integer>();
    private final IntMap<String> modelId2Type = new IntArrayMap();
    private final Map<String, Proj> projects = new ConcurrentHashMap<String, Proj>();
    private final Map<Proj, CompositeFrame> elementsList = new HashMap<Proj, CompositeFrame>();
    private static final ImList<String> R_MODEL_TYPES = ImCollections.newList((Object)"R");

    public RModelIndex(RModelManagerImpl manager) {
        this.sourceUnitManager = LtkModels.getSourceUnitManager();
        this.reconciler = new RBuildReconciler(manager);
        this.pkgParser = new RPkgReconciler();
        this.initDB();
    }

    public void dispose() {
        this.lock.writeLock().lock();
        try {
            this.dbInitialized = 1000;
            this.closeDbTools();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear(IProject project) {
        Proj proj = this.projects.get(project.getName());
        if (proj != null) {
            this.elementsList.remove(proj);
            if (this.dbInitialized == 1) {
                this.lock.writeLock().lock();
                try {
                    try {
                        DbTools tools = this.getDbTools();
                        tools.clearProj(proj.id);
                        tools.connection.commit();
                    }
                    catch (SQLException e) {
                        this.onDbToolsError(e);
                        this.lock.writeLock().unlock();
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    public void update(RProject rProject, IContainer pkgRoot, List<IFile> toRemoveRSU, List<RWorkspaceSourceUnit> toUpdateRSU, MultiStatus status, SubMonitor m) throws CoreException {
        String projName = rProject.getProject().getName();
        boolean updatePkg = pkgRoot != null;
        m.beginTask("", (updatePkg ? 1 : 0) + (toRemoveRSU != null ? 1 : 0));
        this.reconciler.init(rProject, status);
        RModelIndexUpdate indexUpdate = new RModelIndexUpdate(rProject, (List<String>)R_MODEL_TYPES, toRemoveRSU == null);
        if (updatePkg) {
            m.subTask(String.format("Analyzing R package files of '%1$s'...", projName));
            indexUpdate.update(this.pkgParser.parsePkgData(pkgRoot, status, m.newChild(1)));
        }
        m.subTask(String.format("Analyzing R files of '%1$s'...", projName));
        if (toRemoveRSU != null) {
            for (IFile toRemove : toRemoveRSU) {
                indexUpdate.remove(toRemove);
            }
            m.worked(1);
        }
        if (toUpdateRSU != null) {
            for (RWorkspaceSourceUnit sourceUnit : toUpdateRSU) {
                RSourceUnitModelContainer adapter = (RSourceUnitModelContainer)((Object)sourceUnit.getAdapter(RSourceUnitModelContainer.class));
                if (adapter == null) continue;
                try {
                    RSourceUnitModelInfo model = this.reconciler.build(adapter, (IProgressMonitor)m);
                    indexUpdate.update(sourceUnit, model);
                }
                catch (Exception e) {
                    status.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, String.format("An error occurred when indexing '%1$s'.", sourceUnit.getResource().getFullPath().toString()), (Throwable)e));
                }
            }
        }
        m.subTask(String.format("Updating index for '%1$s'...", projName));
        this.update(indexUpdate, (IProgressMonitor)m);
    }

    public void update(RModelIndexUpdate order, IProgressMonitor progress) throws CoreException {
        this.lock.writeLock().lock();
        try {
            DbTools tools;
            if (this.dbInitialized != 1) {
                return;
            }
            Proj proj = this.getOrCreateProjectId(order.rProject, order.pkgData);
            if (proj == null) {
                return;
            }
            CompositeFrame frame = this.elementsList.get(proj);
            if (order.pkgData != null) {
                this.doUpdatePkg(proj, order.pkgData, order.rProject, frame);
            }
            if (order.isFullBuild) {
                this.doClearProj(proj, order.modelTypeIds, frame);
                if (order.updated.isEmpty()) {
                    return;
                }
            }
            if (frame == null) {
                tools = this.getDbTools();
                frame = this.getFrame(proj, order.rProject.getProject(), tools.connection, progress);
                tools.connection.commit();
                if (frame == null) {
                    if (order.isFullBuild) {
                        frame = new CompositeFrame(this.lock, proj.getPkgName(), order.projectName);
                        this.elementsList.put(proj, frame);
                    } else {
                        return;
                    }
                }
            }
            try {
                tools = null;
                PreparedStatement updateExportsStatement = null;
                PreparedStatement insertExportsStatement = null;
                PreparedStatement insertMainNameStatement = null;
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                for (RModelIndexOrder.Result updated : order.updated) {
                    if (tools == null) {
                        tools = this.getDbTools();
                        tools.prepareUnits(proj);
                        insertExportsStatement = tools.connection.prepareStatement("insert into RINDEX.EXPORTS (SU_ID, OBJECTDATA) values (?, ?)");
                        updateExportsStatement = tools.connection.prepareStatement("update RINDEX.EXPORTS set OBJECTDATA= ? where (SU_ID= ?)");
                        insertMainNameStatement = tools.connection.prepareStatement("insert into RINDEX.MAINNAMES (SU_ID, NAME_ID) values (?, ?)");
                    }
                    SourceUnit sourceUnit = updated.exportedElement.getSourceUnit();
                    int modelId = this.getOrCreateModelId(sourceUnit.getModelTypeId());
                    RUnitElement previous = frame.setModelElement(updated.unitId, updated.exportedElement);
                    order.removed.remove(updated.unitId);
                    tools.executeGetOrAddUnit(updated.unitId, modelId);
                    byteOutput.reset();
                    updated.exportedElement.save(byteOutput);
                    byte[] objectBytes = byteOutput.toByteArray();
                    ByteArrayInputStream objectStream = new ByteArrayInputStream(objectBytes);
                    try {
                        if (tools.currentUnitNew) {
                            insertExportsStatement.setLong(1, tools.currentUnitId);
                            insertExportsStatement.setBinaryStream(2, (InputStream)objectStream, objectBytes.length);
                            insertExportsStatement.execute();
                        } else {
                            updateExportsStatement.setLong(2, tools.currentUnitId);
                            updateExportsStatement.setBinaryStream(1, (InputStream)objectStream, objectBytes.length);
                            updateExportsStatement.execute();
                            tools.clearUnitNames();
                        }
                        insertMainNameStatement.setLong(1, tools.currentUnitId);
                        for (String name : updated.defaultNames) {
                            if (name == null) continue;
                            insertMainNameStatement.setLong(2, tools.getOrAddName(name));
                            insertMainNameStatement.executeUpdate();
                        }
                        tools.connection.commit();
                    }
                    catch (SQLException e) {
                        try {
                            if (insertExportsStatement != null) {
                                insertExportsStatement.close();
                            }
                            if (updateExportsStatement != null) {
                                updateExportsStatement.close();
                            }
                            if (insertMainNameStatement != null) {
                                insertMainNameStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.onDbToolsError(e);
                        tools = null;
                    }
                }
                if (!order.removed.isEmpty()) {
                    if (tools == null) {
                        tools = this.getDbTools();
                        tools.prepareUnits(proj);
                    }
                    for (String unitId : order.removed) {
                        frame.removeModelElement(unitId);
                        try {
                            tools.executeRemoveUnit(unitId);
                        }
                        catch (SQLException e) {
                            RModelIndex.logDBWarning(e, "(will continue with next)");
                        }
                    }
                    tools.connection.commit();
                }
            }
            catch (IOException | SQLException e) {
                this.onDbToolsError(e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private @Nullable CompositeFrame getFrame(Proj proj, IProject project, @Nullable Connection connection, @Nullable IProgressMonitor monitor) throws SQLException, CoreException {
        CompositeFrame frame = this.elementsList.get(proj);
        if (frame == null && project.isOpen()) {
            HashMap<String, RUnitElement> elements = new HashMap<String, RUnitElement>();
            frame = new CompositeFrame(this.lock, proj.getPkgName(), project.getName(), elements);
            this.elementsList.put(proj, frame);
            if (this.dbInitialized == 1) {
                Connection newConnection = null;
                PreparedStatement statement = null;
                try {
                    if (connection == null) {
                        connection = newConnection = this.dbConnectionPool.getConnection();
                    }
                    statement = connection.prepareStatement("select S.NAME, S.MODEL_TYPE_ID, E.OBJECTDATA from RINDEX.SUS as S inner join RINDEX.EXPORTS as E on (E.SU_ID= S.ID) where (S.PROJECT_ID= ?)");
                    statement.setInt(1, proj.id);
                    ResultSet result = statement.executeQuery();
                    while (result.next()) {
                        SourceUnit su = null;
                        try {
                            try {
                                String unitId = result.getString(1);
                                String modelTypeId = (String)this.modelId2Type.get(result.getInt(2));
                                assert (unitId != null && modelTypeId != null);
                                su = this.sourceUnitManager.getSourceUnit(modelTypeId, Ltk.PERSISTENCE_CONTEXT, (Object)unitId, true, monitor);
                                if (su instanceof RSourceUnit) {
                                    InputStream inputStream = result.getBlob(3).getBinaryStream();
                                    RUnitElement unitElement = RUnitElement.read((RSourceUnit)su, frame, inputStream);
                                    elements.put(su.getId(), unitElement);
                                }
                            }
                            catch (IOException | ClassNotFoundException e) {
                                this.onDbReadError(e);
                                if (su == null) continue;
                                su.disconnect(monitor);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (su != null) {
                                su.disconnect(monitor);
                            }
                            throw throwable;
                        }
                        if (su == null) continue;
                        su.disconnect(monitor);
                    }
                }
                finally {
                    if (newConnection != null) {
                        try {
                            newConnection.close();
                        }
                        catch (SQLException sQLException) {}
                    } else if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
        return frame;
    }

    private int getOrCreateModelId(String modelTypeId) throws SQLException {
        Integer id = this.modelType2Id.get(modelTypeId);
        if (id == null) {
            DbTools tools = this.getDbTools();
            id = tools.addModel(modelTypeId);
            tools.connection.commit();
            this.modelType2Id.put(modelTypeId, id);
            this.modelId2Type.put((Object)id, (Object)modelTypeId);
        }
        return id;
    }

    private @Nullable Proj getOrCreateProjectId(RProjectNature rProject, @Nullable RPkgData pkgData) throws SQLException {
        IProject project = rProject.getProject();
        Proj proj = this.projects.get(project.getName());
        if (proj == null) {
            if (!project.isOpen() || RProjectNature.getRProject(project) == null) {
                return null;
            }
            String name = project.getName();
            String pkgName = pkgData != null ? pkgData.getPkgName() : null;
            DbTools tools = this.getDbTools();
            int id = tools.addProj(name, pkgName);
            tools.connection.commit();
            proj = new Proj(id, name, pkgName);
            rProject.updateRPkgConfig(pkgName);
            this.projects.put(name, proj);
        }
        return proj;
    }

    private void doClearProj(Proj proj, List<String> modelTypeIds, @Nullable CompositeFrame frame) throws SQLException {
        DbTools tools = this.getDbTools();
        for (String modelTypeId : modelTypeIds) {
            if (frame != null) {
                frame.removeModelElements(modelTypeId);
            }
            int modelId = this.getOrCreateModelId(modelTypeId);
            tools.clearProj(proj.id, modelId);
        }
        tools.connection.commit();
    }

    private void doUpdatePkg(Proj proj, RPkgData pkgData, RProjectNature rProject, CompositeFrame frame) throws SQLException {
        if (Objects.equals(proj.getPkgName(), pkgData.getPkgName())) {
            return;
        }
        DbTools tools = this.getDbTools();
        proj.setPkgName(pkgData.getPkgName());
        rProject.updateRPkgConfig(pkgData.getPkgName());
        if (frame != null) {
            this.elementsList.put(proj, new CompositeFrame(this.lock, pkgData.getPkgName(), proj.name, frame));
        }
        tools.updateProj(proj);
        tools.connection.commit();
    }

    private void initDB() {
        if (this.dbInitialized != 0) {
            return;
        }
        this.dbInitialized = -1;
        try {
            IPath location = RCorePlugin.getInstance().getStateLocation();
            File directory = location.append("db").toFile();
            this.dbConnectionPool = EmbeddedDB.createConnectionPool((String)directory.getAbsolutePath());
            if (this.dbConnectionPool != null && this.checkVersion() && this.loadModelTypes() && this.checkProjects()) {
                this.dbInitialized = 1;
            }
        }
        catch (Exception e) {
            this.dbInitialized = -1;
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occurred when initializing DB for model.", (Throwable)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkVersion() {
        Connection connection = null;
        try {
            Statement statement;
            Object var5_9;
            Throwable throwable;
            connection = this.dbConnectionPool.getConnection();
            connection.setAutoCommit(false);
            ResultSet schemas = connection.getMetaData().getSchemas();
            boolean schemaExists = false;
            while (schemas.next()) {
                if (!"RINDEX".equals(schemas.getString(1))) continue;
                schemaExists = true;
                break;
            }
            if (schemaExists) {
                Object tableName;
                try {
                    throwable = null;
                    var5_9 = null;
                    try {
                        block47: {
                            statement = connection.createStatement();
                            ResultSet result = statement.executeQuery("select VALUE from RINDEX.PROPERTIES where (NAME= 'version')");
                            if (!result.next() || !"18".equals(result.getString(1))) break block47;
                            if (statement == null) return true;
                            {
                                catch (Throwable throwable2) {
                                    if (statement == null) throw throwable2;
                                    statement.close();
                                    throw throwable2;
                                }
                            }
                            statement.close();
                            return true;
                        }
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ArrayList<String> names = new ArrayList<String>();
                ResultSet tables = connection.getMetaData().getTables(null, "RINDEX", null, new String[]{"TABLE"});
                while (tables.next()) {
                    tableName = tables.getString("TABLE_NAME");
                    if (tableName == null) continue;
                    names.add((String)tableName);
                }
                if (names.remove("NAMESIDX")) {
                    names.add("NAMESIDX");
                }
                if (names.remove("SUS")) {
                    names.add("SUS");
                }
                if (names.remove("PROJECTS")) {
                    names.add("PROJECTS");
                }
                if (names.remove("MODELS")) {
                    names.add("MODELS");
                }
                tableName = null;
                Object var7_14 = null;
                try (Statement statement2 = connection.createStatement();){
                    for (String name : names) {
                        statement2.execute("drop table RINDEX." + name);
                    }
                }
                catch (Throwable throwable4) {
                    if (tableName == null) {
                        tableName = throwable4;
                        throw tableName;
                    }
                    if (tableName == throwable4) throw tableName;
                    ((Throwable)tableName).addSuppressed(throwable4);
                    throw tableName;
                }
            }
            throwable = null;
            var5_9 = null;
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("create table RINDEX.PROPERTIES (NAME varchar(512) not null primary key, VALUE varchar(4096))");
                    statement.execute("create table RINDEX.MODELS (ID int not null primary key generated always as identity (start with 0), MODEL_TYPE varchar(512) not null, unique (MODEL_TYPE))");
                    statement.execute("create table RINDEX.PROJECTS (ID int not null primary key generated always as identity, NAME varchar(512) not null, PKG_NAME varchar(512), unique (NAME))");
                    statement.execute("create table RINDEX.SUS (ID bigint not null primary key generated always as identity, PROJECT_ID int not null references RINDEX.PROJECTS on delete cascade, NAME varchar(4096) not null, MODEL_TYPE_ID int not null references RINDEX.MODELS on delete cascade, unique (PROJECT_ID, NAME))");
                    statement.execute("create table RINDEX.NAMESIDX (ID bigint not null primary key generated always as identity, NAME varchar(512) not null, unique (NAME))");
                    statement.execute("create table RINDEX.MAINNAMES (SU_ID bigint not null references RINDEX.SUS on delete cascade, NAME_ID bigint not null references RINDEX.NAMESIDX on delete cascade, primary key (SU_ID, NAME_ID))");
                    statement.execute("create table RINDEX.EXPORTS (SU_ID bigint not null primary key references RINDEX.SUS on delete cascade, OBJECTDATA blob)");
                    statement.execute("insert into RINDEX.PROPERTIES (NAME, VALUE) values ('version', '18')");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
            connection.commit();
            return true;
        }
        catch (SQLException e) {
            this.onDbToolsError(e);
            return false;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean loadModelTypes() {
        block13: {
            this.modelType2Id.clear();
            this.modelId2Type.clear();
            DbTools tools = this.getDbTools();
            Throwable throwable = null;
            Object var3_5 = null;
            Statement statement = tools.connection.createStatement();
            try {
                ResultSet result = statement.executeQuery("select MODEL_TYPE, ID from RINDEX.MODELS");
                while (result.next()) {
                    String modelTypeId = result.getString(1).intern();
                    int id = result.getInt(2);
                    this.modelType2Id.put(modelTypeId, id);
                    this.modelId2Type.put(id, (Object)modelTypeId);
                }
                if (statement == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    this.modelType2Id.clear();
                    this.modelId2Type.clear();
                    this.onDbToolsError(e);
                    return false;
                }
            }
            statement.close();
        }
        return true;
    }

    private boolean checkProjects() {
        block16: {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            DbTools tools = this.getDbTools();
            Throwable throwable = null;
            Object var4_6 = null;
            Statement statement = tools.connection.createStatement();
            try {
                ResultSet result = statement.executeQuery("select ID, NAME, PKG_NAME from RINDEX.PROJECTS");
                while (result.next()) {
                    int id = result.getInt(1);
                    String name = result.getString(2).intern();
                    String pkgName = result.getString(3);
                    IProject project = root.getProject(name);
                    if (project != null && project.isOpen()) {
                        Proj proj = new Proj(id, name, pkgName);
                        this.projects.put(name, proj);
                        continue;
                    }
                    try {
                        tools.removeProj(id);
                        tools.connection.commit();
                    }
                    catch (SQLException e) {
                        RModelIndex.logDBWarning(e, "(will continue with next)");
                    }
                }
                if (statement == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    this.projects.clear();
                    this.onDbToolsError(e);
                    return false;
                }
            }
            statement.close();
        }
        return true;
    }

    private void removeProject(String projectName) {
        Proj proj = this.projects.remove(projectName);
        if (proj != null) {
            proj.removed = true;
            if (this.dbInitialized == 1) {
                try {
                    DbTools tools = this.getDbTools();
                    tools.removeProj(proj.id);
                    tools.connection.commit();
                }
                catch (SQLException e) {
                    this.onDbToolsError(e);
                }
            }
        }
    }

    public void updateProjectConfigRemoved(IProject project) {
        this.lock.writeLock().lock();
        try {
            this.removeProject(project.getName());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateProjectConfigClosed(IProject project) {
        this.lock.writeLock().lock();
        try {
            this.removeProject(project.getName());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static void logDBWarning(Exception e, String info) {
        RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occurred when replicate model to DB. " + info, (Throwable)e));
    }

    private DbTools getDbTools() throws SQLException {
        DbTools dbTools = this.dbTools;
        if (dbTools == null) {
            if (this.dbInitialized > 1) {
                throw new SQLException("DB is closed.");
            }
            this.dbTools = dbTools = new DbTools(this.dbConnectionPool.getConnection());
        }
        return dbTools;
    }

    private void onDbToolsError(Exception e) {
        RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occurred when replicate model to DB.", (Throwable)e));
        DbTools dbTools = this.dbTools;
        if (dbTools != null) {
            try {
                this.dbTools = null;
                dbTools.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeDbTools() {
        DbTools dbTools = this.dbTools;
        if (dbTools != null) {
            try {
                this.dbTools = null;
                dbTools.connection.close();
            }
            catch (SQLException e) {
                this.onDbToolsError(e);
            }
        }
    }

    private void onDbReadError(Exception e) throws CoreException {
        if (e instanceof SQLException && "08000".equals(((SQLException)e).getSQLState())) {
            RCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.core", -1, "Thread was interrupted when searching index in DB.", (Throwable)e));
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occurred when searching index in DB.", (Throwable)e));
    }

    public @Nullable RFrame getProjectFrame(RProject rProject) throws CoreException {
        Proj proj = this.projects.get(rProject.getProject().getName());
        if (proj != null) {
            this.lock.readLock().lock();
            try {
                CompositeFrame compositeFrame = this.getFrame(proj, rProject.getProject(), null, null);
                return compositeFrame;
            }
            catch (SQLException e) {
                this.onDbReadError(e);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return null;
    }

    public Set<String> getPkgNames() {
        HashSet<String> names = new HashSet<String>(this.projects.size());
        for (Proj proj : this.projects.values()) {
            String pkgName = proj.getPkgName();
            if (pkgName == null) continue;
            names.add(pkgName);
        }
        return names;
    }

    public @Nullable String getPkgName(String projectName) {
        Proj proj = this.projects.get(projectName);
        if (proj != null) {
            return proj.getPkgName();
        }
        return null;
    }

    public @Nullable String getPkgProject(String pkgName) throws CoreException {
        for (Proj proj : this.projects.values()) {
            if (!pkgName.equals(proj.getPkgName())) continue;
            return proj.name;
        }
        return null;
    }

    public @Nullable List<SourceUnit> findReferencingSourceUnits(RProject rProject, RElementName name, IProgressMonitor monitor) throws CoreException {
        ArrayList<SourceUnit> arrayList;
        if (name.getNextSegment() != null || name.getType() != 17 || name.getSegmentName() == null) {
            throw new UnsupportedOperationException("Only common top level names are supported.");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        SourceUnitManager suManager = LtkModels.getSourceUnitManager();
        ArrayList<SourceUnit> matches = new ArrayList<SourceUnit>();
        Proj proj = this.projects.get(rProject.getProject().getName());
        this.lock.readLock().lock();
        Connection connection = null;
        try {
            if (proj == null || proj.isRemoved() || this.dbInitialized != 1) {
                return null;
            }
            connection = this.dbConnectionPool.getConnection();
            PreparedStatement statement = connection.prepareStatement("select S.NAME, S.MODEL_TYPE_ID from RINDEX.SUS as S inner join RINDEX.MAINNAMES as M on (M.SU_ID= S.ID) inner join RINDEX.NAMESIDX as N on (M.NAME_ID= N.ID) where (S.PROJECT_ID= ? and N.NAME= ?)");
            statement.setInt(1, proj.id);
            statement.setString(2, name.getSegmentName());
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                String unitId = result.getString(1);
                String modelTypeId = (String)this.modelId2Type.get(result.getInt(2));
                assert (unitId != null && modelTypeId != null);
                SourceUnit su = this.loadSourceUnit(suManager, unitId, modelTypeId, progress);
                if (su == null) continue;
                matches.add(su);
            }
            arrayList = matches;
        }
        catch (SQLException e) {
            this.onDbReadError(e);
            this.closeSourceUnits(matches, progress);
            return null;
        }
        finally {
            this.lock.readLock().unlock();
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }

    private @Nullable SourceUnit loadSourceUnit(SourceUnitManager manager, String sourceUnitId, String modelTypeId, SubMonitor progress) {
        try {
            return manager.getSourceUnit(modelTypeId, Ltk.PERSISTENCE_CONTEXT, (Object)sourceUnitId, true, (IProgressMonitor)progress);
        }
        catch (Exception e) {
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, String.format("An error occurred when restoring source unit '%1$s' for model '%2$s'.", sourceUnitId, modelTypeId), (Throwable)e));
            return null;
        }
    }

    private void closeSourceUnits(List<SourceUnit> sourceUnits, SubMonitor progress) {
        for (SourceUnit su : sourceUnits) {
            su.disconnect((IProgressMonitor)progress);
        }
    }

    private static class DbTools {
        private static final String MISSING_GENERATED_RESULT = "Unexpected result (generatedKeys).";
        public final Connection connection;
        private @Nullable PreparedStatement addModel;
        private @Nullable PreparedStatement addProj;
        private @Nullable PreparedStatement updateProj;
        private @Nullable PreparedStatement removeProjStatement;
        private @Nullable PreparedStatement clearProjStatement;
        private @Nullable PreparedStatement clearProjModelStatement;
        public Proj currentProj;
        public long currentUnitId;
        public boolean currentUnitNew;
        private @Nullable PreparedStatement getUnitStatement;
        private @Nullable PreparedStatement addUnitStatement;
        private @Nullable PreparedStatement updateUnitModelStatement;
        private @Nullable PreparedStatement removeUnitStatement;
        private @Nullable PreparedStatement removeUnitMainNamesStatement;
        private @Nullable PreparedStatement getNameStatement;
        private @Nullable PreparedStatement addNameStatement;

        public DbTools(Connection connection) throws SQLException {
            this.connection = connection;
            this.connection.setAutoCommit(false);
        }

        public int addModel(String modelTypeId) throws SQLException {
            PreparedStatement statement = this.addModel;
            if (statement == null) {
                this.addModel = statement = this.connection.prepareStatement("insert into RINDEX.MODELS (MODEL_TYPE) values (?)", new String[]{"ID"});
            }
            statement.setString(1, modelTypeId);
            statement.executeUpdate();
            ResultSet result = statement.getGeneratedKeys();
            if (result.next()) {
                return result.getInt(1);
            }
            throw new SQLException(MISSING_GENERATED_RESULT);
        }

        public int addProj(String name, @Nullable String pkgName) throws SQLException {
            PreparedStatement statement = this.addProj;
            if (statement == null) {
                this.addProj = statement = this.connection.prepareStatement("insert into RINDEX.PROJECTS (NAME, PKG_NAME) values (?, ?)", new String[]{"ID"});
            }
            statement.setString(1, name);
            statement.setString(2, pkgName);
            statement.executeUpdate();
            ResultSet result = statement.getGeneratedKeys();
            if (result.next()) {
                return result.getInt(1);
            }
            throw new SQLException(MISSING_GENERATED_RESULT);
        }

        public void updateProj(Proj proj) throws SQLException {
            PreparedStatement statement = this.updateProj;
            if (statement == null) {
                this.updateProj = statement = this.connection.prepareStatement("update RINDEX.PROJECTS set PKG_NAME= ? where (ID= ?)");
            }
            statement.setString(1, proj.getPkgName());
            statement.setInt(2, proj.id);
            statement.executeUpdate();
        }

        public void removeProj(int projId) throws SQLException {
            PreparedStatement statement = this.removeProjStatement;
            if (statement == null) {
                this.removeProjStatement = statement = this.connection.prepareStatement("delete from RINDEX.PROJECTS where (ID= ?)");
            }
            statement.setInt(1, projId);
            statement.executeUpdate();
        }

        public void clearProj(int projId) throws SQLException {
            PreparedStatement statement = this.clearProjStatement;
            if (statement == null) {
                this.clearProjStatement = statement = this.connection.prepareStatement("delete from RINDEX.SUS where (PROJECT_ID= ?)");
            }
            statement.setInt(1, projId);
            statement.executeUpdate();
        }

        public void clearProj(int projId, int modelId) throws SQLException {
            PreparedStatement statement = this.clearProjModelStatement;
            if (statement == null) {
                this.clearProjModelStatement = statement = this.connection.prepareStatement("delete from RINDEX.SUS where (PROJECT_ID= ? and MODEL_TYPE_ID= ?)");
            }
            statement.setInt(1, projId);
            statement.setInt(2, modelId);
            statement.executeUpdate();
        }

        public void prepareUnits(Proj proj) throws SQLException {
            this.currentProj = proj;
            PreparedStatement statement = this.getUnitStatement;
            if (statement == null) {
                this.getUnitStatement = statement = this.connection.prepareStatement("select ID, MODEL_TYPE_ID from RINDEX.SUS where (PROJECT_ID= ? and NAME= ?)");
            }
            statement.setInt(1, proj.id);
            statement = this.addUnitStatement;
            if (statement == null) {
                this.addUnitStatement = statement = this.connection.prepareStatement("insert into RINDEX.SUS (PROJECT_ID, NAME, MODEL_TYPE_ID) values (?, ?, ?)", new String[]{"ID"});
            }
            statement.setInt(1, proj.id);
        }

        public void executeGetOrAddUnit(String unitId, int modelId) throws SQLException {
            PreparedStatement statement = (PreparedStatement)ObjectUtils.nonNullAssert((Object)this.getUnitStatement);
            statement.setString(2, unitId);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                this.currentUnitId = result.getLong(1);
                this.currentUnitNew = false;
                if (result.getInt(2) != modelId) {
                    PreparedStatement updateStatement = this.updateUnitModelStatement;
                    if (updateStatement == null) {
                        this.updateUnitModelStatement = updateStatement = this.connection.prepareStatement("update RINDEX.SUS set MODEL_TYPE_ID= ? where (ID= ?)");
                    }
                    updateStatement.setInt(1, modelId);
                    updateStatement.setLong(2, this.currentUnitId);
                    updateStatement.execute();
                }
                return;
            }
            statement = (PreparedStatement)ObjectUtils.nonNullAssert((Object)this.addUnitStatement);
            statement.setString(2, unitId);
            statement.setInt(3, modelId);
            statement.executeUpdate();
            result = statement.getGeneratedKeys();
            if (result.next()) {
                this.currentUnitId = result.getLong(1);
                this.currentUnitNew = true;
                return;
            }
            throw new SQLException(MISSING_GENERATED_RESULT);
        }

        public boolean executeGetUnit(String publicId) throws SQLException {
            PreparedStatement statement = (PreparedStatement)ObjectUtils.nonNullAssert((Object)this.getUnitStatement);
            statement.setString(2, publicId);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                this.currentUnitId = result.getInt(1);
                this.currentUnitNew = false;
                return true;
            }
            return false;
        }

        public void executeRemoveUnit(String unitId) throws SQLException {
            PreparedStatement statement = this.removeUnitStatement;
            if (statement == null) {
                this.removeUnitStatement = statement = this.connection.prepareStatement("delete from RINDEX.SUS where (PROJECT_ID= ? and NAME= ?)");
            }
            statement.setInt(1, this.currentProj.id);
            statement.setString(2, unitId);
            statement.executeUpdate();
        }

        public void clearUnitNames() throws SQLException {
            PreparedStatement statement = this.removeUnitMainNamesStatement;
            if (statement == null) {
                this.removeUnitMainNamesStatement = statement = this.connection.prepareStatement("delete from RINDEX.MAINNAMES where (SU_ID= ?)");
            }
            statement.setLong(1, this.currentUnitId);
            statement.executeUpdate();
        }

        public long getOrAddName(String name) throws SQLException {
            PreparedStatement statement = this.getNameStatement;
            if (statement == null) {
                this.getNameStatement = statement = this.connection.prepareStatement("select ID from RINDEX.NAMESIDX where (NAME= ?)");
            }
            statement.setString(1, name);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                return result.getLong(1);
            }
            statement = this.addNameStatement;
            if (statement == null) {
                this.addNameStatement = statement = this.connection.prepareStatement("insert into RINDEX.NAMESIDX (NAME) values (?)", new String[]{"ID"});
            }
            statement.setString(1, name);
            statement.executeUpdate();
            result = statement.getGeneratedKeys();
            if (result.next()) {
                return result.getLong(1);
            }
            throw new SQLException(MISSING_GENERATED_RESULT);
        }
    }

    private static final class Proj {
        public final int id;
        public final String name;
        private boolean removed;
        private volatile @Nullable String pkgName;

        public Proj(int id, String name, @Nullable String pkgName) {
            this.id = id;
            this.name = name;
            this.removed = false;
            this.setPkgName(pkgName);
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setPkgName(@Nullable String pkgName) {
            this.pkgName = pkgName != null ? pkgName.intern() : null;
        }

        public @Nullable String getPkgName() {
            return this.pkgName;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Proj) {
                return this.id == ((Proj)obj).id;
            }
            return false;
        }
    }

    private static final class RIndex {
        static final String NAME = "RINDEX";
        static final String VERSION = "18";

        private RIndex() {
        }

        static final class Exports {
            static final String NAME = "EXPORTS";
            static final String QNAME = "RINDEX.EXPORTS";
            static final String COL_SU_ID = "SU_ID";
            static final String COL_OBJECTDATA = "OBJECTDATA";
            static final String DEFINE_1 = "create table RINDEX.EXPORTS (SU_ID bigint not null primary key references RINDEX.SUS on delete cascade, OBJECTDATA blob)";
            static final String OP_insert = "insert into RINDEX.EXPORTS (SU_ID, OBJECTDATA) values (?, ?)";
            static final String OP_update = "update RINDEX.EXPORTS set OBJECTDATA= ? where (SU_ID= ?)";
            static final String OP_getAll_ofProject = "select S.NAME, S.MODEL_TYPE_ID, E.OBJECTDATA from RINDEX.SUS as S inner join RINDEX.EXPORTS as E on (E.SU_ID= S.ID) where (S.PROJECT_ID= ?)";

            Exports() {
            }
        }

        static final class MainNames {
            static final String NAME = "MAINNAMES";
            static final String QNAME = "RINDEX.MAINNAMES";
            static final String COL_SU_ID = "SU_ID";
            static final String COL_NAME_ID = "NAME_ID";
            static final String DEFINE_1 = "create table RINDEX.MAINNAMES (SU_ID bigint not null references RINDEX.SUS on delete cascade, NAME_ID bigint not null references RINDEX.NAMESIDX on delete cascade, primary key (SU_ID, NAME_ID))";
            static final String OP_insert = "insert into RINDEX.MAINNAMES (SU_ID, NAME_ID) values (?, ?)";
            static final String OP_deleteAll_ofSourceUnit = "delete from RINDEX.MAINNAMES where (SU_ID= ?)";
            static final String OP_findSourceUnits_ofProjectAndName = "select S.NAME, S.MODEL_TYPE_ID from RINDEX.SUS as S inner join RINDEX.MAINNAMES as M on (M.SU_ID= S.ID) inner join RINDEX.NAMESIDX as N on (M.NAME_ID= N.ID) where (S.PROJECT_ID= ? and N.NAME= ?)";

            MainNames() {
            }
        }

        static final class Models {
            static final String NAME = "MODELS";
            static final String QNAME = "RINDEX.MODELS";
            static final String COL_MODEL_TYPE = "MODEL_TYPE";
            static final String COL_ID = "ID";
            static final String DEFINE_1 = "create table RINDEX.MODELS (ID int not null primary key generated always as identity (start with 0), MODEL_TYPE varchar(512) not null, unique (MODEL_TYPE))";
            static final String OP_insert = "insert into RINDEX.MODELS (MODEL_TYPE) values (?)";
            static final String OP_getAll = "select MODEL_TYPE, ID from RINDEX.MODELS";

            Models() {
            }
        }

        static final class NamesIdx {
            static final String NAME = "NAMESIDX";
            static final String QNAME = "RINDEX.NAMESIDX";
            static final String COL_ID = "ID";
            static final String COL_NAME = "NAME";
            static final String DEFINE_1 = "create table RINDEX.NAMESIDX (ID bigint not null primary key generated always as identity, NAME varchar(512) not null, unique (NAME))";
            static final String OP_insert = "insert into RINDEX.NAMESIDX (NAME) values (?)";
            static final String OP_getID = "select ID from RINDEX.NAMESIDX where (NAME= ?)";

            NamesIdx() {
            }
        }

        static final class Projects {
            static final String NAME = "PROJECTS";
            static final String QNAME = "RINDEX.PROJECTS";
            static final String COL_NAME = "NAME";
            static final String COL_ID = "ID";
            static final String COL_PKG_NAME = "PKG_NAME";
            static final String DEFINE_1 = "create table RINDEX.PROJECTS (ID int not null primary key generated always as identity, NAME varchar(512) not null, PKG_NAME varchar(512), unique (NAME))";
            static final String OP_insert = "insert into RINDEX.PROJECTS (NAME, PKG_NAME) values (?, ?)";
            static final String OP_update = "update RINDEX.PROJECTS set PKG_NAME= ? where (ID= ?)";
            static final String OP_delete = "delete from RINDEX.PROJECTS where (ID= ?)";
            static final String OP_getAll = "select ID, NAME, PKG_NAME from RINDEX.PROJECTS";

            Projects() {
            }
        }

        static final class Properties {
            static final String NAME = "PROPERTIES";
            static final String QNAME = "RINDEX.PROPERTIES";
            static final String COL_NAME = "NAME";
            static final String COL_VALUE = "VALUE";
            static final String DEFINE_1 = "create table RINDEX.PROPERTIES (NAME varchar(512) not null primary key, VALUE varchar(4096))";

            Properties() {
            }
        }

        static final class SourceUnits {
            static final String NAME = "SUS";
            static final String QNAME = "RINDEX.SUS";
            static final String COL_PROJECT_ID = "PROJECT_ID";
            static final String COL_NAME = "NAME";
            static final String COL_ID = "ID";
            static final String COL_MODEL_TYPE_ID = "MODEL_TYPE_ID";
            static final String DEFINE_1 = "create table RINDEX.SUS (ID bigint not null primary key generated always as identity, PROJECT_ID int not null references RINDEX.PROJECTS on delete cascade, NAME varchar(4096) not null, MODEL_TYPE_ID int not null references RINDEX.MODELS on delete cascade, unique (PROJECT_ID, NAME))";
            static final String OP_insert = "insert into RINDEX.SUS (PROJECT_ID, NAME, MODEL_TYPE_ID) values (?, ?, ?)";
            static final String OP_updateModel = "update RINDEX.SUS set MODEL_TYPE_ID= ? where (ID= ?)";
            static final String OP_delete_byProjectAndName = "delete from RINDEX.SUS where (PROJECT_ID= ? and NAME= ?)";
            static final String OP_deleteAll_ofProject = "delete from RINDEX.SUS where (PROJECT_ID= ?)";
            static final String OP_deleteAll_ofProjectAndModel = "delete from RINDEX.SUS where (PROJECT_ID= ? and MODEL_TYPE_ID= ?)";
            static final String OP_get = "select ID, MODEL_TYPE_ID from RINDEX.SUS where (PROJECT_ID= ? and NAME= ?)";

            SourceUnits() {
            }
        }
    }
}

