/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgInfoAndData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgListImpl;
import org.eclipse.statet.internal.r.core.pkgmanager.Util;
import org.eclipse.statet.internal.r.core.pkgmanager.VersionListRPkg;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibPaths;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;

public class FullRPkgSet
implements IRPkgSet.Ext {
    public static final FullRPkgSet DUMMY = new FullRPkgSet();
    private final REnv rEnv;
    private int providing;
    private final RLibPaths rLibPaths;
    private final BasicRPkgCompilation<RPkgInfoAndData> installed;
    private final List<String> priorities = new ArrayList<String>((Collection<String>)DEFAULT_PRIORITIES);
    private final RPkgCompilation<IRPkgData> available;
    private final RPkgListImpl<RPkgData> reverse;
    private List<String> names;

    private FullRPkgSet() {
        this.rEnv = null;
        this.rLibPaths = null;
        this.installed = new BasicRPkgCompilation(0);
        this.available = new BasicRPkgCompilation(0);
        this.reverse = new RPkgListImpl(0);
    }

    public FullRPkgSet(REnv rEnv, RLibPaths rLibPaths, RPkgCompilation<IRPkgData> available) {
        this.rEnv = rEnv;
        this.providing = 17;
        if (!available.getSources().isEmpty()) {
            this.providing |= 0x20;
        }
        this.rLibPaths = rLibPaths;
        this.installed = new BasicRPkgCompilation(rLibPaths.getRLibLocations().size());
        this.available = available;
        this.reverse = new RPkgListImpl(4);
    }

    public @NonNull REnv getREnv() {
        return this.rEnv;
    }

    public int getProviding() {
        return this.providing;
    }

    public @NonNull RLibPaths getRLibPaths() {
        return this.rLibPaths;
    }

    @Override
    public synchronized List<String> getNames() {
        if (this.names == null) {
            List availableNames = this.available.getNames();
            SortedArraySet names = new SortedArraySet((Object[])availableNames.toArray(new String[availableNames.size() + 16]), availableNames.size(), (Comparator)RPkgUtils.NAMES_COLLATOR);
            names.addAll((Collection)this.installed.getNames());
            this.names = Collections.unmodifiableList(names);
        }
        return this.names;
    }

    public BasicRPkgCompilation<RPkgInfoAndData> getInstalled() {
        return this.installed;
    }

    @Override
    public List<String> getPriorities() {
        return this.priorities;
    }

    public RPkgCompilation<IRPkgData> getAvailable() {
        return this.available;
    }

    private List<RPkgList<? extends IRPkgData>> getAll() {
        return ImCollections.concatList((Collection)this.installed.getAll(), (Collection)this.available.getAll());
    }

    @Override
    public IRPkgData getReverse(String name) {
        RPkgData info;
        int idx = this.reverse.indexOf(name);
        if (idx >= 0) {
            info = (RPkgData)this.reverse.get(idx);
        } else {
            info = new RPkgData(name, RNumVersion.NONE, null);
            List depends = null;
            List imports = null;
            List linkingTo = null;
            List suggests = null;
            List enhances = null;
            for (RPkgList<? extends IRPkgData> list : this.getAll()) {
                int i = 0;
                while (i < list.size()) {
                    IRPkgData pkg = (IRPkgData)list.get(i);
                    if (!name.equals(pkg.getName())) {
                        if (Util.findPkg(pkg.getDepends(), name) >= 0) {
                            if (depends == null) {
                                depends = new RPkgListImpl(4);
                            }
                            this.addRev((RPkgListImpl<VersionListRPkg>)depends, pkg);
                        }
                        if (Util.findPkg(pkg.getImports(), name) >= 0) {
                            if (imports == null) {
                                imports = new RPkgListImpl(4);
                            }
                            this.addRev((RPkgListImpl<VersionListRPkg>)imports, pkg);
                        }
                        if (Util.findPkg(pkg.getLinkingTo(), name) >= 0) {
                            if (linkingTo == null) {
                                linkingTo = new RPkgListImpl(4);
                            }
                            this.addRev((RPkgListImpl<VersionListRPkg>)linkingTo, pkg);
                        }
                        if (Util.findPkg(pkg.getSuggests(), name) >= 0) {
                            if (suggests == null) {
                                suggests = new RPkgListImpl(4);
                            }
                            this.addRev((RPkgListImpl<VersionListRPkg>)suggests, pkg);
                        }
                        if (Util.findPkg(pkg.getEnhances(), name) >= 0) {
                            if (enhances == null) {
                                enhances = new RPkgListImpl(4);
                            }
                            this.addRev((RPkgListImpl<VersionListRPkg>)enhances, pkg);
                        }
                    }
                    ++i;
                }
            }
            info.setDepends(depends != null ? depends : Collections.emptyList());
            info.setImports(imports != null ? imports : Collections.emptyList());
            info.setLinkingTo(linkingTo != null ? linkingTo : Collections.emptyList());
            info.setSuggests(suggests != null ? suggests : Collections.emptyList());
            info.setEnhances(enhances != null ? enhances : Collections.emptyList());
            this.reverse.add(-(idx + 1), info);
        }
        return info;
    }

    private void addRev(RPkgListImpl<VersionListRPkg> depends, RPkg v) {
        int idx = depends.indexOf(v.getName());
        if (idx >= 0) {
            VersionListRPkg ref = (VersionListRPkg)depends.get(idx);
            ref.addVersion(v.getVersion());
        } else {
            depends.add(-idx - 1, new VersionListRPkg(v.getName(), v.getVersion()));
        }
    }

    public void checkPkgInfo(RPkgData pkg) {
        String priority = pkg.getPriority();
        if (!this.priorities.contains(priority)) {
            pkg.setPriority("other");
        }
    }
}

