/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.statet.ecommons.text.CharCodepointIterator;
import org.eclipse.statet.ecommons.text.DocumentCodepointIterator;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.editors.text.EditorsUI;

@NonNullByDefault
public abstract class SourceEditorTextHandler
extends AbstractHandler {
    private static int W_INIT = -1;
    private static int W_WORD = 0;
    private static int W_SEP = 1;
    private static int W_WS = 2;
    private final SourceEditor editor;

    public SourceEditorTextHandler(SourceEditor editor) {
        this.editor = editor;
    }

    private @Nullable SourceEditor getEditor(@Nullable Object context) {
        return this.editor;
    }

    protected int getTextActionId() {
        return 0;
    }

    protected boolean isEditAction() {
        switch (this.getTextActionId()) {
            case 8: 
            case 127: 
            case 262152: 
            case 262271: {
                return true;
            }
        }
        return false;
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        SourceEditor editor = this.getEditor(evaluationContext);
        this.setBaseEnabled(editor != null && (!this.isEditAction() || editor.isEditable(false)));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        SourceEditor editor = this.getEditor(event.getApplicationContext());
        if (editor == null) {
            return null;
        }
        if (this.isEditAction() && !editor.isEditable(true)) {
            return null;
        }
        try {
            ExecData data = new ExecData(editor);
            Point oldSelection = data.getWidget().getSelection();
            try {
                this.exec(data);
            }
            finally {
                data.getWidget().showSelection();
                Point newSelection = data.getWidget().getSelection();
                if (!newSelection.equals((Object)oldSelection)) {
                    this.fireSelectionChanged(data, newSelection);
                }
            }
        }
        catch (BadLocationException e) {
            throw new ExecutionException("An error occurred when executing the text viewer command.", (Throwable)e);
        }
        return null;
    }

    private void fireSelectionChanged(ExecData data, Point newSelection) {
        Event event = new Event();
        event.x = newSelection.x;
        event.y = newSelection.y;
        data.getWidget().notifyListeners(13, event);
    }

    protected void exec(ExecData data) throws BadLocationException {
        int textActionId = this.getTextActionId();
        if (textActionId != 0) {
            data.getWidget().invokeAction(textActionId);
        }
    }

    protected int findPreviousWordOffset(ExecData data, int offset, boolean sameLine) throws BadLocationException {
        int begin;
        LinkedPosition linkedPosition;
        int bound = 0;
        LinkedModeModel linkedModel = data.getLinkedModel();
        if (linkedModel != null && (linkedPosition = linkedModel.findPosition(new LinkedPosition((IDocument)data.getDocument(), offset, 0))) != null && (begin = linkedPosition.getOffset()) < offset) {
            bound = begin;
        }
        int previousOffset = offset;
        if (offset == data.getCaretDocLineStartOffset()) {
            if (!sameLine && data.getCaretDocLine() > 0) {
                IRegion nextLine = data.getDocument().getLineInformation(data.getCaretDocLine() - 1);
                previousOffset = nextLine.getOffset() + nextLine.getLength();
            } else {
                previousOffset = offset;
            }
        } else {
            if (bound < data.getCaretDocLineStartOffset()) {
                bound = data.getCaretDocLineStartOffset();
            }
            if (offset <= bound) {
                return offset;
            }
            CharCodepointIterator iterator = DocumentCodepointIterator.create((IDocument)data.getDocument(), (int)bound, (int)offset);
            iterator.setIndex(offset, (byte)2);
            int mode = W_INIT;
            int cp = iterator.previous();
            while (cp != -1) {
                int newMode = this.getMode(cp);
                if (mode != W_INIT && mode != W_WS && newMode != mode) break;
                mode = newMode;
                previousOffset = iterator.getCurrentIndex();
                cp = iterator.previous();
            }
        }
        if (previousOffset < bound) {
            previousOffset = bound;
        }
        return previousOffset;
    }

    protected int findNextWordOffset(ExecData data, int offset, boolean sameLine) throws BadLocationException {
        int end;
        LinkedPosition linkedPosition;
        int bound = data.getDocument().getLength();
        LinkedModeModel linkedModel = data.getLinkedModel();
        if (linkedModel != null && (linkedPosition = linkedModel.findPosition(new LinkedPosition((IDocument)data.getDocument(), offset, 0))) != null && (end = linkedPosition.getOffset() + linkedPosition.getLength()) > offset) {
            bound = end;
        }
        int nextOffset = offset;
        if (data.getCaretDocLineEndOffset() <= offset) {
            nextOffset = !sameLine ? data.getCaretDocLineStartOffset() + data.getDocument().getLineLength(data.getCaretDocLine()) : offset;
        } else {
            if (bound > data.getCaretDocLineEndOffset()) {
                bound = data.getCaretDocLineEndOffset();
            }
            CharCodepointIterator iterator = DocumentCodepointIterator.create((IDocument)data.getDocument(), (int)offset, (int)bound);
            iterator.setIndex(offset, (byte)1);
            int mode = W_INIT;
            int cp = iterator.current();
            while (cp != -1) {
                int newMode = this.getMode(cp);
                if (mode != W_INIT && newMode != W_WS && newMode != mode) break;
                mode = newMode;
                nextOffset = iterator.getCurrentIndex() + iterator.getCurrentLength();
                cp = iterator.next();
            }
        }
        if (nextOffset > bound) {
            nextOffset = bound;
        }
        return nextOffset;
    }

    private int getMode(int cp) {
        if (Character.isLetterOrDigit(cp)) {
            return W_WORD;
        }
        if (cp == 32 || cp == 9) {
            return W_WS;
        }
        return W_SEP;
    }

    public int getCaretSmartLineStartOffset(ExecData data) throws BadLocationException {
        LinkedPosition position;
        LinkedModeModel linkedModel;
        if (data.isSmartHomeBeginEndEnabled() && (linkedModel = data.getLinkedModel()) != null && (position = linkedModel.findPosition(new LinkedPosition((IDocument)data.getDocument(), data.getCaretDocOffset(), 0))) != null && data.getCaretDocOffset() > position.getOffset()) {
            return position.getOffset();
        }
        return data.getCaretDocLineStartOffset();
    }

    public int getCaretSmartLineEndOffset(ExecData data) throws BadLocationException {
        LinkedPosition position;
        LinkedModeModel linkedModel;
        if (data.isSmartHomeBeginEndEnabled() && (linkedModel = data.getLinkedModel()) != null && (position = linkedModel.findPosition(new LinkedPosition((IDocument)data.getDocument(), data.getCaretDocOffset(), 0))) != null && data.getCaretDocOffset() < position.getOffset() + position.getLength()) {
            return position.getOffset() + position.getLength();
        }
        return data.getCaretDocLineEndOffset();
    }

    protected IRegion getWholeLinesRegion(ExecData data) throws BadLocationException {
        Point selectedRange = data.getViewer().getSelectedRange();
        return TextUtil.getBlock((IDocument)data.getDocument(), (int)selectedRange.x, (int)selectedRange.y);
    }

    protected IRegion getToLineBeginRegion(ExecData data) throws BadLocationException {
        int startOffset = this.getCaretSmartLineStartOffset(data);
        return new Region(startOffset, data.getCaretDocOffset() - startOffset);
    }

    protected IRegion getToLineEndRegion(ExecData data) throws BadLocationException {
        int endOffset = this.getCaretSmartLineEndOffset(data);
        return new Region(data.getCaretDocOffset(), endOffset - data.getCaretDocOffset());
    }

    /*
     * Unable to fully structure code
     */
    protected void expandBlockSelection(ExecData data, int newWidgetOffset) {
        block2: {
            if (newWidgetOffset <= data.getCaretWidgetOffset()) ** GOTO lbl7
            while (data.getWidget().getCaretOffset() < newWidgetOffset) {
                data.getWidget().invokeAction(16908292);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                data.getWidget().invokeAction(16908291);
lbl7:
                // 2 sources

                ** while (data.getWidget().getCaretOffset() > newWidgetOffset)
            }
        }
    }

    protected void expandDocSelection(ExecData data, int newDocOffset) {
        Point widgetSelection = data.getWidget().getSelection();
        int otherDocOffset = data.toDocOffset(data.getCaretWidgetOffset() == widgetSelection.x ? widgetSelection.y : widgetSelection.x);
        if (data.toWidgetOffset(newDocOffset) < 0 && data.getViewer() instanceof ProjectionViewer) {
            ((ProjectionViewer)data.getViewer()).exposeModelRange((IRegion)new Region(newDocOffset, 0));
        }
        this.selectAndReveal(data, otherDocOffset, newDocOffset - otherDocOffset);
    }

    protected void copyToClipboard(ExecData data, IRegion docRegion) throws BadLocationException {
        String text = data.getDocument().get(docRegion.getOffset(), docRegion.getLength());
        Clipboard clipboard = new Clipboard(data.getWidget().getDisplay());
        try {
            DNDUtils.setContent((Clipboard)clipboard, (Object[])new String[]{text}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    protected void delete(ExecData data, IRegion docRegion) throws BadLocationException {
        if (data.getViewer() instanceof ProjectionViewer) {
            ((ProjectionViewer)data.getViewer()).exposeModelRange(docRegion);
        }
        data.getViewer().setSelectedRange(docRegion.getOffset(), 0);
        if (docRegion.getLength() > 0) {
            data.getDocument().replace(docRegion.getOffset(), docRegion.getLength(), "");
        }
        data.getViewer().revealRange(data.getViewer().getSelectedRange().x, 0);
    }

    protected void selectAndReveal(ExecData data, int docOffset, int length) {
        data.getViewer().setSelectedRange(docOffset, length);
        data.getViewer().revealRange(docOffset, length);
    }

    protected static class ExecData {
        private final SourceEditor editor;
        private final SourceViewer viewer;
        private final StyledText widget;
        private final AbstractDocument document;
        private final int caretWidgetOffset;
        private final int caretDocOffset;
        private int caretDocLine = Integer.MIN_VALUE;
        private @Nullable IRegion caretDocLineInfo;
        private @Nullable LinkedModeModel linkedModel;

        public ExecData(SourceEditor editor) throws BadLocationException {
            this.editor = editor;
            this.viewer = editor.getViewer();
            this.widget = this.getViewer().getTextWidget();
            this.document = (AbstractDocument)this.getViewer().getDocument();
            this.caretWidgetOffset = this.getWidget().getCaretOffset();
            this.caretDocOffset = this.getViewer().widgetOffset2ModelOffset(this.getCaretWidgetOffset());
            if (this.caretDocOffset < 0) {
                throw new BadLocationException();
            }
        }

        public boolean isSmartHomeBeginEndEnabled() {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            return store != null && store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }

        public SourceEditor getEditor() {
            return this.editor;
        }

        public SourceViewer getViewer() {
            return this.viewer;
        }

        public StyledText getWidget() {
            return this.widget;
        }

        public AbstractDocument getDocument() {
            return this.document;
        }

        public int toWidgetOffset(int docOffset) {
            return this.viewer.modelOffset2WidgetOffset(docOffset);
        }

        public int toDocOffset(int widgetOffset) {
            return this.viewer.widgetOffset2ModelOffset(widgetOffset);
        }

        public int getCaretWidgetOffset() {
            return this.caretWidgetOffset;
        }

        public int getCaretDocOffset() {
            return this.caretDocOffset;
        }

        public int getCaretDocLine() throws BadLocationException {
            int line = this.caretDocLine;
            if (line == Integer.MIN_VALUE) {
                this.caretDocLine = line = this.getDocument().getLineOfOffset(this.getCaretDocOffset());
            }
            return line;
        }

        public IRegion getCaretDocLineInformation() throws BadLocationException {
            IRegion lineInfo = this.caretDocLineInfo;
            if (lineInfo == null) {
                this.caretDocLineInfo = lineInfo = this.getDocument().getLineInformation(this.getCaretDocLine());
            }
            return lineInfo;
        }

        public int getCaretDocLineStartOffset() throws BadLocationException {
            return this.getCaretDocLineInformation().getOffset();
        }

        public int getCaretDocLineEndOffset() throws BadLocationException {
            IRegion region = this.getCaretDocLineInformation();
            return region.getOffset() + region.getLength();
        }

        public int getCaretColumn() throws BadLocationException {
            return this.getCaretDocOffset() - this.getCaretDocLineStartOffset();
        }

        public @Nullable LinkedModeModel getLinkedModel() {
            LinkedModeModel linkedModel = this.linkedModel;
            if (linkedModel == null) {
                this.linkedModel = linkedModel = LinkedModeModel.getModel((IDocument)this.getDocument(), (int)this.getCaretDocOffset());
            }
            return linkedModel;
        }
    }
}

