/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;

public abstract class AbstractDimPositionsCommand
implements ILayerCommand {
    protected static final long NO_REF = -9223372036854775807L;
    private ILayerDim layerDim;
    private long refPosition;
    private Collection<LRange> positions;

    protected AbstractDimPositionsCommand(ILayerDim layerDim, long refPosition, Collection<LRange> positions) {
        this.layerDim = layerDim;
        this.refPosition = refPosition;
        this.positions = positions;
    }

    protected AbstractDimPositionsCommand(ILayerDim layerDim, Collection<LRange> positions) {
        this(layerDim, -9223372036854775807L, positions);
    }

    protected AbstractDimPositionsCommand(AbstractDimPositionsCommand command) {
        this.layerDim = command.layerDim;
        this.refPosition = command.refPosition;
        this.positions = command.positions;
    }

    public final Orientation getOrientation() {
        return this.layerDim.getOrientation();
    }

    public final ILayerDim getDim() {
        return this.layerDim;
    }

    public long getRefPosition() {
        return this.refPosition;
    }

    public Collection<LRange> getPositions() {
        return this.positions;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ILayerDim targetDim = targetLayer.getDim(this.getOrientation());
        if (this.layerDim == targetDim) {
            return true;
        }
        return this.convertToTargetLayer(this.layerDim, this.refPosition, targetDim);
    }

    protected boolean convertToTargetLayer(ILayerDim dim, long refPosition, ILayerDim targetDim) {
        long targetRefPosition;
        LRangeList targetPositions = new LRangeList();
        if (refPosition == -9223372036854775807L) {
            targetRefPosition = -9223372036854775807L;
            for (LRange lRange : this.positions) {
                long position = lRange.start;
                while (position < lRange.end) {
                    long targetPosition = LayerUtil.convertPosition(dim, position, position, targetDim);
                    if (targetPosition != Long.MIN_VALUE) {
                        targetPositions.values().add(targetPosition);
                    }
                    ++position;
                }
            }
        } else if (refPosition != Long.MIN_VALUE) {
            targetRefPosition = LayerUtil.convertPosition(dim, refPosition, refPosition, targetDim);
            if (targetRefPosition == Long.MIN_VALUE) {
                return false;
            }
            for (LRange lRange : this.positions) {
                long position = lRange.start;
                while (position < lRange.end) {
                    long targetPosition = LayerUtil.convertPosition(dim, refPosition, position, targetDim);
                    if (targetPosition != Long.MIN_VALUE) {
                        targetPositions.values().add(targetPosition);
                    }
                    ++position;
                }
            }
        } else {
            targetRefPosition = Long.MIN_VALUE;
        }
        if (targetPositions.isEmpty()) {
            return false;
        }
        this.layerDim = targetDim;
        this.refPosition = targetRefPosition;
        this.positions = targetPositions;
        return true;
    }
}

