/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.BookmarkCollection;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserHandler;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.EditBookmarkDialog;
import org.eclipse.statet.ecommons.ui.mpbv.ManageBookmarksDialog;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.mpbv.ShowBookmarksDropdownContribution;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class PageBookBrowserView
extends ManagedPageBookView<BrowserSession> {
    private static final String BROWSERCONTROL_MENU_ID = "browser_control";
    private static final String BOOKMARKS_MENU_ID = "bookmarks";
    protected static final String OPEN_EXTERNAL_ID = ".OpenExternal";
    protected static final String CREATE_BOOKMARK_ID = ".CreateBookmark";
    protected static final String NAVIGATE_BACK_COMMAND_ID = "org.eclipse.ui.navigate.back";
    protected static final String NAVIGATE_FORWARD_COMMAND_ID = "org.eclipse.ui.navigate.forward";
    protected static final String GOTO_HOME_COMMAND_ID = "org.eclipse.statet.workbench.commands.GoToHome";
    protected static final String REFRESH_PAGE_COMMAND_ID = "org.eclipse.ui.file.refresh";
    protected static final String PRINT_PAGE_COMMAND_ID = "org.eclipse.ui.file.print";
    private final List<IHandler2> browserHandlers = new ArrayList<IHandler2>();
    private final BrowserListener browserListener = new BrowserListener();
    private @Nullable PageBookBrowserPage currentBrowserPage;
    private @Nullable IProgressMonitor currentProgress;
    private int currentProgressWorked;
    private @Nullable BookmarkCollection bookmarks;
    private final BrowserHandler.IBrowserProvider browserInterface = new BrowserHandler.IBrowserProvider(){

        @Override
        public @Nullable Browser getBrowser() {
            if (PageBookBrowserView.this.currentBrowserPage != null) {
                return PageBookBrowserView.this.currentBrowserPage.getBrowser();
            }
            return null;
        }

        @Override
        public void showMessage(IStatus status) {
            PageBookBrowserView.this.getStatusManager().setMessage(status, 10);
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.bookmarks = this.initBookmarkCollection();
    }

    public void saveState(IMemento memento) {
        if (this.bookmarks != null) {
            this.bookmarks.save();
        }
        super.saveState(memento);
    }

    protected PageBookBrowserPage doCreatePage(BrowserSession session) {
        return new PageBookBrowserPage(this, session);
    }

    protected BrowserHandler.IBrowserProvider getBrowserInterface() {
        return this.browserInterface;
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        ((IContextService)serviceLocator.getService(IContextService.class)).activateContext("org.eclipse.statet.workbench.contexts.PageViewerContext");
        AbstractHandler handler = new BrowserHandler.NavigateBackHandler(this.getBrowserInterface());
        handlers.addActivate(NAVIGATE_BACK_COMMAND_ID, (IHandler2)handler);
        this.addBrowserHandler((IHandler2)handler);
        handlers.getHandlerService().activateHandler("org.eclipse.ui.navigate.backwardHistory", (IHandler)handler);
        handler = new BrowserHandler.NavigateForwardHandler(this.getBrowserInterface());
        handlers.addActivate(NAVIGATE_FORWARD_COMMAND_ID, (IHandler2)handler);
        this.addBrowserHandler((IHandler2)handler);
        handlers.getHandlerService().activateHandler("org.eclipse.ui.navigate.forwardHistory", (IHandler)handler);
        handler = new GoToHomeHandler();
        handlers.addActivate(GOTO_HOME_COMMAND_ID, (IHandler2)handler);
        this.addBrowserHandler((IHandler2)handler);
        handler = new RefreshHandler();
        handlers.addActivate(REFRESH_PAGE_COMMAND_ID, (IHandler2)handler);
        this.addBrowserHandler((IHandler2)handler);
        BrowserHandler.CancelHandler cancelHandler = new BrowserHandler.CancelHandler(this.getBrowserInterface());
        this.addBrowserHandler((IHandler2)cancelHandler);
        AbstractHandler handler2 = new PrintHandler();
        handlers.addActivate(PRINT_PAGE_COMMAND_ID, (IHandler2)handler2);
        if (this.bookmarks != null && (handler2 = new CreateBookmarkHandler()) != null) {
            handlers.add(CREATE_BOOKMARK_ID, (IHandler2)handler2);
            this.addBrowserHandler((IHandler2)handler2);
        }
        if ((handler2 = this.createOpenExternalHandler()) != null) {
            handlers.add(OPEN_EXTERNAL_ID, (IHandler2)handler2);
            this.addBrowserHandler((IHandler2)handler2);
        }
    }

    protected @Nullable IHandler2 createOpenExternalHandler() {
        return new BrowserHandler.OpenExternalHandler(this.getBrowserInterface());
    }

    @Override
    protected void contributeToActionBars(final IServiceLocator serviceLocator, IActionBars actionBars, final HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, "Open in &external browser", null, null, 8, null, false), handlers.get(OPEN_EXTERNAL_ID)));
        menuManager.add((IContributionItem)new Separator("view.filter"));
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.appendToGroup("settings", (IContributionItem)new SimpleContributionItem("Preferences...", "P"){

            @Override
            protected void execute() throws ExecutionException {
                Shell shell = PageBookBrowserView.this.getSite().getShell();
                ArrayList<String> pageIds = new ArrayList<String>();
                PageBookBrowserView.this.collectContextMenuPreferencePages(pageIds);
                if (!(pageIds.isEmpty() || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)((String)pageIds.get(0)), (String[])pageIds.toArray(new String[pageIds.size()]), null).open();
                }
            }
        });
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.insertBefore("additions", (IContributionItem)new Separator(BROWSERCONTROL_MENU_ID));
        toolBarManager.appendToGroup(BROWSERCONTROL_MENU_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, NAVIGATE_BACK_COMMAND_ID, 8), handlers));
        toolBarManager.appendToGroup(BROWSERCONTROL_MENU_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, NAVIGATE_FORWARD_COMMAND_ID, 8), handlers));
        if (this.bookmarks != null) {
            toolBarManager.insertAfter(BROWSERCONTROL_MENU_ID, (IContributionItem)new Separator(BOOKMARKS_MENU_ID));
            toolBarManager.appendToGroup(BOOKMARKS_MENU_ID, (IContributionItem)new SimpleContributionItem("Manage Bookmarks", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctoolh/favorites"), null, 4){

                @Override
                protected void execute() throws ExecutionException {
                    ManageBookmarksDialog dialog = new ManageBookmarksDialog(PageBookBrowserView.this);
                    dialog.open();
                    PageBookBrowserView.this.bookmarks.save();
                }

                @Override
                protected void dropDownMenuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, "Create Bookmark", "C", null, 8, null, false), handlers.get(PageBookBrowserView.CREATE_BOOKMARK_ID)));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)new ShowBookmarksDropdownContribution.OpenBookmarkContributionItem(PageBookBrowserView.this, new BrowserBookmark("Home Page", PageBookBrowserView.this.getHomePageUrl()), null, "H"));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)new ShowBookmarksDropdownContribution(PageBookBrowserView.this));
                }
            });
        }
    }

    protected void addBrowserHandler(IHandler2 handler) {
        this.browserHandlers.add(handler);
    }

    @Override
    public void dispose() {
        this.browserHandlers.clear();
        super.dispose();
    }

    @Override
    protected void onPageHiding(IPageBookViewPage page, BrowserSession session) {
        if (session != null) {
            PageBookBrowserPage browserPage = (PageBookBrowserPage)page;
            Browser browser = browserPage.getBrowser();
            browser.removeProgressListener((ProgressListener)this.browserListener);
            browser.removeTitleListener((TitleListener)this.browserListener);
            browser.removeStatusTextListener((StatusTextListener)this.browserListener);
            browserPage.setStatusManager(null);
            this.clearProgress();
        }
        this.currentBrowserPage = null;
        this.getStatusManager().clearAll();
        super.onPageHiding(page, session);
    }

    @Override
    protected void onPageShowing(IPageBookViewPage page, BrowserSession session) {
        if (session != null) {
            PageBookBrowserPage browserPage = this.currentBrowserPage = (PageBookBrowserPage)page;
            Browser browser = browserPage.getBrowser();
            browser.addProgressListener((ProgressListener)this.browserListener);
            browser.addTitleListener((TitleListener)this.browserListener);
            browser.addStatusTextListener((StatusTextListener)this.browserListener);
            this.initProgress(browserPage.getCurrentProgressTotal(), browserPage.getCurrentProgressWorked());
            browserPage.setStatusManager(this.getStatusManager());
        }
        super.onPageShowing(page, session);
    }

    protected void updateBrowserState() {
        for (IHandler2 handler : this.browserHandlers) {
            handler.setEnabled(null);
        }
    }

    private void initProgress(int total, int current) {
        IProgressMonitor monitor;
        if (current < 0 || current >= total) {
            return;
        }
        IStatusLineManager statusLine = this.getViewSite().getActionBars().getStatusLineManager();
        statusLine.setCancelEnabled(true);
        this.currentProgress = monitor = statusLine.getProgressMonitor();
        this.currentProgress.beginTask("", total);
        this.currentProgressWorked = current;
        this.currentProgress.worked(current);
        Display.getCurrent().timerExec(200, new Runnable(){

            @Override
            public void run() {
                if (monitor == PageBookBrowserView.this.currentProgress) {
                    if (monitor.isCanceled()) {
                        PageBookBrowserView.this.currentBrowserPage.getBrowser().stop();
                    } else {
                        Display.getCurrent().timerExec(100, (Runnable)this);
                    }
                }
            }
        });
    }

    private void updateProgress(int current) {
        this.currentProgress.worked(current - this.currentProgressWorked);
        this.currentProgressWorked = current;
    }

    private void clearProgress() {
        if (this.currentProgress != null) {
            this.currentProgress.done();
            this.currentProgress = null;
            this.currentProgressWorked = 0;
        }
    }

    @Override
    protected BrowserSession checkNewSession(@Nullable BrowserSession session) {
        if (session == null) {
            session = new BrowserSession(this.getHomePageUrl());
        }
        session.bind();
        return session;
    }

    @Override
    public void closePage(BrowserSession session) {
        super.closePage(session);
        session.unbind();
    }

    public boolean canOpen(BrowserSession session) {
        return !session.isBound() || this.getSessions().contains((Object)session);
    }

    public BrowserSession openBookmark(BrowserBookmark bookmark, BrowserSession session) {
        return this.openUrl(bookmark.getUrl(), session);
    }

    public BrowserSession openUrl(URI url, @Nullable BrowserSession session) {
        return this.openUrl(url.toString(), session);
    }

    public BrowserSession openUrl(String url, @Nullable BrowserSession session) {
        PageBookBrowserPage page;
        if (session != null && (page = (PageBookBrowserPage)this.getPage(session)) != null) {
            page.setUrl(url);
            this.showPage(session);
            if (this.getViewSite().getPage().getActivePart() == this) {
                page.setFocusToBrowser();
            }
            return session;
        }
        if (session == null) {
            session = new BrowserSession(url);
        } else {
            session.setUrl(url);
        }
        this.newPage(session, true);
        return session;
    }

    protected @Nullable PageBookBrowserPage getCurrentBrowserPage() {
        return this.currentBrowserPage;
    }

    public String getHomePageUrl() {
        return "about:blank";
    }

    protected @Nullable BookmarkCollection initBookmarkCollection() {
        return null;
    }

    protected List<BrowserBookmark> getBookmarks() {
        return this.bookmarks.getBookmarks();
    }

    protected @Nullable BrowserBookmark createBookmark() {
        PageBookBrowserPage browserPage = this.currentBrowserPage;
        if (browserPage == null) {
            return null;
        }
        return new BrowserBookmark(browserPage.getCurrentTitle(), browserPage.getCurrentUrl());
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        pageIds.add("org.eclipse.ui.browser.preferencePage");
    }

    private class BrowserListener
    implements ProgressListener,
    TitleListener,
    StatusTextListener {
        private BrowserListener() {
        }

        public void changed(ProgressEvent event) {
            if (PageBookBrowserView.this.currentBrowserPage != null && PageBookBrowserView.this.currentBrowserPage.getBrowser() == event.widget) {
                if (event.total == 0 || event.total == event.current) {
                    PageBookBrowserView.this.clearProgress();
                } else if (PageBookBrowserView.this.currentProgress == null) {
                    PageBookBrowserView.this.initProgress(event.total, event.current);
                } else {
                    PageBookBrowserView.this.updateProgress(event.current);
                }
                PageBookBrowserView.this.updateBrowserState();
            }
        }

        public void completed(ProgressEvent event) {
            if (PageBookBrowserView.this.currentBrowserPage != null && PageBookBrowserView.this.currentBrowserPage.getBrowser() == event.widget) {
                PageBookBrowserView.this.clearProgress();
                PageBookBrowserView.this.updateBrowserState();
            }
        }

        public void changed(TitleEvent event) {
            if (PageBookBrowserView.this.currentBrowserPage != null && PageBookBrowserView.this.currentBrowserPage.getBrowser() == event.widget) {
                PageBookBrowserView.this.updateTitle();
            }
        }

        public void changed(StatusTextEvent event) {
            PageBookBrowserView.this.updateTitle();
        }
    }

    private class CreateBookmarkHandler
    extends AbstractHandler {
        private CreateBookmarkHandler() {
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            BrowserBookmark bookmark = PageBookBrowserView.this.createBookmark();
            EditBookmarkDialog dialog = new EditBookmarkDialog(PageBookBrowserView.this.getSite().getShell(), bookmark);
            if (dialog.open() == 0 && (bookmark = dialog.getBookmark()) != null) {
                PageBookBrowserView.this.bookmarks.getBookmarks().add(bookmark);
                return bookmark;
            }
            return null;
        }
    }

    private class GoToHomeHandler
    extends AbstractHandler {
        private GoToHomeHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            PageBookBrowserView.this.openUrl(PageBookBrowserView.this.getHomePageUrl(), (BrowserSession)PageBookBrowserView.this.getCurrentSession());
            return null;
        }
    }

    private class PrintHandler
    extends AbstractHandler {
        private PrintHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(PageBookBrowserView.this.currentBrowserPage != null);
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            if (PageBookBrowserView.this.currentBrowserPage != null) {
                Browser browser = PageBookBrowserView.this.currentBrowserPage.getBrowser();
                browser.execute("window.print();");
            }
            return null;
        }
    }

    private class RefreshHandler
    extends AbstractHandler {
        private RefreshHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(PageBookBrowserView.this.currentBrowserPage != null);
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            PageBookBrowserPage browserPage = PageBookBrowserView.this.currentBrowserPage;
            if (browserPage != null) {
                browserPage.refresh();
            }
            return null;
        }
    }
}

