/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.docmlet.base.core.DocmlSearchPattern;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.ast.NodeType;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.MarkupCompletionExtension;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.model.core.element.NameAccessSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class MarkupLabelCompletionComputer
implements ContentAssistComputer,
MarkupCompletionExtension {
    private WikitextMarkupLanguage markupLanguage;
    private MarkupCompletionExtension completionExtension;
    private int searchMatchRules;

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        this.markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)editor.getViewer().getDocument(), (String)editor.getDocumentContentInfo().getPartitioning());
        if (this.markupLanguage != null) {
            this.completionExtension = (MarkupCompletionExtension)Platform.getAdapterManager().getAdapter((Object)this.markupLanguage, MarkupCompletionExtension.class);
        }
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
        this.markupLanguage = null;
        this.completionExtension = null;
    }

    protected WikitextMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    protected int getLabelSearchMatchRules() {
        int rules = this.searchMatchRules;
        if ((rules & 0x10) != 0) {
            rules |= 0x200000;
        }
        return rules;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        WikitextMarkupLanguage markupLanguage = this.markupLanguage;
        MarkupCompletionExtension ext = this.completionExtension != null ? this.completionExtension : this;
        WikidocSourceUnitModelInfo modelInfo = (WikidocSourceUnitModelInfo)context.getModelInfo();
        MarkupCompletionExtension.CompletionType type = ext.getLinkAnchorLabel(context, markupLanguage);
        if (type != null) {
            this.addLabelProposals(context, type, (NameAccessSet<WikitextNameAccess>)modelInfo.getLinkAnchorLabels(), proposals);
        }
        if ((type = ext.getLinkRefLabel(context, markupLanguage)) != null) {
            this.addLabelProposals(context, type, (NameAccessSet<WikitextNameAccess>)modelInfo.getLinkRefLabels(), proposals);
        }
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
    }

    private void addLabelProposals(AssistInvocationContext context, MarkupCompletionExtension.CompletionType type, NameAccessSet<WikitextNameAccess> labels, AssistProposalCollector proposals) {
        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters(context, context.getInvocationOffset() - type.getSourcePrefix().length(), (SearchPattern)new DocmlSearchPattern(this.getLabelSearchMatchRules(), type.getLookupPrefix()));
        for (String label : labels.getNames()) {
            ImList accessList;
            if (!parameters.matchesNamePattern(label) || (accessList = labels.getAllInUnit(label)).size() == 1 && this.isCurrent((WikitextAstNode)((WikitextNameAccess)accessList.get(0)).getNameNode(), context.getInvocationOffset())) continue;
            WikitextNameAccess defAccess = null;
            WikitextSourceElement defElement = null;
            block1: for (WikitextNameAccess access : accessList) {
                if (!access.isWriteAccess()) continue;
                for (Object attachment : ((WikitextAstNode)access.getNode()).getAttachments()) {
                    if (!(attachment instanceof WikitextSourceElement)) continue;
                    defAccess = access;
                    defElement = (WikitextSourceElement)attachment;
                    break block1;
                }
                if (defAccess != null) continue;
                defAccess = access;
            }
            parameters.baseRelevance = defAccess != null ? 95 : 94;
            proposals.add((AssistProposal)new LabelCompletionProposal(parameters, (defAccess != null ? defAccess : (WikitextNameAccess)accessList.get(0)).getDisplayName(), defAccess, defElement));
        }
    }

    private boolean isCurrent(WikitextAstNode node, int offset) {
        return node != null && node.getStartOffset() <= offset && node.getEndOffset() >= offset;
    }

    @Override
    public @Nullable MarkupCompletionExtension.CompletionType getLinkAnchorLabel(AssistInvocationContext context, WikitextMarkupLanguage markupLanguage) {
        try {
            int endOffset;
            IDocument document = context.getDocument();
            int startOffset = endOffset = context.getOffset();
            while (startOffset > 0) {
                char c;
                if (Character.isLetterOrDigit(c = document.getChar(--startOffset)) || c == '-' || c == '_' || c == ':' || c == '.' || c != '#') continue;
                return new MarkupCompletionExtension.CompletionType(document.get(++startOffset, endOffset - startOffset));
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    @Override
    public @Nullable MarkupCompletionExtension.CompletionType getLinkRefLabel(AssistInvocationContext context, WikitextMarkupLanguage markupLanguage) {
        return null;
    }

    private static class LabelCompletionProposal
    extends SimpleCompletionProposal<AssistInvocationContext> {
        private final @Nullable WikitextNameAccess defAccess;
        private final @Nullable WikitextSourceElement refElement;

        public LabelCompletionProposal(SourceProposal.ProposalParameters<?> parameters, String replacementString, @Nullable WikitextNameAccess defAccess, @Nullable WikitextSourceElement refElement) {
            super(parameters, replacementString);
            this.defAccess = defAccess;
            this.refElement = refElement;
        }

        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = this.getInvocationContext().getDocument();
                --end;
                while (++end < document.getLength()) {
                    char c = document.getChar(end);
                    if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != ':' && c != '.') break;
                }
            }
            return end - replacementOffset;
        }

        protected StyledString computeStyledText() {
            StyledString styledText = new StyledString(this.getDisplayString());
            String title = this.getTitle();
            if (title != null) {
                styledText.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
                styledText.append(title, StyledString.QUALIFIER_STYLER);
            }
            return styledText;
        }

        private @Nullable String getTitle() {
            Link link;
            WikitextAstNode node;
            String name;
            if (this.refElement != null && (name = this.refElement.getElementName().getDisplayName()) != null) {
                if ((this.refElement.getElementType() & 0xFF0) == 1056) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("h:");
                    sb.append(Integer.toString(this.refElement.getElementType() & 0xF));
                    sb.append(" ");
                    sb.append(name);
                    return sb.toString();
                }
                return name;
            }
            if (this.defAccess != null && (node = (WikitextAstNode)this.defAccess.getNode()) != null && node.getNodeType() == NodeType.LINK && (link = (Link)node).getLinkType() == 1) {
                return link.getTitle();
            }
            return null;
        }

        public Image getImage() {
            return DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/obj/Label-Text");
        }

        public boolean isAutoInsertable() {
            return false;
        }

        public @Nullable String getAdditionalProposalInfo() {
            Link link;
            WikitextAstNode node;
            if (this.refElement == null && this.defAccess != null && (node = (WikitextAstNode)this.defAccess.getNode()) != null && node.getNodeType() == NodeType.LINK && (link = (Link)node).getLinkType() == 1) {
                return link.getUri();
            }
            return null;
        }
    }
}

