/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.BundleContext;

public class WikitextUIPlugin
extends AbstractUIPlugin {
    public static final String WIKIDOC_EDITOR_TEMPLATES_ID = "org.eclipse.statet.docmlet.templates.WikidocEditor";
    public static final String WIKITEXT_EDITOR_ASSIST_REGISTRY_GROUP_ID = "wikitext/wikitext.editor/assist.registry";
    private static WikitextUIPlugin instance;
    private volatile boolean started;
    private List<Disposable> disposables;
    private IPreferenceStore editorPreferenceStore;
    private ContentAssistComputerRegistry wikidocEditorContentAssistRegistry;
    private IPropertyChangeListener fontPrefListener;

    public static WikitextUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        WikitextUIPlugin plugin = WikitextUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            WikitextUIPlugin wikitextUIPlugin = this;
            synchronized (wikitextUIPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
            }
            if (this.fontPrefListener != null) {
                FontRegistry fontRegistry = JFaceResources.getFontRegistry();
                if (fontRegistry != null) {
                    fontRegistry.removeListener(this.fontPrefListener);
                }
                this.fontPrefListener = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    WikitextUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.ui", "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        WikitextUIPlugin wikitextUIPlugin = this;
        synchronized (wikitextUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    public synchronized IPreferenceStore getPreferenceStore() {
        IPreferenceStore preferenceStore = super.getPreferenceStore();
        if (this.fontPrefListener == null && this.started) {
            this.fontPrefListener = new IPropertyChangeListener(){

                private boolean isZoom() {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    int end = Math.min(stackTrace.length, 20);
                    int i = 3;
                    while (i < end) {
                        String className = stackTrace[i].getClassName();
                        if (className.endsWith("org.eclipse.ui.texteditor.AbstractTextZoomHandler")) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }

                private void updateFont(String symbolicName, int diff) {
                    IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
                    FontRegistry fontRegistry = themeManager.getCurrentTheme().getFontRegistry();
                    FontData[] currentFontData = fontRegistry.getFontData(symbolicName);
                    if (currentFontData == null) {
                        return;
                    }
                    int height = currentFontData[0].getHeight() + diff;
                    if (height <= 0) {
                        return;
                    }
                    FontData[] newFontData = FontDescriptor.createFrom((FontData[])currentFontData).setHeight(height).getFontData();
                    fontRegistry.put(symbolicName, newFontData);
                }

                public void propertyChange(PropertyChangeEvent event) {
                    Job job;
                    boolean update = false;
                    if (event.getProperty().equals("org.eclipse.mylyn.wikitext.ui.presentation.textFont")) {
                        if (this.isZoom()) {
                            int diff;
                            FontData[] oldValue = (FontData[])event.getOldValue();
                            FontData[] newValue = (FontData[])event.getNewValue();
                            if (oldValue != null && newValue != null && (diff = newValue[0].getHeight() - oldValue[0].getHeight()) != 0) {
                                this.updateFont("org.eclipse.mylyn.wikitext.ui.presentation.monospaceFont", diff);
                            }
                        }
                        update = true;
                    } else if (event.getProperty().equals("org.eclipse.mylyn.wikitext.ui.presentation.monospaceFont")) {
                        update = true;
                    }
                    if (update && (job = PreferencesUtil.getSettingsChangeNotifier().getNotifyJob("mylyn", (ImCollection)ImCollections.newList((Object)"org.eclipse.statet.docmlet.wikitext.ui/textstyle/Wikitext"))) != null) {
                        job.schedule(250L);
                    }
                }
            };
            JFaceResources.getFontRegistry().addListener(this.fontPrefListener);
        }
        return preferenceStore;
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        if (this.editorPreferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.editorPreferenceStore;
    }

    public synchronized ContentAssistComputerRegistry getWikidocEditorContentAssistRegistry() {
        if (this.wikidocEditorContentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.wikidocEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.docmlet.contentTypes.Wikidoc", "org.eclipse.statet.docmlet.wikitext.ui/editor/assist/Wikidoc");
            this.disposables.add((Disposable)this.wikidocEditorContentAssistRegistry);
        }
        return this.wikidocEditorContentAssistRegistry;
    }
}

