/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.ecommons.variables.core.StringVariable;
import org.eclipse.statet.internal.r.launching.core.Messages;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.eclipse.statet.rj.renv.core.REnvUtils;

public class RLaunching {
    public static final String CONFIG_RENV_NS = "org.eclipse.statet.r/renv";
    public static final String ATTR_RENV_CODE = "org.eclipse.statet.r/renv/REnvCode";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.statet.r/renv/WorkingDirectory";
    public static final String WORKING_DIRECTORY_VARNAME = "r_wd";
    public static final IStringVariable WORKING_DIRECTORY_VARIABLE = new StringVariable("r_wd", "The configured R working directory");

    public static @Nullable REnv readREnv(ILaunchConfiguration configuration) throws CoreException {
        String code = configuration.getAttribute(ATTR_RENV_CODE, null);
        return REnvUtils.decode((String)code, (REnvManager)RCore.getREnvManager());
    }

    public static IREnvConfiguration getREnvConfig(ILaunchConfiguration configuration, boolean local) throws CoreException {
        IREnvConfiguration rEnvConfig;
        REnv rEnv = RLaunching.readREnv(configuration);
        IREnvConfiguration iREnvConfiguration = rEnvConfig = rEnv != null ? (IREnvConfiguration)rEnv.get(IREnvConfiguration.class) : null;
        if (rEnvConfig == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, Messages.REnv_Runtime_error_CouldNotFound_message, null));
        }
        IStatus status = rEnvConfig.validate();
        if (status.getSeverity() == 4) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, String.valueOf(Messages.REnv_Runtime_error_Invalid_message) + ' ' + status.getMessage(), null));
        }
        if (local && !rEnvConfig.isLocal()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "The R environment configuration must specify a local R installation.", null));
        }
        return rEnvConfig;
    }
}

