/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class LtxArgumentListContextInformation
implements AssistInformationProposal,
IContextInformationExtension {
    private final int offset;
    private final TexCommand command;
    private final String information;
    private final int[] informationArgumentIdxs;

    public LtxArgumentListContextInformation(int offset, TexCommand command) {
        this.offset = offset;
        this.command = command;
        StringBuilder sb = new StringBuilder();
        IntArrayList idxs = new IntArrayList();
        LtxArgumentListContextInformation.appendArgumentList(sb, (IntList)idxs, this.command);
        this.information = sb.toString();
        this.informationArgumentIdxs = idxs.toArray();
    }

    public int getCallArgsOffset() {
        return this.offset;
    }

    public TexCommand getCommand() {
        return this.command;
    }

    public String getContextDisplayString() {
        return this.getInformationDisplayString();
    }

    public @Nullable Image getImage() {
        return null;
    }

    public int getContextInformationPosition() {
        return Math.max(this.offset, 0);
    }

    public String getInformationDisplayString() {
        return this.information;
    }

    public int[] getInformationDisplayStringArgumentIdxs() {
        return this.informationArgumentIdxs;
    }

    public boolean equals(@Nullable Object obj) {
        return true;
    }

    private static void appendArgumentList(StringBuilder text, IntList idxs, TexCommand command) {
        for (Argument arg : command.getArguments()) {
            idxs.add(text.length());
            if ((arg.getType() & 2) != 0) {
                text.append('[');
                if (arg.getLabel() != null) {
                    text.append(arg.getLabel());
                }
                text.append(']');
                continue;
            }
            text.append('{');
            if (arg.getLabel() != null) {
                text.append(arg.getLabel());
            }
            text.append('}');
        }
    }
}

