/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.variables;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.base.ui.StatetImages;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.ViewActionUtil;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.apps.ui.RAppUIPlugin;
import org.eclipse.statet.internal.r.apps.ui.variables.AppVarInput;
import org.eclipse.statet.internal.r.apps.ui.variables.ContentJob;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.ltk.ui.util.ViewerDragSupport;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.statet.r.apps.ui.AppRegistry;
import org.eclipse.statet.r.apps.ui.RApp;
import org.eclipse.statet.r.apps.ui.VariablesData;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.ui.rtool.CopyRElementHandler;
import org.eclipse.statet.r.ui.rtool.PrintRElementHandler;
import org.eclipse.statet.r.ui.rtool.RElementViewerDragSourceListener;
import org.eclipse.statet.r.ui.util.CopyRElementNameHandler;
import org.eclipse.statet.r.ui.util.RElementInput;
import org.eclipse.statet.r.ui.util.RElementInputContentProvider;
import org.eclipse.statet.r.ui.util.RElementInputLabelProvider;
import org.eclipse.statet.r.ui.util.RElementInputUtils;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class AppVarView
extends ViewPart
implements ToolProvider {
    public static final String VIEW_ID = "org.eclipse.statet.r.apps.views.VariableViewer";
    private static final String REFRESH_COMMAND_ID = "org.eclipse.ui.file.refresh";
    private static final String FILTER_INCLUDE_INTERNAL_COMMAND_ID = "Filter.IncludeInternal";
    private static final String PRINT_COMMAND_ID = "org.eclipse.statet.r.commands.RunPrintInR";
    private static final String FILTER_INCLUDE_INTERNAL_SETTINGS_KEY = "Filter.IncludeInternal.enabled";
    private IDialogSettings settings;
    final Object sourceLock = new Object();
    private WorkbenchToolRegistryListener toolRegistryListener;
    private @Nullable RProcess process;
    private final CopyOnWriteIdentityListSet<ActiveToolListener> toolListeners = new CopyOnWriteIdentityListSet();
    private AppRegistry.Listener appRegistryListener;
    private @Nullable RApp app;
    private TreeViewer treeViewer;
    private final ContentJob inputUpdater = new ContentJob(this);
    private boolean isUpdating;
    private boolean filterIncludeInternal;
    private String filterText;
    private RElementInputContentProvider<AppVarInput> inputContentProvider;
    private ViewActionUtil actionUtil;
    private ContextHandlers handlers;
    private @Nullable Object currentInfoObject;
    private @Nullable RApp shownByLauncher;

    public void dispose() {
        if (this.appRegistryListener != null) {
            AppRegistry.getInstance().removeListener(this.appRegistryListener);
            this.appRegistryListener = null;
        }
        if (this.toolRegistryListener != null) {
            NicoUI.getToolRegistry().removeListener(this.toolRegistryListener);
            this.toolRegistryListener = null;
        }
        this.setTool(null, false);
        if (this.handlers != null) {
            this.handlers.dispose();
            this.handlers = null;
        }
        super.dispose();
    }

    public void init(IViewSite site, @Nullable IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings = DialogUtils.getDialogSettings((Plugin)RAppUIPlugin.getInstance(), (String)"AppVarBrowser");
        this.filterIncludeInternal = this.settings.getBoolean(FILTER_INCLUDE_INTERNAL_SETTINGS_KEY);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.newSashGrid());
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer treeSelectionProvider = this.treeViewer;
        treeSelectionProvider.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AppVarView.this.updateSelectionInfo((ITreeSelection)event.getSelection());
            }
        });
        IViewSite site = this.getViewSite();
        site.setSelectionProvider((ISelectionProvider)treeSelectionProvider);
        this.actionUtil = new ViewActionUtil((IViewPart)this);
        this.handlers = new ContextHandlers((IHandlerService)site.getService(IHandlerService.class));
        this.initActions((IServiceLocator)site, this.handlers);
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), (HandlerCollection)this.handlers);
        this.hookContextMenu();
        WorkbenchToolRegistry toolRegistry = NicoUI.getToolRegistry();
        this.toolRegistryListener = new WorkbenchToolRegistryListener(){

            public void toolSessionActivated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppVarView.this.setTool(tool, true);
                    }
                });
            }

            public void toolTerminated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (tool == AppVarView.this.getTool()) {
                            AppVarView.this.setTool(null, true);
                        }
                    }
                });
            }
        };
        toolRegistry.addListener(this.toolRegistryListener, this.getViewSite().getPage());
        this.appRegistryListener = new AppRegistry.Listener(){

            @Override
            public void onAppStateChanged(AppRegistry.AppStateEvent event) {
                UIAccess.getDisplay((Shell)AppVarView.this.getSite().getShell()).asyncExec(() -> {
                    switch (event.getType()) {
                        case 1: {
                            if (event.getApp().getTool() != AppVarView.this.getTool()) break;
                            AppVarView.this.setApp(event.getApp(), true);
                            break;
                        }
                        case 2: {
                            if (event.getApp() != AppVarView.this.getApp()) break;
                            AppVarView.this.setApp(null, true);
                            break;
                        }
                    }
                });
            }
        };
        AppRegistry.getInstance().addListener(this.appRegistryListener);
        this.setTool(toolRegistry.getActiveToolSession(this.getViewSite().getPage()).getTool(), true);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.setLabelProvider((IBaseLabelProvider)new RElementInputLabelProvider());
        viewer.setUseHashlookup(true);
        this.inputContentProvider = new RElementInputContentProvider();
        viewer.setContentProvider(this.inputContentProvider);
        viewer.setInput((Object)this);
        return viewer;
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        handlers.addActivate(REFRESH_COMMAND_ID, (IHandler2)new RefreshHandler());
        CopyRElementHandler copyHandler = new CopyRElementHandler(this.actionUtil, (ILabelProvider)this.treeViewer.getLabelProvider());
        handlers.addActivate("org.eclipse.ui.edit.copy", (IHandler2)copyHandler);
        handlers.addActivate("org.eclipse.statet.workbench.commands.CopyElementName", (IHandler2)new CopyRElementNameHandler(this.actionUtil));
        ViewerDragSupport dragSupport = new ViewerDragSupport((StructuredViewer)this.treeViewer);
        dragSupport.addDragSourceListener((TransferDragSourceListener)new RElementViewerDragSourceListener(copyHandler, (StructuredViewer)this.treeViewer));
        dragSupport.init();
        handlers.addActivate(PRINT_COMMAND_ID, (IHandler2)new PrintRElementHandler(this.actionUtil));
        handlers.add(FILTER_INCLUDE_INTERNAL_COMMAND_ID, (IHandler2)new FilterInternalHandler());
        handlers.addActivate("org.eclipse.ui.navigate.collapseAll", (IHandler2)new CollapseAllHandler((AbstractTreeViewer)this.treeViewer));
        RElementInputUtils.addDoubleClickExpansion((AbstractTreeViewer)this.treeViewer);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IMenuManager menuManager = actionBars.getMenuManager();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, "Show &Internal Variables ('.*')", null, null, 32, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get(FILTER_INCLUDE_INTERNAL_COMMAND_ID))));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "Refresh", REFRESH_COMMAND_ID, null, StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/image/tool/refresh"), StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/image/toold/refresh"), null, "&Refresh", null, null, 8, null, false), handlers));
        toolbarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.collapseAll", null, null, null, null, null, null, null, 8, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("org.eclipse.ui.navigate.collapseAll"))));
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("ContextMenu", "org.eclipse.statet.r.apps.menus.VariablesViewContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this::fillContextMenu);
        Menu contextMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager m) {
        IWorkbenchPartSite serviceLocator = this.getSite();
        ContextHandlers handlers = this.handlers;
        m.add((IContributionItem)new Separator("edit"));
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Copy", "org.eclipse.ui.edit.copy", null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Copy.ElementName", "org.eclipse.statet.workbench.commands.CopyElementName", null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new Separator());
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, null, PRINT_COMMAND_ID, null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    void updateView(@Nullable AppVarInput input, @Nullable List<RProcessREnvironment> updateEnvirs) {
        if (!UIAccess.isOkToUse((Viewer)this.treeViewer)) {
            return;
        }
        this.isUpdating = true;
        this.inputContentProvider.setInput((RElementInput)input);
        Set previousReferences = this.inputContentProvider.resetUsedReferences();
        if (input != null && updateEnvirs != null) {
            for (RProcessREnvironment entry : updateEnvirs) {
                this.treeViewer.refresh((Object)entry, true);
            }
            if (!previousReferences.isEmpty()) {
                Set usedReferences = this.inputContentProvider.getUsedReferences();
                block1: for (RReference reference : previousReferences) {
                    if (usedReferences.contains(reference)) continue;
                    for (RProcessREnvironment entry : updateEnvirs) {
                        if (entry.getHandle() != reference.getHandle()) continue;
                        this.treeViewer.refresh((Object)reference, true);
                        continue block1;
                    }
                }
            }
        } else {
            this.treeViewer.refresh(true);
        }
        this.updateSelectionInfo((ITreeSelection)this.actionUtil.getSelectionProvider().getSelection());
    }

    private void updateFilter() {
        this.inputUpdater.schedule();
    }

    private void clearActionInfo() {
        this.actionUtil.getStatusLine().clearAll();
    }

    private void updateSelectionInfo(ITreeSelection selection) {
        if (this.isUpdating) {
            return;
        }
        Object infoObject = null;
        String message = null;
        if (infoObject == null || !infoObject.equals(this.currentInfoObject)) {
            this.clearActionInfo();
        }
        this.currentInfoObject = infoObject;
        this.actionUtil.getStatusLine().setSelectionMessage((IStatus)(message != null ? new StatusInfo(0, message) : null));
    }

    public @Nullable RProcess getTool() {
        return this.process;
    }

    public void addToolListener(ActiveToolListener action) {
        this.toolListeners.add((Object)action);
    }

    public void removeToolListener(ActiveToolListener action) {
        this.toolListeners.remove((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTool(@Nullable Tool tool, boolean update) {
        RProcess process;
        RProcess rProcess = process = tool != null && tool.isProvidingFeatureSet("org.eclipse.statet.r.data") && !tool.isTerminated() ? (RProcess)tool : null;
        if (this.process == tool) {
            return;
        }
        RProcess oldProcess = process;
        Object object = this.sourceLock;
        synchronized (object) {
            this.process = process;
        }
        ActiveToolListener.ActiveToolEvent event = new ActiveToolListener.ActiveToolEvent(1, (Tool)process);
        for (ActiveToolListener listener : this.toolListeners) {
            listener.onToolChanged(event);
        }
        this.setApp(process != null ? AppRegistry.getInstance().getApp((Tool)process) : null, update);
    }

    public @Nullable RApp getApp() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setApp(@Nullable RApp app, boolean update) {
        if (app != null && app.getVariables() == null) {
            app = null;
        }
        if (this.app == app) {
            return;
        }
        RApp oldApp = this.app;
        if (oldApp != null) {
            oldApp.removeListener(this.inputUpdater);
        }
        Object object = this.sourceLock;
        synchronized (object) {
            this.app = app;
        }
        this.clearActionInfo();
        this.inputUpdater.forceUpdate(app);
        if (app != null) {
            this.setContentDescription(this.computeContentDescription(app));
            app.addListener(this.inputUpdater);
        } else {
            this.setContentDescription("No app at this time.");
        }
        if (update) {
            this.inputUpdater.schedule();
            if (app == null && oldApp == this.shownByLauncher) {
                Display.getCurrent().timerExec(200, () -> this.showPreviousView(oldApp));
            }
        }
    }

    private String computeContentDescription(RApp app) {
        StringBuilder sb = new StringBuilder();
        VariablesData vars = app.getVariables();
        if (vars != null) {
            sb.append(vars.getExpression());
        } else {
            sb.append("<no available>");
        }
        IResource resource = app.getResource();
        if (resource != null) {
            if (sb.length() > 0) {
                sb.append("\u2002\u2013\u2002");
            }
            sb.append(resource.getFullPath().toString());
        }
        return sb.toString();
    }

    public boolean getFilterIncludeInternal() {
        return this.filterIncludeInternal;
    }

    public String getFilterSearchText() {
        return this.filterText;
    }

    public void setShownByLauncher(RApp app) {
        this.shownByLauncher = app;
    }

    private void showPreviousView(RApp oldApp) {
        IWorkbenchPage page;
        IViewPart[] viewStack;
        if (this.app == null && oldApp == this.shownByLauncher && (viewStack = (page = this.getSite().getPage()).getViewStack((IViewPart)this)) != null && viewStack.length >= 2 && viewStack[0] == this) {
            page.bringToTop((IWorkbenchPart)viewStack[1]);
        }
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == Control.class) {
            return (T)this.treeViewer.getTree();
        }
        if (adapterType == Tool.class) {
            return (T)this.process;
        }
        return (T)super.getAdapter(adapterType);
    }

    private class FilterInternalHandler
    extends AbstractHandler
    implements IElementUpdater {
        private FilterInternalHandler() {
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            AppVarView.this.filterIncludeInternal = !AppVarView.this.filterIncludeInternal;
            AppVarView.this.settings.put(AppVarView.FILTER_INCLUDE_INTERNAL_SETTINGS_KEY, AppVarView.this.filterIncludeInternal);
            AppVarView.this.updateFilter();
            return null;
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setChecked(AppVarView.this.filterIncludeInternal);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }

    private class RefreshHandler
    extends AbstractToolHandler<RProcess> {
        public RefreshHandler() {
            super("R", null, (ToolProvider)AppVarView.this, (IServiceLocator)AppVarView.this.getSite());
            this.init();
        }

        protected boolean evaluateIsEnabled(RProcess tool, @Nullable Object evaluationContext) {
            return super.evaluateIsEnabled((Tool)tool, evaluationContext) && AppVarView.this.getApp() != null;
        }

        protected void refreshElements() {
            WorkbenchUIUtils.refreshCommandElements((String)AppVarView.REFRESH_COMMAND_ID, (IHandler2)this, null);
        }

        protected @Nullable Object execute(RProcess tool, ExecutionEvent event) {
            RApp app = AppVarView.this.getApp();
            if (app != null) {
                app.refreshVariables();
            }
            return null;
        }
    }
}

