/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.models.core.util.BasicElementProxy;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.ui.util.RElementInput;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;

@NonNullByDefault
public class RElementInputContentProvider<TInput extends RElementInput<?>>
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final PartitionFactory partitionFactory = new PartitionFactory();
    private @Nullable TInput activeInput;
    private Set<RReference> usedReferences = new HashSet<RReference>();

    public static @Nullable CombinedRElement getCombinedRElement(Object object) {
        LtkModelElement modelElement;
        if (object instanceof CombinedRElement) {
            return (CombinedRElement)object;
        }
        if (object instanceof IAdaptable && (modelElement = (LtkModelElement)((IAdaptable)object).getAdapter(LtkModelElement.class)) instanceof CombinedRElement) {
            return (CombinedRElement)modelElement;
        }
        return null;
    }

    public void dispose() {
    }

    public void setInput(@Nullable TInput input) {
        this.activeInput = input;
    }

    public @Nullable TInput getInput() {
        return this.activeInput;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements;
        if (this.activeInput != null && (elements = ((RElementInput)this.activeInput).getRootElements()) != null) {
            return elements;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof RElementPartition) {
            return true;
        }
        return this.hasChildren((CombinedRElement)element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RElementPartition) {
            return ((RElementPartition)((Object)element)).partition.getElements((Object)((CombinedRList)RElementInputContentProvider.getCombinedRElement(element)));
        }
        return this.getChildren((CombinedRElement)element);
    }

    private boolean hasChildren(CombinedRElement rElement) {
        switch (rElement.getRObjectType()) {
            case 6: 
            case 7: {
                return rElement.getLength() > 0L;
            }
            case 8: {
                if (((RElementInput)this.activeInput).hasEnvFilter()) {
                    return ((RElementInput)this.activeInput).getEnvChildren(rElement).length > 0;
                }
                return rElement.getLength() > 0L;
            }
            case 14: {
                RObject realObject = ((RReference)rElement).getResolvedRObject();
                if (realObject != null) {
                    this.usedReferences.add((RReference)rElement);
                    return this.hasChildren((CombinedRElement)realObject);
                }
                return false;
            }
            case 10: {
                return rElement.hasModelChildren(((RElementInput)this.activeInput).getOtherFilter());
            }
        }
        return false;
    }

    private Object[] getChildren(CombinedRElement rElement) {
        switch (rElement.getRObjectType()) {
            case 6: {
                return rElement.getModelChildren(null).toArray();
            }
            case 7: {
                if (rElement.hasModelChildren(null)) {
                    return this.partitionFactory.getElements((CombinedRList)rElement, rElement.getLength());
                }
                return NO_CHILDREN;
            }
            case 8: {
                if (((RElementInput)this.activeInput).hasEnvFilter()) {
                    Object[] children = ((RElementInput)this.activeInput).getEnvChildren(rElement);
                    if (children.length > 5000) {
                        return this.partitionFactory.getElements((CombinedRList)rElement, children.length);
                    }
                    return children;
                }
                if (rElement.getLength() > 5000L && rElement.hasModelChildren(null)) {
                    return this.partitionFactory.getElements((CombinedRList)rElement, rElement.getLength());
                }
                return rElement.getModelChildren(null).toArray();
            }
            case 14: {
                RObject realObject = ((RReference)rElement).getResolvedRObject();
                if (realObject != null) {
                    return this.getChildren((CombinedRElement)realObject);
                }
                return NO_CHILDREN;
            }
            case 10: {
                return rElement.getModelChildren(((RElementInput)this.activeInput).getOtherFilter()).toArray();
            }
        }
        return NO_CHILDREN;
    }

    public @Nullable Object getParent(Object element) {
        return null;
    }

    public Set<RReference> resetUsedReferences() {
        if (this.usedReferences.isEmpty()) {
            return Collections.emptySet();
        }
        Set<RReference> previousReferences = this.usedReferences;
        this.usedReferences = new HashSet<RReference>();
        return previousReferences;
    }

    public Set<RReference> getUsedReferences() {
        return this.usedReferences;
    }

    private class PartitionFactory
    extends ElementPartitionFactory<Object, CombinedRList> {
        public PartitionFactory() {
            super(Object.class, 100);
        }

        protected RElementPartition createPartition(CombinedRList value, ElementPartitionFactory.PartitionHandle partition) {
            return new RElementPartition((CombinedRElement)value, partition);
        }

        protected Object[] getChildren(CombinedRList value, long start, int length) {
            if (((RElementInput)RElementInputContentProvider.this.activeInput).hasEnvFilter() && value instanceof RProcessREnvironment) {
                Object[] all = ((RElementInput)RElementInputContentProvider.this.activeInput).getEnvChildren((CombinedRElement)value);
                if (start == 0L && length == all.length) {
                    return all;
                }
                Object[] children = new Object[length];
                System.arraycopy(all, (int)start, children, 0, length);
                return children;
            }
            if (start == 0L && (long)length == value.getLength()) {
                return value.getModelChildren(null).toArray();
            }
            Object[] children = new Object[length];
            int i = 0;
            while (i < length) {
                children[i] = value.get(start + (long)i);
                ++i;
            }
            return children;
        }
    }

    static class RElementPartition
    extends BasicElementProxy
    implements ElementPartition {
        private final ElementPartitionFactory.PartitionHandle partition;

        public RElementPartition(CombinedRElement value, ElementPartitionFactory.PartitionHandle partition) {
            super((IAdaptable)value);
            this.partition = partition;
        }

        public long getPartitionStart() {
            return this.partition.getStart();
        }

        public long getPartitionLength() {
            return this.partition.getLength();
        }

        public int hashCode() {
            return super.hashCode() ^ this.partition.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RElementPartition) {
                return super.equals(obj) && this.partition.equals(((RElementPartition)((Object)obj)).partition);
            }
            return false;
        }
    }
}

