/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;

public class RDataFormatterConverter
implements IDisplayConverter {
    private final AbstractRDataProvider<?> fDataProvider;
    RDataFormatter fFallbackFormatter;

    public RDataFormatterConverter(AbstractRDataProvider<?> dataProvider) {
        this.fDataProvider = dataProvider;
    }

    private RDataFormatter getFormatter(ILayerCell cell) {
        RDataFormatter formatter;
        RDataTableContentDescription description = this.fDataProvider.getDescription();
        if (description != null && (formatter = this.getFormatter(description, cell)) != null) {
            return formatter;
        }
        if (this.fFallbackFormatter == null) {
            this.fFallbackFormatter = new RDataFormatter();
        }
        return this.fFallbackFormatter;
    }

    protected @Nullable RDataFormatter getFormatter(RDataTableContentDescription description, ILayerCell cell) {
        if ((cell.getDim(Orientation.HORIZONTAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L && (cell.getDim(Orientation.VERTICAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L) {
            List<RDataTableColumn> columns = description.getDataColumns();
            long index = this.getColumnIndex(cell);
            if (index >= 0L && index < (long)columns.size()) {
                return columns.get((int)index).getDefaultFormat();
            }
            return description.getDefaultDataFormat();
        }
        return null;
    }

    protected long getColumnIndex(ILayerCell cell) {
        return cell.getDim(Orientation.HORIZONTAL).getId() & 0xFFFFFFFFFFFFFL;
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        return this.getFormatter(cell).modelToDisplayValue(canonicalValue);
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        throw new UnsupportedOperationException();
    }

    public static class RowHeader
    extends RDataFormatterConverter {
        public RowHeader(AbstractRDataProvider<?> dataProvider) {
            super(dataProvider);
        }

        @Override
        protected RDataFormatter getFormatter(RDataTableContentDescription description, ILayerCell cell) {
            if ((cell.getDim(Orientation.VERTICAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L) {
                List<RDataTableColumn> columns = description.getRowHeaderColumns();
                long index = this.getColumnIndex(cell);
                if (columns != null && index >= 0L && index < (long)columns.size()) {
                    return columns.get((int)index).getDefaultFormat();
                }
            }
            return null;
        }
    }
}

