/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImArrayList;
import org.eclipse.statet.internal.jcommons.collections.ImArraySet;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptySet;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonSet;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public final class ImCollections {
    private static <E> boolean containsEqual(E[] array, int startIdx, int endIdx, E e) {
        if (e == null) {
            int idx = 0;
            while (idx < endIdx) {
                if (array[idx] == null) {
                    return true;
                }
                ++idx;
            }
            return false;
        }
        int idx = 0;
        while (idx < endIdx) {
            if (e.equals(array[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private static <E> boolean containsIdentical(E[] array, int startIdx, int endIdx, E e) {
        int idx = 0;
        while (idx < endIdx) {
            if (e == array[idx]) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static <E> ImList<E> emptyList() {
        return ImEmptyList.INSTANCE;
    }

    public static <E> ImList<E> newList() {
        return ImEmptyList.INSTANCE;
    }

    public static <E> ImList<E> newList(E e) {
        return new ImSingletonList<E>(e);
    }

    @SafeVarargs
    public static <E> ImList<E> newList(E ... e) {
        if (e.length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonList<E>(e[0]);
        }
        return new ImArrayList<E>(e);
    }

    public static <E> ImList<E> newList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonList<E>(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImArrayList<E>(e);
        }
        return new ImArrayList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImList<E> newList(E[] e, Comparator<? super E> comparator) {
        int n = e.length;
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(e[0]);
        }
        Arrays.sort(e, 0, n, comparator);
        return new ImArrayList<E>(e);
    }

    public static <E> ImList<E> toList(Collection<? extends E> c) {
        if (c instanceof AbstractImList) {
            return ((AbstractImList)((Object)c)).toImList();
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList(c instanceof List ? ((List)c).get(0) : c.toArray()[0]);
        }
        return new ImArrayList<Object>(c.toArray());
    }

    public static <E> ImList<E> toList(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return ImCollections.toList((Collection)iterable);
        }
        Iterator<E> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return ImEmptyList.INSTANCE;
        }
        E first = iter.next();
        if (!iter.hasNext()) {
            return new ImSingletonList<E>(first);
        }
        ArrayList<E> list = new ArrayList<E>();
        list.add(first);
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return new ImArrayList<Object>(list.toArray());
    }

    public static <E> ImList<E> toList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonList<E>(e[startIdx]);
        }
        return new ImArrayList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImList<E> toList(Collection<? extends E> c, @Nullable Comparator<? super E> comparator) {
        int n = c.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList(c instanceof List ? ((List)c).get(0) : c.toArray()[0]);
        }
        Object[] a = c.toArray();
        Arrays.sort(a, 0, a.length, comparator);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> clearToList(Collection<? extends E> c) {
        ImList<? extends E> list = ImCollections.toList(c);
        c.clear();
        return list;
    }

    public static <E> ImList<E> toNonNullList(Iterable<? extends E> iterable) {
        ImList<E> list = ImCollections.toList(iterable);
        int n = list.size();
        int i = 0;
        while (i < n) {
            if (list.get(i) == null) {
                throw new NullPointerException(String.format("[%1$s]", i));
            }
            ++i;
        }
        return list;
    }

    private static void copyTo(Collection<?> src, Object[] dest, int destPos) {
        if (src instanceof AbstractImList) {
            ((AbstractImList)((Object)src)).copyTo(dest, destPos);
        } else if (destPos == 0) {
            src.toArray(dest);
        } else {
            Object[] a = src.toArray();
            System.arraycopy(a, 0, dest, destPos, a.length);
        }
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toList(l2);
        }
        if (n == n1) {
            return ImCollections.toList(l1);
        }
        Object[] a = new Object[n];
        ImCollections.copyTo(l1, a, 0);
        ImCollections.copyTo(l2, a, n1);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2, Collection<? extends E> l3) {
        int n1 = l1.size();
        int n12 = n1 + l2.size();
        int n = n12 + l3.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n12 == 0) {
            return ImCollections.toList(l3);
        }
        if (n == n1) {
            return ImCollections.toList(l1);
        }
        if (n1 == 0 && n == n12) {
            return ImCollections.toList(l2);
        }
        Object[] a = new Object[n];
        if (n1 != 0) {
            ImCollections.copyTo(l1, a, 0);
        }
        if (n12 != n1) {
            ImCollections.copyTo(l2, a, n1);
        }
        if (n != n12) {
            ImCollections.copyTo(l3, a, n12);
        }
        return new ImArrayList<Object>(a);
    }

    @SafeVarargs
    public static <E> ImList<E> concatList(Collection<? extends E> ... lists) {
        switch (lists.length) {
            case 0: {
                return ImEmptyList.INSTANCE;
            }
            case 1: {
                return ImCollections.toList(lists[0]);
            }
            case 2: {
                return ImCollections.concatList(lists[0], lists[1]);
            }
            case 3: {
                return ImCollections.concatList(lists[0], lists[1], lists[2]);
            }
        }
        int n = 0;
        int i = 0;
        while (i < lists.length) {
            n += lists[i].size();
            ++i;
        }
        Object[] a = new Object[n];
        n = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            int ni = lists[i2].size();
            if (ni != 0) {
                ImCollections.copyTo(lists[i2], a, n);
                n += ni;
            }
            ++i2;
        }
        return ImCollections.newList(a);
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2, Comparator<? super E> comparator) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toList(l2, comparator);
        }
        if (n == n1) {
            return ImCollections.toList(l1, comparator);
        }
        Object[] a = new Object[n];
        ImCollections.copyTo(l1, a, 0);
        ImCollections.copyTo(l2, a, n1);
        Arrays.sort(a, 0, a.length, comparator);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> concatList(@NonNull Collection<? extends E>[] lists, Comparator<? super E> comparator) {
        switch (lists.length) {
            case 0: {
                return ImEmptyList.INSTANCE;
            }
            case 1: {
                return ImCollections.toList(lists[0], comparator);
            }
            case 2: {
                return ImCollections.concatList(lists[0], lists[1], comparator);
            }
        }
        int n = 0;
        int i = 0;
        while (i < lists.length) {
            n += lists[i].size();
            ++i;
        }
        Object[] a = new Object[n];
        n = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            ImCollections.copyTo(lists[i2], a, n);
            n += lists[i2].size();
            ++i2;
        }
        Arrays.sort(a, 0, a.length, comparator);
        return ImCollections.newList(a);
    }

    public static <E> ImList<E> addElement(List<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        Object[] a = new Object[n1 + 1];
        ImCollections.copyTo(l, a, 0);
        a[n1] = e;
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> addElement(List<? extends E> l, int index, E e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        Object[] a = new Object[n1 + 1];
        if (index == 0) {
            ImCollections.copyTo(l, a, 1);
        } else if (index == n1) {
            ImCollections.copyTo(l, a, 0);
        } else if (l instanceof AbstractImList) {
            ((AbstractImList)((Object)l)).copyTo(0, a, 0, index);
            ((AbstractImList)((Object)l)).copyTo(index, a, index + 1, n1 - index);
        } else {
            ImCollections.copyTo(l, a, 0);
            System.arraycopy(a, index, a, index + 1, n1 - index);
        }
        a[index] = e;
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> addElementIfAbsent(List<? extends E> l, E e) {
        if (l.isEmpty()) {
            return new ImSingletonList<E>(e);
        }
        if (!l.contains(e)) {
            return ImCollections.addElement(l, e);
        }
        return ImCollections.toList(l);
    }

    public static <E> ImList<E> addElementIfAbsent(List<? extends E> l, E e, @Nullable Comparator<? super E> comparator) {
        if (l.isEmpty()) {
            return new ImSingletonList<E>(e);
        }
        int index = Collections.binarySearch(l, e, comparator);
        if (index < 0) {
            return ImCollections.addElement(l, -(index + 1), e);
        }
        return ImCollections.toList(l);
    }

    public static <E> ImList<E> setElement(List<? extends E> l, int index, E e) {
        int n = l.size();
        if (index < 0 || index >= n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 1) {
            return new ImSingletonList<E>(e);
        }
        Object[] a = l.toArray();
        a[index] = e;
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> removeElement(List<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return ImCollections.toList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImList<E> removeElement(List<? extends E> l, int index) {
        int n = l.size() - 1;
        if (index < 0 || index > n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> emptyIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    public static <E> ImIdentityList<E> newIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    public static <E> ImIdentityList<E> newIdentityList(E e) {
        return new ImSingletonIdentityList<E>(e);
    }

    @SafeVarargs
    public static <E> ImIdentityList<E> newIdentityList(E ... e) {
        if (e.length == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonIdentityList<E>(e[0]);
        }
        return new ImArrayIdentityList<E>(e);
    }

    public static <E> ImIdentityList<E> newIdentityList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonIdentityList<E>(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImArrayIdentityList<E>(e);
        }
        return new ImArrayIdentityList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImIdentityList<E> toIdentityList(Collection<? extends E> c) {
        if (c instanceof AbstractImList) {
            return ((AbstractImList)((Object)c)).toImIdentityList();
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return new ImArrayIdentityList<Object>(c.toArray());
    }

    public static <E> ImIdentityList<E> concatList(IdentityCollection<? extends E> l1, IdentityCollection<? extends E> l2) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toIdentityList(l2);
        }
        if (n == n1) {
            return ImCollections.toIdentityList(l1);
        }
        Object[] a = new Object[n];
        ImCollections.copyTo(l1, a, 0);
        ImCollections.copyTo(l2, a, n1);
        return new ImArrayIdentityList<Object>(a);
    }

    public static <E> ImIdentityList<E> addElement(IdentityList<? extends E> l, E e) {
        if (l.isEmpty()) {
            return new ImSingletonIdentityList<E>(e);
        }
        Object[] a = new Object[l.size() + 1];
        ImCollections.copyTo(l, a, 0);
        a[l.size()] = e;
        return new ImArrayIdentityList<Object>(a);
    }

    public static <E> ImIdentityList<E> addElement(IdentityList<? extends E> l, int index, E e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImSingletonIdentityList<E>(e);
        }
        Object[] a = new Object[n1 + 1];
        if (index == 0) {
            ImCollections.copyTo(l, a, 1);
        } else if (index == n1) {
            ImCollections.copyTo(l, a, 0);
        } else if (l instanceof AbstractImList) {
            ((AbstractImList)((Object)l)).copyTo(0, a, 0, index);
            ((AbstractImList)((Object)l)).copyTo(index, a, index + 1, n1 - index);
        } else {
            ImCollections.copyTo(l, a, 0);
            System.arraycopy(a, index, a, index + 1, n1 - index);
        }
        a[index] = e;
        return new ImArrayIdentityList<Object>(a);
    }

    public static <E> ImIdentityList<E> removeElement(IdentityList<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return ImCollections.toIdentityList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImList<E> removeElement(IdentityList<? extends E> l, int index) {
        int n = l.size() - 1;
        if (index < 0 || index > n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> removeLastElement(IdentityList<? extends E> l, Object e) {
        int index = l.lastIndexOf(e);
        if (index < 0) {
            return ImCollections.toIdentityList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImSet<E> emptySet() {
        return ImEmptySet.INSTANCE;
    }

    public static <E> ImSet<E> newSet() {
        return ImEmptySet.INSTANCE;
    }

    public static <E> ImSet<E> newSet(E e) {
        return new ImSingletonSet<E>(e);
    }

    private static <E> ImSet<E> newSetFromArray(E[] array, int startIdx, int endIdx) {
        int idx = startIdx + 1;
        while (idx < endIdx) {
            if (ImCollections.containsEqual(array, startIdx, idx, array[idx])) {
                Object[] checked = (Object[])Array.newInstance(array.getClass().getComponentType(), endIdx - startIdx - 1);
                System.arraycopy(array, startIdx, checked, 0, idx - startIdx);
                int length = idx++;
                while (idx < endIdx) {
                    if (!ImCollections.containsEqual(checked, 0, length, array[idx])) {
                        checked[length++] = array[idx];
                    }
                    ++idx;
                }
                if (length == 1) {
                    return new ImSingletonSet<Object>(checked[0]);
                }
                if (length == checked.length) {
                    return new ImArraySet<Object>(checked);
                }
                return new ImArraySet<Object>(Arrays.copyOfRange(checked, 0, length));
            }
            ++idx;
        }
        return new ImArraySet<E>(array);
    }

    @SafeVarargs
    public static <E> ImSet<E> newSet(E ... e) {
        if (e.length == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonSet<E>(e[0]);
        }
        return ImCollections.newSetFromArray(e, 0, e.length);
    }

    public static <E> ImSet<E> newSet(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonSet<E>(e[startIdx]);
        }
        return ImCollections.newSetFromArray(e, startIdx, startIdx + length);
    }

    public static <E> ImSet<E> toSet(Collection<? extends E> c) {
        if (c instanceof ImSet) {
            return (ImSet)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonSet<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return ImCollections.newSetFromArray(c.toArray(), 0, n);
    }

    public static <E> ImSet<E> toNonNullSet(Collection<? extends E> c) {
        ImSet<E> set = ImCollections.toSet(c);
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) {
                throw new NullPointerException(String.format("[%1$s]", i));
            }
            ++i;
        }
        return set;
    }

    public static <E> ImIdentitySet<E> emptyIdentitySet() {
        return ImEmptyIdentitySet.INSTANCE;
    }

    public static <E> ImIdentitySet<E> newIdentitySet() {
        return ImEmptyIdentitySet.INSTANCE;
    }

    public static <E> ImIdentitySet<E> newIdentitySet(E e) {
        return new ImSingletonIdentitySet<E>(e);
    }

    private static <E> ImIdentitySet<E> newIdentitySetFromArray(E[] array, int startIdx, int endIdx) {
        int idx = startIdx + 1;
        while (idx < endIdx) {
            if (ImCollections.containsIdentical(array, startIdx, idx, array[idx])) {
                Object[] checked = (Object[])Array.newInstance(array.getClass().getComponentType(), endIdx - startIdx - 1);
                System.arraycopy(array, startIdx, checked, 0, idx - startIdx);
                int length = idx++;
                while (idx < endIdx) {
                    if (!ImCollections.containsIdentical(checked, 0, length, array[idx])) {
                        checked[length++] = array[idx];
                    }
                    ++idx;
                }
                if (length == 1) {
                    return new ImSingletonIdentitySet<Object>(checked[0]);
                }
                if (length == checked.length) {
                    return new ImArrayIdentitySet<Object>(checked);
                }
                return new ImArrayIdentitySet<Object>(Arrays.copyOfRange(checked, 0, length));
            }
            ++idx;
        }
        return new ImArrayIdentitySet<E>(array);
    }

    @SafeVarargs
    public static <E> ImIdentitySet<E> newIdentitySet(E ... e) {
        if (e.length == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonIdentitySet<E>(e[0]);
        }
        return ImCollections.newIdentitySetFromArray(e, 0, e.length);
    }

    public static <E> ImIdentitySet<E> newIdentitySet(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonIdentitySet<E>(e[startIdx]);
        }
        return ImCollections.newIdentitySetFromArray(e, startIdx, startIdx + length);
    }

    public static <E> ImIdentitySet<E> toIdentitySet(Collection<? extends E> c) {
        if (c instanceof ImSet) {
            return (ImIdentitySet)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentitySet<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return ImCollections.newIdentitySetFromArray(c.toArray(), 0, n);
    }

    private ImCollections() {
    }
}

