/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.ui.workbench.DecoratingStyledLabelProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;

public class TextSearchLabelUtil {
    public static final String HIGHLIGHT_COLOR_KEY = "org.eclipse.search.ui.match.highlight";
    public static final StyledString.Styler HIGHLIGHT_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.search.ui.match.highlight");
    public static final Collection<String> DEFAULT_SEARCH_LABEL_PROPERTIES;
    private static final int MAX_SHOWN_LINE = 200;
    private static final int MIN_SHOWN_CONTEXT = 20;
    private static final String ELLIPSIS = " ... ";

    static {
        HashSet<String> properties = new HashSet<String>();
        properties.addAll(DecoratingStyledLabelProvider.DEFAULT_UPDATE_PROPERTIES);
        properties.add(HIGHLIGHT_COLOR_KEY);
        DEFAULT_SEARCH_LABEL_PROPERTIES = Collections.unmodifiableSet(properties);
    }

    private int findStart(String text, int offset, int maxCount) {
        int end = Math.min(offset + maxCount, text.length());
        while (offset < end) {
            char c = text.charAt(offset);
            if (!Character.isWhitespace(c)) break;
            ++offset;
        }
        return offset;
    }

    private int findEnd(String text, int offset, int maxCount) {
        int start = Math.min(offset - maxCount, 0);
        while (offset > start) {
            char c = text.charAt(offset - 1);
            if (!Character.isWhitespace(c)) break;
            --offset;
        }
        return offset;
    }

    public StyledString getStyledText(LineElement<?> lineElement, List<? extends Match> matches) {
        int lineNumber = lineElement.getLine();
        StyledString text = new StyledString(String.valueOf(lineNumber) + ": ", StyledString.QUALIFIER_STYLER);
        String lineText = lineElement.getText();
        int idx = this.findStart(lineText, 0, lineText.length());
        int i = 0;
        while (i < matches.size() && text.length() < 200) {
            Match match = matches.get(i);
            int matchStart = Math.max(match.getOffset() - lineElement.getOffset(), 0);
            int matchEnd = Math.min(match.getOffset() + match.getLength() - lineElement.getOffset(), lineElement.getLength());
            if (matchStart - idx < 50) {
                text.append(lineText.substring(idx, matchStart));
            } else {
                text.append(lineText.substring(idx, this.findEnd(lineText, idx + 20, 20)));
                text.append(ELLIPSIS, StyledString.QUALIFIER_STYLER);
                text.append(lineText.substring(this.findStart(lineText, matchStart - 20, 20), matchStart));
            }
            text.append(lineText.substring(matchStart, matchEnd), HIGHLIGHT_STYLE);
            idx = matchEnd;
            ++i;
        }
        if (idx < lineText.length()) {
            if (lineText.length() - idx < 30) {
                text.append(lineText.substring(idx, lineText.length()));
            } else {
                text.append(lineText.substring(idx, this.findEnd(lineText, idx + 20, 20)));
                text.append(ELLIPSIS, StyledString.QUALIFIER_STYLER);
            }
        }
        return text;
    }
}

