/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class LaunchConfigPresets {
    public static final String UNDEFINED_VALUE = "!UNDEFINED!";
    private static final String NAME_ATTR_NAME = "Preset.name";
    private final ILaunchConfigurationType type;
    private final List<ILaunchConfiguration> presets = new ArrayList<ILaunchConfiguration>();

    static boolean isInternalArgument(String name) {
        return name.startsWith("Preset.");
    }

    static String getName(ILaunchConfiguration preset) {
        try {
            return (String)ObjectUtils.nonNullAssert((Object)preset.getAttribute(NAME_ATTR_NAME, null));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    static void apply(Map<String, Object> preset, ILaunchConfigurationWorkingCopy config) {
        for (Map.Entry<String, Object> entry : preset.entrySet()) {
            String name = entry.getKey();
            if (LaunchConfigPresets.isInternalArgument(name)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                if (value.equals(UNDEFINED_VALUE)) {
                    config.removeAttribute(name);
                    continue;
                }
                config.setAttribute(name, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                config.setAttribute(name, value);
                continue;
            }
            if (value instanceof Boolean) {
                config.setAttribute(name, value);
                continue;
            }
            if (value instanceof List) {
                config.setAttribute(name, (List)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            config.setAttribute(name, (Map)value);
        }
    }

    public static void apply(ILaunchConfiguration preset, ILaunchConfigurationWorkingCopy config) {
        try {
            LaunchConfigPresets.apply(preset.getAttributes(), config);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public LaunchConfigPresets(String typeId) {
        this.type = (ILaunchConfigurationType)ObjectUtils.nonNullAssert((Object)DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId));
    }

    public ILaunchConfigurationWorkingCopy add(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            ILaunchConfigurationWorkingCopy preset = this.type.newInstance(null, "template").getWorkingCopy();
            preset.setAttribute(NAME_ATTR_NAME, name);
            this.presets.add((ILaunchConfiguration)preset);
            return preset;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public @Nullable ILaunchConfiguration get(String name) {
        for (ILaunchConfiguration config : this.presets) {
            if (!name.equals(LaunchConfigPresets.getName(config))) continue;
            return config;
        }
        return null;
    }

    public ImList<ILaunchConfiguration> toList() {
        return ImCollections.toList(this.presets);
    }
}

