/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.build.EmbeddingReconcileTask;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainerEmbeddedExtension;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.InternStringCache;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;

@NonNullByDefault
public class LtxReconcilerExtension
implements WikidocSourceUnitModelContainerEmbeddedExtension {
    private final StringParserInput raInput = new StringParserInput(4096);
    private final LtxParser raParser = new LtxParser(null, (StringFactory)new InternStringCache(32));

    @Override
    public void reconcileEmbeddedAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, int level, IProgressMonitor monitor) {
        this.raInput.reset(content.getText());
        TexCommandSet commandSet = TexCore.getWorkbenchAccess().getTexCommandSet();
        for (EmbeddingAstNode embeddingAstNode : list) {
            if (embeddingAstNode.getForeignTypeId() != "Ltx") continue;
            SourceComponent component = this.raParser.parse((TextParserInput)this.raInput.init(embeddingAstNode.getStartOffset(), embeddingAstNode.getEndOffset()), (AstNode)embeddingAstNode, commandSet);
            embeddingAstNode.setForeignNode((AstNode)component);
        }
    }

    @Override
    public void reconcileEmbeddedModel(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, List<EmbeddingReconcileTask> list, int level, IProgressMonitor monitor) {
    }

    @Override
    public void reportEmbeddedProblems(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, ProblemRequestor problemRequestor, int level, IProgressMonitor monitor) {
    }
}

