/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.List;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditPropertyContext;
import org.eclipse.statet.ecommons.emf.core.util.EFeatureReference;
import org.eclipse.statet.ecommons.emf.core.util.RuleSet;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rtm.base.ui.RtModelUIPlugin;
import org.eclipse.statet.rtm.base.ui.rexpr.AlphaType;
import org.eclipse.statet.rtm.base.ui.rexpr.ColorType;
import org.eclipse.statet.rtm.base.ui.rexpr.FontFamilyType;
import org.eclipse.statet.rtm.base.ui.rexpr.HyperlinkType;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.statet.rtm.base.util.RExprType;
import org.eclipse.statet.rtm.rtdata.RtDataPackage;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.graphics.Image;

public class DefaultRExprTypeUIAdapters {
    static ElementNameProvider DIRECT_NAME = new DirectName();
    static ElementNameProvider LAST_NAME = new LastName();
    protected static final RExprTypeUIAdapter DATAFRAME_ADAPTER = new RObjectTypeAdapter(RExprType.DATAFRAME_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-dataframe"));
    protected static final RExprTypeUIAdapter EXPR_VALUE_ADAPTER = new CommonRExprAdapter(RExprType.EXPR_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr"));
    protected static final RExprTypeUIAdapter TEXT_VALUE_ADAPTER = new RExprTypeUIAdapter(RExprType.TEXT_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-text"));
    protected static final RExprTypeUIAdapter LABEL_TEXT_VALUE_ADAPTER = new LabelTextAdapter(RExprType.TEXT_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-text"));
    protected static final RExprTypeUIAdapter LABEL_EXPR_VALUE_ADAPTER = new LabelRExprAdapter(RExprType.EXPR_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr"));
    protected static final RExprTypeUIAdapter COLOR_EXPR_VALUE_ADAPTER = new ColorRExprAdapter(RExprType.EXPR_COLOR_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-color"));
    protected static final RExprTypeUIAdapter ALHPA_EXPR_VALUE_ADAPTER = new AlphaRExprAdapter(RExprType.EXPR_ALPHA_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr"));
    protected static final RExprTypeUIAdapter FONT_FAMILY_EXPR_VALUE_ADAPTER = new FontFamilyRExprAdapter(RExprType.EXPR_FONT_FAMILY_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr"));
    protected static final RExprTypeUIAdapter FUNCTION_ADAPTER = new RExprTypeUIAdapter(RExprType.EXPR_FUNCTION_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr"));
    protected static final RExprTypeUIAdapter DATAFRAME_COLUMN_ADAPTER = new RDataframeColumnTypeAdapter(RExprType.DATAFRAME_COLUMN_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-column"));
    protected static final RExprTypeUIAdapter DATAFRAME_COLUMNS_ADAPTER = new RDataframeColumnTypeAdapter(RExprType.DATAFRAME_COLUMN_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-column")){

        @Override
        protected boolean isMulti() {
            return true;
        }
    };
    protected static final RExprTypeUIAdapter LABEL_TEXT_VALUE_LINK_ADAPTER = new LabelTextAdapter(RExprType.TEXT_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-text")){

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new HyperlinkType(this);
        }
    };
    protected static final RExprTypeUIAdapter LABEL_EXPR_VALUE_LINK_ADAPTER = new LabelRExprAdapter(RExprType.EXPR_VALUE_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-expr")){

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new HyperlinkType(this);
        }
    };
    protected static final RExprTypeUIAdapter DATAFRAME_COLUMN_LINK_ADAPTER = new RDataframeColumnTypeAdapter(RExprType.DATAFRAME_COLUMN_TYPE, RtModelUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.rtm.base.ui/obj/rtype-column")){

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new HyperlinkType(this);
        }
    };

    public RExprTypeUIAdapter getUIAdapter(RExprType type, EStructuralFeature eFeature) {
        if (type == RExprType.DATAFRAME_TYPE) {
            return DATAFRAME_ADAPTER;
        }
        if (type == RExprType.EXPR_VALUE_TYPE) {
            if (eFeature.getEType() == RtDataPackage.Literals.RLABEL) {
                return LABEL_EXPR_VALUE_ADAPTER;
            }
            return EXPR_VALUE_ADAPTER;
        }
        if (type == RExprType.TEXT_VALUE_TYPE) {
            if (eFeature.getEType() == RtDataPackage.Literals.RLABEL) {
                return LABEL_TEXT_VALUE_ADAPTER;
            }
            return TEXT_VALUE_ADAPTER;
        }
        if (type == RExprType.EXPR_LABEL_VALUE_TYPE) {
            return LABEL_EXPR_VALUE_ADAPTER;
        }
        if (type == RExprType.EXPR_COLOR_VALUE_TYPE) {
            return COLOR_EXPR_VALUE_ADAPTER;
        }
        if (type == RExprType.EXPR_ALPHA_VALUE_TYPE) {
            return ALHPA_EXPR_VALUE_ADAPTER;
        }
        if (type == RExprType.EXPR_FONT_FAMILY_VALUE_TYPE) {
            return FONT_FAMILY_EXPR_VALUE_ADAPTER;
        }
        if (type == RExprType.EXPR_FUNCTION_TYPE) {
            return FUNCTION_ADAPTER;
        }
        if (type == RExprType.DATAFRAME_COLUMN_TYPE) {
            if (eFeature.isMany()) {
                return DATAFRAME_COLUMNS_ADAPTER;
            }
            return DATAFRAME_COLUMN_ADAPTER;
        }
        return null;
    }

    public static class AlphaRExprAdapter
    extends RExprTypeUIAdapter {
        public AlphaRExprAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new AlphaType(this);
        }
    }

    public static class ColorRExprAdapter
    extends RExprTypeUIAdapter {
        public ColorRExprAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new ColorType(this);
        }
    }

    public static class CommonRExprAdapter
    extends RExprTypeUIAdapter {
        public CommonRExprAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public int isValidInput(Object input, IContext context) {
            return 10;
        }
    }

    public static class DirectName
    implements ElementNameProvider {
        public @Nullable ElementName getElementName(Object selectionElement) {
            RElementName elementName;
            if (selectionElement instanceof RElement) {
                elementName = ((RElement)selectionElement).getElementName();
            } else if (selectionElement instanceof RElementName) {
                elementName = (ElementName)selectionElement;
            } else {
                return null;
            }
            return elementName;
        }
    }

    public static class FontFamilyRExprAdapter
    extends RExprTypeUIAdapter {
        public FontFamilyRExprAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public RExprWidget.TypeDef createWidgetDef() {
            return new FontFamilyType(this);
        }
    }

    public static class LabelRExprAdapter
    extends RExprTypeUIAdapter {
        public LabelRExprAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public String adopt(String typeKey, String expr) {
            if (typeKey == "chr") {
                return expr;
            }
            return super.adopt(typeKey, expr);
        }
    }

    public static class LabelTextAdapter
    extends RExprTypeUIAdapter {
        public LabelTextAdapter(RExprType type, Image image) {
            super(type, image);
        }

        @Override
        public String adopt(String typeKey, String expr) {
            if (typeKey == "r") {
                return expr;
            }
            return super.adopt(typeKey, expr);
        }
    }

    public static class LastName
    implements ElementNameProvider {
        public @Nullable ElementName getElementName(Object selectionElement) {
            RElementName elementName;
            if (selectionElement instanceof RElement) {
                elementName = ((RElement)selectionElement).getElementName();
            } else if (selectionElement instanceof RElementName) {
                elementName = (ElementName)selectionElement;
            } else {
                return null;
            }
            return elementName.getLastSegment();
        }
    }

    public static class RDataframeColumnTypeAdapter
    extends RExprTypeUIAdapter {
        public RDataframeColumnTypeAdapter(RExprType type, Image image) {
            super(type, image);
        }

        protected boolean isValidRObject(RObject rObject, RElement parent) {
            return rObject.getRObjectType() == 2 && parent instanceof RObject && ((RObject)parent).getRObjectType() == 6;
        }

        @Override
        protected int isValidElements(List<?> elements) {
            Object first = elements.get(0);
            if (first instanceof RElement) {
                RElement parent = ((RElement)first).getModelParent();
                if (parent instanceof RObject) {
                    if (((RObject)parent).getRObjectType() != 6) {
                        return 0;
                    }
                    for (Object element : elements) {
                        if (!(element instanceof RElement)) {
                            return 0;
                        }
                        RElement rElement = (RElement)element;
                        if (rElement.getElementName() == null || rElement.getModelParent() != parent) {
                            return 0;
                        }
                        if (!(element instanceof RObject) || ((RObject)element).getRObjectType() == 2) continue;
                        return 0;
                    }
                    return 20;
                }
                if (parent != null) {
                    for (Object element : elements) {
                        if (!(element instanceof RElement)) {
                            return 0;
                        }
                        RElement rElement = (RElement)element;
                        if (rElement.getElementName() == null || rElement.getModelParent() != parent) {
                            return 0;
                        }
                        switch (rElement.getElementName().getType()) {
                            case 26: 
                            case 28: {
                                break;
                            }
                            default: {
                                return 0;
                            }
                        }
                    }
                    return 10;
                }
                block11: for (Object element : elements) {
                    if (!(element instanceof RElement)) {
                        return 0;
                    }
                    RElement rElement = (RElement)element;
                    RElementName elementName = rElement.getElementName();
                    if (elementName == null) {
                        return 0;
                    }
                    if (elementName.getNextSegment() != null) {
                        RElementName parentName = null;
                        do {
                            parentName = elementName;
                        } while ((elementName = elementName.getNextSegment()).getNextSegment() != null);
                        switch (elementName.getType()) {
                            case 26: 
                            case 28: {
                                continue block11;
                            }
                            default: {
                                return 0;
                            }
                        }
                    }
                    switch (elementName.getType()) {
                        case 16: 
                        case 17: 
                        case 26: 
                        case 28: {
                            break;
                        }
                        default: {
                            return 0;
                        }
                    }
                }
                return 10;
            }
            return 0;
        }

        @Override
        public List<String> getInputExprs(Object input, IContext context) {
            ElementNameProvider nameProvider;
            List<?> elements = this.getElements(input);
            Object first = elements.get(0);
            if (first instanceof RElement) {
                nameProvider = DIRECT_NAME;
                RElement parent = ((RElement)first).getModelParent();
                if (parent instanceof RObject && !this.checkParent(parent, input, context)) {
                    return null;
                }
            } else {
                nameProvider = LAST_NAME;
            }
            return this.collectElementName(elements, nameProvider);
        }

        protected boolean checkParent(RElement parent, Object input, IContext context) {
            RElementName parentName;
            Object object = parentName = input instanceof ElementNameProvider ? ((ElementNameProvider)input).getElementName((Object)parent) : parent.getElementName();
            if (!(parentName instanceof RElementName)) {
                return true;
            }
            return this.checkParent(parentName, context, "data");
        }

        protected boolean checkParent(RElementName parentName, IContext context, String parentField) {
            EFeatureReference parent;
            if (parentName == null) {
                return true;
            }
            IEMFEditPropertyContext propertyContext = (IEMFEditPropertyContext)context.getAdapter(IEMFEditPropertyContext.class);
            RuleSet ruleSet = (RuleSet)context.getAdapter(RuleSet.class);
            if (propertyContext == null || ruleSet == null) {
                return true;
            }
            EObject owner = (EObject)((IObserving)propertyContext.getPropertyObservable()).getObserved();
            List parents = (List)ruleSet.get(owner, propertyContext.getEFeature(), String.valueOf(parentField) + ".parent.features");
            if (parents == null) {
                return true;
            }
            if (parents.isEmpty()) {
                return false;
            }
            EFeatureReference change = null;
            int i = 0;
            while (i < parents.size()) {
                parent = (EFeatureReference)parents.get(i);
                Object value = parent.getValue();
                if (value != null) {
                    if (!this.matches(value, parentName)) break;
                    return true;
                }
                ++i;
            }
            i = parents.size() - 1;
            while (i >= 0) {
                parent = (EFeatureReference)parents.get(i);
                if (parent.getValue() == null) {
                    change = parent;
                    break;
                }
                --i;
            }
            String newExpr = parentName.getDisplayName();
            if (change == null) {
                String oldExpr = ((RTypedExpr)((EFeatureReference)parents.get(0)).getValue()).getExpr();
                IShellProvider shellProvider = (IShellProvider)context.getAdapter(IShellProvider.class);
                MessageDialog dialog = new MessageDialog(shellProvider != null ? shellProvider.getShell() : null, "Change Dataframe", null, NLS.bind((String)"The column seems to belong to a different dataframe than specified in ''{0}''.\n\nDo you want to adapt the expression for the dataframe to ''{2}''?", (Object[])new Object[]{parentField, oldExpr, newExpr}), 3, new String[]{"Change dataframe", "Ignore", "Cancel"}, 0);
                switch (dialog.open()) {
                    case 0: {
                        change = (EFeatureReference)parents.get(0);
                        break;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        return true;
                    }
                }
            }
            Command command = SetCommand.create((EditingDomain)propertyContext.getEditingDomain(), (Object)change.getEObject(), (Object)change.getEFeature(), (Object)new RTypedExpr("r", newExpr));
            propertyContext.getEditingDomain().getCommandStack().execute(command);
            return true;
        }

        protected boolean matches(Object obj, RElementName expectedName) {
            if (obj instanceof RTypedExpr) {
                RTypedExpr rExpr = (RTypedExpr)obj;
                if (rExpr.getExpr().equals(expectedName.getDisplayName())) {
                    return true;
                }
                RElementName parsedName = RElementName.parseDefault((String)rExpr.getExpr());
                if (parsedName == null) {
                    return true;
                }
                if (!parsedName.equals(expectedName)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public int isMoveValid(Object input, IContext sourceContext, IContext context) {
            IEMFEditPropertyContext propertyContext = (IEMFEditPropertyContext)context.getAdapter(IEMFEditPropertyContext.class);
            IEMFEditPropertyContext sourcePropertyContext = (IEMFEditPropertyContext)sourceContext.getAdapter(IEMFEditPropertyContext.class);
            if (propertyContext != null && sourcePropertyContext != null && propertyContext.getEditingDomain() == sourcePropertyContext.getEditingDomain()) {
                if (propertyContext.getPropertyObservable() == sourcePropertyContext.getPropertyObservable()) {
                    return 20;
                }
                EObject owner = (EObject)((IObserving)propertyContext.getPropertyObservable()).getObserved();
                if (owner != null) {
                    List disjoints;
                    RuleSet ruleSet = (RuleSet)sourcePropertyContext.getAdapter(RuleSet.class);
                    EObject sourceObject = (EObject)((IObserving)sourcePropertyContext.getPropertyObservable()).getObserved();
                    if (ruleSet != null && sourceObject != null && (disjoints = (List)ruleSet.get(owner, propertyContext.getEFeature(), "disjoint.features")) != null) {
                        for (EFeatureReference disjoint : disjoints) {
                            if (disjoint.getEObject() != sourceObject || disjoint.getEFeature() != sourcePropertyContext.getEFeature()) continue;
                            return 20;
                        }
                    }
                }
                return 10;
            }
            return 0;
        }
    }

    public static class RObjectTypeAdapter
    extends RExprTypeUIAdapter {
        public RObjectTypeAdapter(RExprType type, Image image) {
            super(type, image);
        }

        protected boolean isValidRObject(RObject rObject) {
            return rObject.getRObjectType() == 6;
        }

        @Override
        public int isValidElement(Object element) {
            if (element instanceof RElement) {
                RElement rElement = (RElement)element;
                if (rElement.getElementName() == null) {
                    return 0;
                }
                if (element instanceof RObject) {
                    if (this.isValidRObject((RObject)element)) {
                        return 20;
                    }
                    return 0;
                }
                return 10;
            }
            return 0;
        }
    }
}

