/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TextViewerEditorColorUpdater {
    protected final ISourceViewer fViewer;
    protected final IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fListener;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;

    public TextViewerEditorColorUpdater(SourceViewer viewer, IPreferenceStore preferenceStore) {
        assert (viewer != null);
        assert (preferenceStore != null);
        this.fViewer = viewer;
        this.fPreferenceStore = preferenceStore;
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextViewerEditorColorUpdater.this.dispose();
            }
        });
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("AbstractTextEditor.Color.Foreground".equals(event.getProperty()) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.Background".equals(event.getProperty()) || "AbstractTextEditor.Color.Background.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionForeground".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionBackground".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(event.getProperty())) {
                    TextViewerEditorColorUpdater.this.updateColors();
                }
            }
        };
        this.fPreferenceStore.addPropertyChangeListener(this.fListener);
        this.updateColors();
    }

    protected void updateColors() {
        StyledText styledText = this.fViewer.getTextWidget();
        if (UIAccess.isOkToUse((Control)styledText)) {
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    protected Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return rgb != null ? new Color((Device)display, rgb) : null;
    }

    protected void dispose() {
        StyledText styledText;
        if (this.fListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fListener);
            this.fListener = null;
        }
        if (UIAccess.isOkToUse((Control)(styledText = this.fViewer.getTextWidget()))) {
            styledText.setForeground(null);
            styledText.setBackground(null);
            styledText.setSelectionForeground(null);
            styledText.setSelectionBackground(null);
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fSelectionForegroundColor != null) {
            this.fSelectionForegroundColor.dispose();
            this.fSelectionForegroundColor = null;
        }
        if (this.fSelectionBackgroundColor != null) {
            this.fSelectionBackgroundColor.dispose();
            this.fSelectionBackgroundColor = null;
        }
    }
}

