/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.editors.WikidocRweaveDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class RedocsWikitextRPlugin
extends AbstractUIPlugin {
    private static final String NS = "org.eclipse.statet.redocs.wikitext.r";
    public static final String OBJ_WIKIDOCRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/obj/WikidocRweave";
    public static final String TOOL_NEW_WIKIDOCRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/tool/New-WikidocRweave";
    public static final String WIZBAN_NEW_WIKIDOCRWEAVE_FILE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/wizban/New-WikidocRweaveFile";
    public static final String WIKITEXT_RWEAVE_EDITOR_NODE = "org.eclipse.statet.redocs.wikitext.r/rweavetex.editor/options";
    private static @Nullable RedocsWikitextRPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private @Nullable WikidocRweaveDocumentProvider docRDocumentProvider;
    private @Nullable IPreferenceStore editorPreferenceStore;
    private @Nullable ContextTypeRegistry codegenTemplateContextTypeRegistry;
    private @Nullable TemplateStore codegenTemplateStore;
    private @Nullable ContextTypeRegistry docTemplateContextTypeRegistry;
    private @Nullable TemplateStore docTemplateStore;
    private @Nullable ContentAssistComputerRegistry wikidocRweaveEditorContentAssistRegistry;

    public static RedocsWikitextRPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        RedocsWikitextRPlugin plugin = RedocsWikitextRPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RedocsWikitextRPlugin redocsWikitextRPlugin = this;
            synchronized (redocsWikitextRPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.codegenTemplateContextTypeRegistry = null;
                this.codegenTemplateStore = null;
                this.docTemplateContextTypeRegistry = null;
                this.docTemplateStore = null;
                this.wikidocRweaveEditorContentAssistRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(OBJ_WIKIDOCRWEAVE_IMAGE_ID, "obj_16", "wikidoc_rweave-file.png");
        util.register(TOOL_NEW_WIKIDOCRWEAVE_IMAGE_ID, "tool_16", "new-wikidoc_rweave-file.png");
        util.register(WIZBAN_NEW_WIKIDOCRWEAVE_FILE_IMAGE_ID, "wizban", "new-wikidoc_rweave-file.png");
    }

    public synchronized WikidocRweaveDocumentProvider getDocRDocumentProvider() {
        WikidocRweaveDocumentProvider documentProvider = this.docRDocumentProvider;
        if (documentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            documentProvider = new WikidocRweaveDocumentProvider();
            this.disposables.add(documentProvider);
            this.docRDocumentProvider = documentProvider;
        }
        return documentProvider;
    }

    public synchronized ContextTypeRegistry getCodegenTemplateContextTypeRegistry() {
        ContextTypeRegistry templateContextTypeRegistry = this.codegenTemplateContextTypeRegistry;
        if (templateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplateContextTypeRegistry = templateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.WikitextRweaveCodegen");
        }
        return templateContextTypeRegistry;
    }

    public synchronized TemplateStore getCodegenTemplateStore() {
        TemplateStore templateStore = this.codegenTemplateStore;
        if (templateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            templateStore = new ContributionTemplateStore(this.getCodegenTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/CodeTemplates_store");
            try {
                templateStore.load();
            }
            catch (IOException e) {
                RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, "An error occured when loading 'Wikitext+R code generation' template store.", (Throwable)e));
            }
            this.codegenTemplateStore = templateStore;
        }
        return templateStore;
    }

    public synchronized ContextTypeRegistry getDocTemplateContextTypeRegistry() {
        ContextTypeRegistry templateContextTypeRegistry = this.docTemplateContextTypeRegistry;
        if (templateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docTemplateContextTypeRegistry = templateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.WikitextRweaveDoc");
        }
        return templateContextTypeRegistry;
    }

    public synchronized TemplateStore getDocTemplateStore() {
        TemplateStore templateStore = this.docTemplateStore;
        if (templateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            templateStore = new ContributionTemplateStore(this.getDocTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/DocTemplates_store");
            try {
                templateStore.load();
            }
            catch (IOException e) {
                RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, 0, "An error occured when loading 'Wikitext+R document' template store.", (Throwable)e));
            }
            this.docTemplateStore = templateStore;
        }
        return templateStore;
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        IPreferenceStore preferenceStore = this.editorPreferenceStore;
        if (preferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = preferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), WikitextEditingSettings.getPreferenceStore(), RUIPlugin.getInstance().getPreferenceStore(), LTKUIPreferences.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return preferenceStore;
    }

    public synchronized ContentAssistComputerRegistry getWikidocRweaveEditorContentAssistRegistry() {
        ContentAssistComputerRegistry contentAssistRegistry = this.wikidocRweaveEditorContentAssistRegistry;
        if (contentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            contentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.redocs.contentTypes.WikidocRweave", WIKITEXT_RWEAVE_EDITOR_NODE);
            this.disposables.add((Disposable)contentAssistRegistry);
            this.wikidocRweaveEditorContentAssistRegistry = contentAssistRegistry;
        }
        return contentAssistRegistry;
    }
}

