/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.actions.ToggleBooleanPreferenceHandler;
import org.eclipse.statet.ecommons.ui.mpbv.BookmarkCollection;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserHandler;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLtkUI;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpViewPage;
import org.eclipse.statet.internal.r.ui.rhelp.RequestSync;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.ui.ISelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RHelpView
extends PageBookBrowserView
implements ISelectionWithElementInfoListener,
IShowInTarget {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IEclipsePreferences.IPreferenceChangeListener prefListener;
    private boolean isLinkingWithEditor;
    private final LinkEditorHandler linkingWithEditorHandler = new LinkEditorHandler();
    private @Nullable SourceEditor1 linkedEditor;
    private @Nullable IPartListener2 partListener;
    private final RequestSync requestSync = new RequestSync();

    public void dispose() {
        IEclipsePreferences.IPreferenceChangeListener prefListener;
        SourceEditor1 linkedEditor;
        IPartListener2 partListener = this.partListener;
        if (partListener != null) {
            this.partListener = null;
            this.getSite().getPage().removePartListener(partListener);
        }
        if ((linkedEditor = this.linkedEditor) != null) {
            this.linkedEditor = null;
            linkedEditor.removePostSelectionWithElementInfoListener((ISelectionWithElementInfoListener)this);
        }
        if ((prefListener = this.prefListener) != null) {
            this.prefListener = null;
            PreferenceUtils.getInstancePrefs().removePreferenceNodeListener("org.eclipse.statet.r.ui/rhelpview", prefListener);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        IEclipsePreferences.IPreferenceChangeListener prefListener;
        super.createPartControl(parent);
        this.prefListener = prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("Show.Internal.enabled")) {
                    UIAccess.getDisplay().asyncExec(() -> RHelpView.access$2(RHelpView.this));
                }
            }
        };
        PreferenceUtils.getInstancePrefs().addPreferenceNodeListener("org.eclipse.statet.r.ui/rhelpview", prefListener);
        if (!PlatformUI.getWorkbench().isStarting()) {
            Job job = new Job("Initial R Help Page"){
                {
                    this.setSystem(true);
                    this.setUser(false);
                    this.setPriority(20);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    RCore.getRHelpHttpService().ensureIsRunning();
                    Display display = UIAccess.getDisplay();
                    if (RHelpView.this.getCurrentBrowserPage() == null && display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (RHelpView.this.getCurrentBrowserPage() == null && UIAccess.isOkToUse((Control)RHelpView.this.getPageBook())) {
                                    RHelpView.this.newPage(null, true);
                                }
                            }
                        });
                    }
                    return org.eclipse.core.runtime.Status.OK_STATUS;
                }
            };
            job.schedule(50L);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), "org.eclipse.statet.r.ui.r_help-view");
        this.initLinking();
    }

    private void initLinking() {
        this.partListener = new IPartListener2(){

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (RHelpView.this.linkedEditor != null && partRef.getPart(false) == RHelpView.this.linkedEditor) {
                    this.clear();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof SourceEditor1) {
                    SourceEditor1 sourceEditor;
                    RHelpView.this.linkedEditor = sourceEditor = (SourceEditor1)part;
                    sourceEditor.addPostSelectionWithElementInfoListener((ISelectionWithElementInfoListener)RHelpView.this);
                } else if (part instanceof IEditorPart) {
                    this.clear();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            private void clear() {
                SourceEditor1 sourceEditor = RHelpView.this.linkedEditor;
                if (sourceEditor != null) {
                    sourceEditor.removePostSelectionWithElementInfoListener((ISelectionWithElementInfoListener)RHelpView.this);
                    RHelpView.this.linkedEditor = null;
                }
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        RunCode handler = new RunCode(false);
        handlers.add("org.eclipse.statet.r.commands.SubmitSelectionToR", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.statet.r.commands.SubmitSelectionToR", (IHandler)handler);
        handler = new RunCode(true);
        handlers.add("org.eclipse.statet.r.commands.SubmitFileToRViaCommand_GotoConsole", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.statet.r.commands.SubmitFileToRViaCommand_GotoConsole", (IHandler)handler);
    }

    protected @NonNull IHandler2 createOpenExternalHandler() {
        return new BrowserHandler.OpenExternalHandler(this.getBrowserInterface()){

            protected void open(String url, IWebBrowser webBrowser) throws Exception {
                try {
                    URI serverUrl = RCore.getRHelpHttpService().toServerUrl(new URI(url));
                    if (serverUrl != null) {
                        webBrowser.openURL(serverUrl.toURL());
                        return;
                    }
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
                super.open(url, webBrowser);
            }
        };
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.appendToGroup("view.filter", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "Show.Internal", "NO_COMMAND", null, null, null, null, "Show &Internal Topics", null, null, 16, null, false), (IHandler2)new ToggleBooleanPreferenceHandler(RHelpPreferences.SHOW_INTERNAL_ENABLED_PREF, null)));
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.find("Show.Internal").update();
            }
        });
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("bookmarks", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.workbench.commands.OpenSearchDialog", Collections.singletonMap("pageId", "org.eclipse.statet.r.searchPages.RHelpPage"), null, null, null, null, null, null, 8, null, false)));
        toolBarManager.add((IContributionItem)this.linkingWithEditorHandler);
    }

    protected PageBookBrowserPage doCreatePage(BrowserSession session) {
        return new RHelpViewPage(this, session);
    }

    protected void updateTitle() {
        BrowserSession session = (BrowserSession)this.getCurrentSession();
        if (session == null) {
            this.setContentDescription(this.getNoPageTitle());
        } else {
            this.setContentDescription("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BookmarkCollection initBookmarkCollection() {
        BookmarkCollection collection = BookmarkCollection.getCollection((String)"org.eclipse.statet.r.ui/rhelpview");
        List bookmarks = collection.getBookmarks();
        BookmarkCollection bookmarkCollection = collection;
        synchronized (bookmarkCollection) {
            if (bookmarks.isEmpty()) {
                bookmarks.add(new BrowserBookmark("R Homepage - The R Project for Statistical Computing", "https://www.r-project.org/"));
                bookmarks.add(new BrowserBookmark("CRAN - The Comprehensive R Archive Network", "https://cran.r-project.org/"));
                bookmarks.add(new BrowserBookmark("RSeek.org - R community Search Engine", "https://rseek.org/"));
            }
        }
        return collection;
    }

    protected @Nullable BrowserBookmark createBookmark() {
        PageBookBrowserPage page = this.getCurrentBrowserPage();
        if (page != null) {
            String sUrl = page.getCurrentUrl();
            try {
                URI url = new URI(sUrl);
                URI portableUrl = RCore.getRHelpHttpService().toPortableUrl(url);
                sUrl = portableUrl != null ? portableUrl.toString() : url.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new BrowserBookmark(page.getCurrentTitle(), sUrl);
        }
        return null;
    }

    public String getHomePageUrl() {
        return (String)PreferenceUtils.getInstancePrefs().getPreferenceValue(RHelpPreferences.HOMEPAGE_URL_PREF);
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        pageIds.add("org.eclipse.statet.r.preferencePages.RHelpPage");
        pageIds.add("org.eclipse.statet.r.preferencePages.REnvironmentPage");
        super.collectContextMenuPreferencePages(pageIds);
    }

    private void reloadRPkgHelps() {
        for (BrowserSession browserSession : this.getSessions()) {
            RHelpViewPage helpViewPage;
            IPage page = this.getPage((PageBookSession)browserSession);
            if (!(page instanceof RHelpViewPage) || !((helpViewPage = (RHelpViewPage)page).getHelpObject() instanceof RPkgHelp)) continue;
            helpViewPage.refresh();
        }
    }

    public void setLinkingWithEditor(boolean enable) {
        ISelection selection;
        this.isLinkingWithEditor = enable;
        this.linkingWithEditorHandler.setChecked(enable);
        if (enable && this.linkedEditor != null && (selection = this.linkedEditor.getShowInContext().getSelection()) instanceof LTKInputData) {
            this.stateChanged((LTKInputData)selection);
        }
    }

    public void inputChanged() {
    }

    public void stateChanged(LTKInputData state) {
        if (!this.isLinkingWithEditor) {
            return;
        }
        this.show(state, this.requestSync.newRequest(false));
    }

    private boolean show(LTKInputData state, @Nullable RequestSync.RequestKey request) {
        if (request == null) {
            return false;
        }
        try {
            if (state.getInputElement().getModelTypeId() == "R" || state.getInputElement() instanceof RSourceUnit) {
                AstSelection astSelection = state.getAstSelection();
                RSourceUnit rSourceUnit = (RSourceUnit)state.getInputElement();
                ISelection selection = state.getSelection();
                if (astSelection != null && selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    if (!(astSelection.getCovering() instanceof RAstNode) || textSelection.getLength() > 0) {
                        return false;
                    }
                    RAstNode rNode = (RAstNode)astSelection.getCovering();
                    RElementName name = null;
                    if (!rNode.hasChildren()) {
                        name = RHelpLtkUI.searchName(rNode, (TextRegion)rNode, false);
                    }
                    if (name == null) {
                        name = RHelpLtkUI.searchNameOfFunction(rNode, LTKSelectionUtils.toTextRegion((ITextSelection)textSelection));
                    }
                    if (name == null) {
                        return false;
                    }
                    if (this.requestSync.startRequest(request)) {
                        this.doShow1(request, rSourceUnit, rNode, name);
                    }
                }
            }
            return false;
        }
        finally {
            if (request.job == null) {
                this.requestSync.deleteRequest(request);
            }
        }
    }

    private boolean doShow1(RequestSync.RequestKey request, @Nullable RSourceUnit rSourceUnit, RAstNode rNode, RElementName name) {
        REnvHelp help;
        Object helpObject = null;
        try {
            help = RHelpLtkUI.getEnvHelp(rSourceUnit);
        }
        catch (StatusException e) {
            IStatus status = EStatusUtils.convert((Status)e.getStatus());
            this.showMessage(status, request);
            return false;
        }
        try {
            if (RElementName.isPackageFacetScopeType((int)name.getType())) {
                helpObject = help.getPkgHelp(name.getSegmentName());
            } else {
                RPkgHelp pkgHelp;
                if (name.getScope() != null && RElementName.isPackageFacetScopeType((int)name.getScope().getType()) && (pkgHelp = help.getPkgHelp(name.getScope().getSegmentName())) != null) {
                    helpObject = pkgHelp.getPageForTopic(name.getSegmentName());
                }
                if (helpObject == null && !this.isTopicShown(name.getSegmentName()) && (helpObject = RHelpLtkUI.searchTopicObject1(help, name.getSegmentName(), rNode, rSourceUnit)) == null && request.isValid()) {
                    this.doShow2(help.getREnv(), name.getSegmentName(), request);
                    return true;
                }
            }
        }
        catch (CoreException coreException) {
        }
        finally {
            help.unlock();
        }
        if (helpObject != null) {
            return this.showHelpObject(helpObject, request);
        }
        return false;
    }

    private void doShow2(REnv rEnv, String topic, RequestSync.RequestKey request) {
        IProgressService progressService;
        class BackgroundJob
        extends Job {
            private final /* synthetic */ RequestSync.RequestKey val$request;
            private final /* synthetic */ REnv val$rEnv;
            private final /* synthetic */ String val$topic;

            public BackgroundJob(String string, RequestSync.RequestKey requestKey, REnv rEnv) {
                this.val$topic = string;
                this.val$request = requestKey;
                this.val$rEnv = rEnv;
                super(String.format("Lookup R Help for '%1$s'", string));
                this.setPriority(20);
                this.setUser(requestKey.isExplicite());
            }

            protected IStatus run(IProgressMonitor monitor) {
                ProgressMonitor m = EStatusUtils.convert((IProgressMonitor)monitor);
                try {
                    REnvHelp help = RCore.getRHelpManager().getHelp(this.val$rEnv);
                    if (help != null) {
                        Object helpObject = null;
                        try {
                            try {
                                helpObject = RHelpLtkUI.searchTopicObject2(help, this.val$topic, m);
                            }
                            catch (StatusException e) {
                                IStatus status = EStatusUtils.convert((Status)e.getStatus());
                                RHelpView.this.showMessage(status, this.val$request);
                                IStatus iStatus = status;
                                help.unlock();
                                RHelpView.this.requestSync.deleteRequest(this.val$request);
                                return iStatus;
                            }
                        }
                        finally {
                            help.unlock();
                        }
                    }
                    IStatus iStatus = org.eclipse.core.runtime.Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    RHelpView.this.requestSync.deleteRequest(this.val$request);
                }
            }

            protected void canceling() {
                RHelpView.this.requestSync.deleteRequest(this.val$request);
            }
        }
        BackgroundJob job = new BackgroundJob(topic, request, rEnv);
        job.schedule();
        request.setAsync(job);
        if (request.isExplicite() && (progressService = (IProgressService)this.getSite().getService(IProgressService.class)) != null) {
            progressService.showInDialog(this.getSite().getShell(), (Job)job);
        }
    }

    private boolean isTopicShown(String topic) {
        Object helpObject;
        IPage currentPage = this.getCurrentPage();
        if (currentPage instanceof RHelpViewPage && (helpObject = ((RHelpViewPage)currentPage).getHelpObject()) instanceof RHelpPage) {
            return ((RHelpPage)helpObject).getTopics().contains((Object)topic);
        }
        return false;
    }

    private boolean isLinkedValid() {
        return this.linkedEditor != null && this.linkedEditor == this.linkedEditor.getSite().getPage().getActiveEditor();
    }

    private boolean showHelpObject(Object helpObject, final RequestSync.RequestKey request) {
        URI httpUrl = RCore.getRHelpHttpService().toHttpUrl(helpObject, "browse");
        if (httpUrl == null) {
            return false;
        }
        final String urlString = httpUrl.toString();
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BrowserSession session;
                if (RHelpView.this.isValid(request) && UIAccess.isOkToUse((Control)RHelpView.this.getPageBook()) && ((session = (BrowserSession)RHelpView.this.getCurrentSession()) == null || !urlString.equals(session.getUrl()))) {
                    RHelpView.this.openUrl(urlString, session);
                }
            }
        });
        return true;
    }

    public boolean isValid(RequestSync.RequestKey request) {
        if (request.isExplicite()) {
            return request.isValid();
        }
        return this.isLinkedValid() && request.isValid();
    }

    private void showMessage(final IStatus status, final RequestSync.RequestKey request) {
        if (!request.isExplicite()) {
            return;
        }
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RHelpView.this.isValid(request) && UIAccess.isOkToUse((Control)RHelpView.this.getPageBook())) {
                    RHelpView.this.getStatusManager().setMessage(status, 10);
                }
            }
        });
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == IShowInTarget.class) {
            return (T)((Object)this);
        }
        return (T)super.getAdapter(adapterType);
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof LTKInputData) {
            LTKInputData state = (LTKInputData)selection;
            return this.show(state, this.requestSync.newRequest(true));
        }
        return false;
    }

    static /* synthetic */ void access$2(RHelpView rHelpView) {
        rHelpView.reloadRPkgHelps();
    }

    private class LinkEditorHandler
    extends SimpleContributionItem {
        public LinkEditorHandler() {
            super("Link with Editor", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/synchronized"), null, 32);
        }

        protected void execute() throws ExecutionException {
            RHelpView.this.setLinkingWithEditor(!RHelpView.this.isLinkingWithEditor);
        }
    }

    public class RunCode
    extends AbstractHandler {
        private final boolean gotoConsole;

        public RunCode(boolean gotoConsole) {
            this.gotoConsole = gotoConsole;
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            this.setBaseEnabled(RHelpView.this.getCurrentBrowserPage() != null);
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            block4: {
                String selectedText;
                PageBookBrowserPage browserPage = RHelpView.this.getCurrentBrowserPage();
                if (browserPage != null && (selectedText = browserPage.getSelectedText()) != null && selectedText.length() > 0) {
                    try {
                        ArrayList lines = TextUtil.toLines((String)selectedText);
                        RCodeLaunching.runRCodeDirect(lines, this.gotoConsole, null);
                    }
                    catch (CoreException e) {
                        IStatus causeStatus = e.getStatus();
                        org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(causeStatus.getSeverity(), "org.eclipse.statet.r.ui", 0, RLaunchingMessages.RSelectionLaunch_error_message, (Throwable)e);
                        StatusManager.getManager().handle((IStatus)status);
                        IStatusLineManager manager = RHelpView.this.getViewSite().getActionBars().getStatusLineManager();
                        if (manager == null) break block4;
                        if (causeStatus.getSeverity() == 4) {
                            manager.setErrorMessage(causeStatus.getMessage());
                        }
                        manager.setMessage(causeStatus.getMessage());
                    }
                }
            }
            return null;
        }
    }
}

