/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.editors.RQuickOutlineInformationControl;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.QuickInformationProvider;
import org.eclipse.statet.r.core.source.RDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.swt.widgets.Shell;

public class RQuickOutlineInformationProvider
extends QuickInformationProvider {
    private RHeuristicTokenScanner scanner;

    public RQuickOutlineInformationProvider(ISourceEditor editor, int viewerOperation) {
        super(editor, "R", viewerOperation);
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (this.scanner == null) {
            this.scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        try {
            ITypedRegion partition;
            IDocument document = this.getEditor().getViewer().getDocument();
            this.scanner.configure(document);
            IRegion word = this.scanner.findRWord(offset, false, true);
            if (word != null && (RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = this.scanner.getPartition(word.getOffset())).getType()) || partition.getType() == "R.String" || partition.getType() == "R.QuotedSymbol")) {
                return word;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Region(offset, 0);
    }

    public IInformationControlCreator createInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new RQuickOutlineInformationControl(parent, RQuickOutlineInformationProvider.this.getCommandId());
            }
        };
    }
}

