/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.waltable.data.ControlData;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.swt.graphics.Font;

@NonNullByDefault
public class ColumnLabelProvider
extends CellLabelProvider {
    private final RDataTableColumn column;
    private @Nullable Font infoFont;

    public ColumnLabelProvider(RDataTableColumn column) {
        this.column = column;
    }

    public void update(ViewerCell cell) {
        Object data = this.column.getDefaultFormat().modelToDisplayValue(cell.getElement());
        cell.setFont(data instanceof ControlData ? this.getInfoFont() : null);
        cell.setText(data.toString());
    }

    protected Font getInfoFont() {
        Font font = this.infoFont;
        if (font == null) {
            this.infoFont = font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
        }
        return font;
    }
}

