/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.List;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableVariable;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.ts.core.RTool;

@NonNullByDefault
public final class RDataTableContentDescription {
    private static final @NonNull RDataTableVariable[] NO_COLUMNS_ARRAY = new RDataTableVariable[0];
    private final RElementName elementName;
    private final RObject struct;
    private final String label;
    private final RTool rHandle;
    private ImList<RDataTableColumn> columnHeaderRows = ImCollections.emptyList();
    private ImList<RDataTableColumn> rowHeaderColumns = ImCollections.emptyList();
    private ImList<RDataTableColumn> dataColumns = ImCollections.emptyList();
    private @NonNull RDataTableVariable[] dataVariables = NO_COLUMNS_ARRAY;
    private @Nullable RDataFormatter defaultDataFormat;

    public RDataTableContentDescription(RElementName elementName, RObject struct, RTool rHandle) {
        this.elementName = (RElementName)ObjectUtils.nonNullAssert((Object)elementName);
        this.struct = (RObject)ObjectUtils.nonNullAssert((Object)struct);
        this.label = elementName.getDisplayName();
        this.rHandle = rHandle;
    }

    public RElementName getElementName() {
        return this.elementName;
    }

    public RObject getRElementStruct() {
        return this.struct;
    }

    public String getLabel() {
        return this.label;
    }

    public Tool getRHandle() {
        return this.rHandle;
    }

    void setColumnHeaderRows(RDataTableColumn ... dataColumns) {
        this.columnHeaderRows = ImCollections.newList((Object[])dataColumns);
    }

    void setRowHeaderColumns(RDataTableColumn ... dataColumns) {
        this.rowHeaderColumns = ImCollections.newList((Object[])dataColumns);
    }

    void setDataColumns(RDataTableColumn ... dataColumns) {
        this.dataColumns = ImCollections.newList((Object[])dataColumns);
    }

    void setVariables(RDataTableVariable ... variables) {
        this.dataVariables = variables;
    }

    void setDefaultDataFormat(RDataFormatter format) {
        this.defaultDataFormat = format;
    }

    public List<RDataTableColumn> getColumnHeaderRows() {
        return this.columnHeaderRows;
    }

    public List<RDataTableColumn> getRowHeaderColumns() {
        return this.rowHeaderColumns;
    }

    public List<RDataTableColumn> getDataColumns() {
        return this.dataColumns;
    }

    @NonNull RDataTableVariable[] getVariables() {
        return this.dataVariables;
    }

    public @Nullable RDataFormatter getDefaultDataFormat() {
        return this.defaultDataFormat;
    }

    public int hashCode() {
        return 986986;
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof RDataTableContentDescription;
    }
}

