/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.FindListener;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.ui.dataeditor.RDataTableComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

@NonNullByDefault
public class FindDataDialog
extends ExtStatusDialog {
    private static final Map<IWorkbenchWindow, FindDataDialog> gDialogs = new HashMap<IWorkbenchWindow, FindDataDialog>();
    private static final int FIND_NEXT_ID = 101;
    private static final int FIND_PREVIOUS_ID = 102;
    private final IWorkbenchWindow window;
    private @Nullable IWorkbenchPart part;
    private final PartListener partListener = new PartListener();
    private @Nullable RDataTableComposite table;
    private Combo textControl = (Combo)ObjectUtils.nonNullLateInit();
    private Button rExpressionModeControl = (Button)ObjectUtils.nonNullLateInit();
    private Button isNaModeControl = (Button)ObjectUtils.nonNullLateInit();
    private Button directionFirstInColumnControl = (Button)ObjectUtils.nonNullLateInit();
    private Button directionFirstInRowControl = (Button)ObjectUtils.nonNullLateInit();
    private Button selectedOnlyControl = (Button)ObjectUtils.nonNullLateInit();
    private final Map<String, String> historyModeMap = new HashMap<String, String>();
    private final FindListener findListener = new FindListener(){

        @Override
        public void handleFindEvent(FindListener.FindEvent event) {
            FindDataDialog.this.updateStatus(event.status);
        }
    };

    public static @Nullable FindDataDialog get(IWorkbenchWindow window) {
        return gDialogs.get(window);
    }

    public static FindDataDialog getCreate(IWorkbenchWindow window) {
        FindDataDialog dialog = gDialogs.get(window);
        if (dialog == null) {
            dialog = new FindDataDialog(window);
            dialog.create();
            gDialogs.put(window, dialog);
        }
        return dialog;
    }

    protected FindDataDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.window = window;
        this.window.getWorkbench().addWindowListener((IWindowListener)this.partListener);
        this.window.getActivePage().addPartListener((IPartListener)this.partListener);
        this.part = this.window.getActivePage().getActivePart();
        this.setTitle("Find");
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.setBlockOnOpen(false);
        this.setStatusLineAboveButtons(false);
        this.setHelpAvailable(false);
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"RDataTable.FindDialog");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    public void create() {
        super.create();
        this.loadSettings();
    }

    public boolean close() {
        this.window.getWorkbench().removeWindowListener((IWindowListener)this.partListener);
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            page.removePartListener((IPartListener)this.partListener);
        }
        gDialogs.remove(this.window);
        this.saveSettings();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Composite textInput = this.createTextInput(composite);
        textInput.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite additionalOptions = this.createAdditionalOptions(composite);
        additionalOptions.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite directionOptions = this.createDirectionOptions(composite);
        directionOptions.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite navigateButtons = this.createNavigateButtons(composite);
        navigateButtons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        FindDataDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Composite createTextInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Find:");
        this.textControl = new Combo(composite, 2052);
        this.textControl.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, true, false), (Combo)this.textControl, (int)25));
        this.textControl.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FindDataDialog.this.clearStatus();
                FindDataDialog.this.updateState();
            }
        });
        this.textControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx;
                if (!FindDataDialog.this.textControl.getListVisible() && (selectionIdx = FindDataDialog.this.textControl.getSelectionIndex()) >= 0) {
                    FindDataDialog.this.loadQuery(FindDataDialog.this.textControl.getItem(selectionIdx));
                }
            }
        });
        return composite;
    }

    protected Composite createDirectionOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Direction");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2, (boolean)true));
        Button button = new Button((Composite)composite, 16);
        button.setText("&Column, Row");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.directionFirstInColumnControl = button;
        button = new Button((Composite)composite, 16);
        button.setText("&Row, Column");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.directionFirstInRowControl = button;
        button = new Button((Composite)composite, 32);
        button.setText("Only Selec&ted Cells");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.selectedOnlyControl = button;
        return composite;
    }

    protected Composite createScopeOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Scope");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        Button button = new Button((Composite)composite, 16);
        button.setText("A&ll");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        button = new Button((Composite)composite, 32);
        button.setText("Selec&ted Cells");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectedOnlyControl = button;
        return composite;
    }

    protected Composite createAdditionalOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Options");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2, (boolean)true));
        Button button = new Button((Composite)composite, 32);
        button.setText("R expression");
        button.setToolTipText("Use x to reference the object itself, e.g. 'x >= 1'");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rExpressionModeControl = button;
        this.rExpressionModeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindDataDialog.this.rExpressionModeControl.getSelection()) {
                    FindDataDialog.this.isNaModeControl.setSelection(false);
                }
            }
        });
        button = new Button((Composite)composite, 32);
        button.setText("Is NA");
        button.setToolTipText("The search expression is ignored");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.isNaModeControl = button;
        this.isNaModeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindDataDialog.this.isNaModeControl.getSelection()) {
                    FindDataDialog.this.rExpressionModeControl.setSelection(false);
                }
            }
        });
        return composite;
    }

    protected Composite createNavigateButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)0));
        this.createButton(composite, 102, "&Previous", false);
        this.createButton(composite, 101, "&Next", true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                return;
            }
            case 101: {
                this.doFind(true);
                return;
            }
            case 102: {
                this.doFind(false);
                return;
            }
        }
    }

    private void loadQuery(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        String mode = this.historyModeMap.get(text);
        if (mode != null) {
            if ("r_expression".equals(mode)) {
                this.rExpressionModeControl.setSelection(true);
                this.isNaModeControl.setSelection(false);
            } else {
                this.rExpressionModeControl.setSelection(false);
            }
        }
    }

    private void doFind(boolean forward) {
        RDataTableComposite table = (RDataTableComposite)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.table)));
        String expression = this.getExpression();
        if (!expression.equals("is.na(x)")) {
            String text = this.textControl.getText();
            int idx = this.textControl.indexOf(text);
            if (idx != 0) {
                if (idx > 0) {
                    this.textControl.remove(idx);
                }
                this.textControl.add(text, 0);
                this.textControl.setText(text);
            }
            this.historyModeMap.put(text, this.rExpressionModeControl.getSelection() ? "r_expression" : "default");
        }
        table.find(expression, this.selectedOnlyControl.getSelection(), this.directionFirstInRowControl.getSelection(), forward);
    }

    protected String getExpression() {
        if (this.rExpressionModeControl.getSelection()) {
            return this.textControl.getText();
        }
        if (this.isNaModeControl.getSelection()) {
            return "is.na(x)";
        }
        return "x == " + this.textControl.getText();
    }

    protected void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        @NonNull String[] history = DialogUtils.noNull((String[])settings.getArray("SearchText.history"));
        this.textControl.setItems(history);
        @NonNull String[] historyModes = DialogUtils.noNull((String[])settings.getArray("SearchMode.history"));
        if (history.length == historyModes.length) {
            int i = 0;
            while (i < history.length) {
                this.historyModeMap.put(history[i], historyModes[i]);
                ++i;
            }
        }
        if (history.length > 0) {
            this.textControl.setText(history[0]);
            this.loadQuery(history[0]);
        }
        if (settings.getBoolean("Direction.firstInRow")) {
            this.directionFirstInColumnControl.setSelection(false);
            this.directionFirstInRowControl.setSelection(true);
        } else {
            this.directionFirstInColumnControl.setSelection(true);
            this.directionFirstInRowControl.setSelection(false);
        }
    }

    protected void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String[] history = DialogUtils.combineHistoryItems((String[])this.textControl.getItems(), null);
        settings.put("SearchText.history", history);
        String[] historyModes = new String[history.length];
        int i = 0;
        while (i < history.length) {
            String mode = this.historyModeMap.get(history[i]);
            if (mode == null) {
                mode = "default";
            }
            historyModes[i] = mode;
            ++i;
        }
        settings.put("SearchMode.history", historyModes);
        settings.put("Direction.firstInRow", this.directionFirstInRowControl.getSelection());
    }

    public void update(IWorkbenchPart part) {
        if (part != null && this.part == part) {
            RDataTableComposite currentTable = this.table;
            RDataTableComposite newTable = (RDataTableComposite)((Object)part.getAdapter(RDataTableComposite.class));
            if (currentTable != null && currentTable != newTable) {
                currentTable.removeFindListener(this.findListener);
                this.clearStatus();
            }
            this.table = newTable;
            if (newTable != null) {
                newTable.addFindListener(this.findListener);
            }
            this.updateState();
        }
    }

    private void updateState() {
        boolean enabled = this.table != null && this.textControl.getText().length() > 0;
        this.getButton(101).setEnabled(enabled);
        this.getButton(102).setEnabled(enabled);
    }

    private class PartListener
    implements IWindowListener,
    IPartListener {
        private PartListener() {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (FindDataDialog.this.window == window) {
                FindDataDialog.this.close();
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (FindDataDialog.this.part == part) {
                FindDataDialog.this.part = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            FindDataDialog.this.part = part;
            FindDataDialog.this.update(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    }
}

