/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import com.ibm.icu.text.DateFormat;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.internal.r.nico.RNicoMessages;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.CombinedFactory;
import org.eclipse.statet.internal.r.rdata.REnvironmentVar;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.nico.core.runtime.ConsoleRunnable;
import org.eclipse.statet.nico.core.runtime.IRemoteEngineController;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RDbg;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAsts;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.r.nico.IRModelSrcref;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.r.nico.RWorkspaceConfig;
import org.eclipse.statet.r.nico.impl.RjsUtil;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.data.RDataJConverter;
import org.eclipse.statet.rj.data.REnvironment;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.eclient.graphics.comclient.ERClientGraphicActions;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.FxCallback;
import org.eclipse.statet.rj.server.REngine;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerInfo;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.server.client.FunctionCallImpl;
import org.eclipse.statet.rj.server.client.RClientGraphicActions;
import org.eclipse.statet.rj.server.client.RClientGraphicFactory;
import org.eclipse.statet.rj.server.client.RGraphicCreatorImpl;
import org.eclipse.statet.rj.server.dbg.CallStack;
import org.eclipse.statet.rj.server.dbg.CtrlReport;
import org.eclipse.statet.rj.server.dbg.DbgEnablement;
import org.eclipse.statet.rj.server.dbg.DbgFilterState;
import org.eclipse.statet.rj.server.dbg.DbgRequest;
import org.eclipse.statet.rj.server.dbg.ElementTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.FlagTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.FrameContext;
import org.eclipse.statet.rj.server.dbg.FrameContextDetailRequest;
import org.eclipse.statet.rj.server.dbg.SetDebugReport;
import org.eclipse.statet.rj.server.dbg.SetDebugRequest;
import org.eclipse.statet.rj.server.dbg.SrcfileData;
import org.eclipse.statet.rj.server.dbg.TracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.TracepointStatesUpdate;
import org.eclipse.statet.rj.services.BasicFQRObject;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RGraphicCreator;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.RServiceControlExtension;
import org.eclipse.statet.rj.ts.core.RTool;

public class RjsController
extends AbstractRDbgController
implements IRemoteEngineController,
IRDataAdapter,
ICombinedRDataAdapter,
RServiceControlExtension {
    public static final int RJS_LOCAL = 1;
    public static final int RJS_SETUP_CONSOLE = 256;
    private static final LtkModelElementFilter<RLangSourceElement> TAG_ELEMENT_FILTER;
    private final RMIAddress address;
    private final String[] rArgs;
    private boolean isBusy = true;
    private final RjsConnection rjsConnection;
    private final NicoComClient fRjs = new NicoComClient();
    private int fRjsId;
    private final int rjsFlags;
    private final Map<String, Object> rjsProperties;
    private int fConnectionState;
    private final RObjectFactory fRObjectFactory = DefaultRObjectFactory.INSTANCE;

    static {
        RjsComConfig.registerRObjectFactory((String)"combined", (RObjectFactory)CombinedFactory.INSTANCE);
        TAG_ELEMENT_FILTER = new LtkModelElementFilter<RLangSourceElement>(){

            public boolean include(RLangSourceElement element) {
                return (element.getElementType() & 0xF00) == 1280;
            }
        };
    }

    public static RjsConnection lookup(Registry registry, RemoteException registryException, RMIAddress address) throws CoreException {
        int[] version;
        Server server;
        if (address == null) {
            throw new NullPointerException();
        }
        int[] clientVersion = AbstractRJComClient.version();
        clientVersion[2] = -1;
        try {
            if (registryException != null) {
                throw registryException;
            }
            server = (Server)registry.lookup(address.getName());
            version = server.getVersion();
        }
        catch (NotBoundException e) {
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", "The specified R engine is not in the service registry (RMI).", (Throwable)e));
        }
        catch (RemoteException e) {
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", NLS.bind((String)"Cannot access the host/service registry (RMI) at ''{0}''.", (Object)address.getRegistryAddress()), (Throwable)e));
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", NLS.bind((String)"The specified R engine ({0}) is incompatibel to this client ({1}).", (Object)RjsUtil.getVersionString(null), (Object)RjsUtil.getVersionString(clientVersion)), (Throwable)e));
        }
        if (version.length != 3 || version[0] != clientVersion[0] || version[1] != clientVersion[1]) {
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.core", NLS.bind((String)"The specified R engine ({0}) is incompatibel to this client ({1}).", (Object)RjsUtil.getVersionString(version), (Object)RjsUtil.getVersionString(clientVersion)), null));
        }
        return new RjsConnection(address, server);
    }

    public RjsController(RProcess process, RMIAddress address, RjsConnection connection, Map<String, Object> connectionInfo, int rjsFlags, String[] rArgs, Map<String, Object> rjsProperties, IFileStore initialWD, RWorkspaceConfig workspaceConfig, List<TrackingConfiguration> trackingConfigurations) {
        super(process, connectionInfo);
        if (address == null || connection == null) {
            throw new IllegalArgumentException();
        }
        this.address = address;
        this.rjsConnection = connection;
        this.rjsFlags = rjsFlags;
        this.rArgs = rArgs;
        this.rjsProperties = rjsProperties != null ? rjsProperties : new HashMap();
        process.registerFeatureSet("org.eclipse.statet.rj.services.RService");
        process.registerFeatureSet("org.eclipse.statet.r.data");
        if ((this.rjsFlags & 1) == 0) {
            process.registerFeatureSet("org.eclipse.statet.nico/remote");
        }
        this.setTracksConfig(trackingConfigurations);
        this.setWorksapceData(new RWorkspace(this, (this.rjsFlags & 1) != 0 || address.isLocalHost() ? null : address.getHostAddress().getHostAddress(), workspaceConfig));
        this.setWorkspaceDirL(initialWD);
        this.initRunnableAdapterL();
    }

    @Override
    public boolean supportsBusy() {
        return true;
    }

    @Override
    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean isDisconnected() {
        return this.fConnectionState == 24 || this.fConnectionState == 25;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(ProgressMonitor m) throws StatusException {
        switch (this.getStatus()) {
            case STARTED_IDLING: 
            case STARTED_PROCESSING: 
            case STARTED_PAUSED: 
            case STARTED_SUSPENDED: {
                m.beginTask("Disconnecting from R remote engine...", 1);
                Queue queue = this.getQueue();
                synchronized (queue) {
                    this.beginInternalTask();
                }
                try {
                    try {
                        this.fRjs.getConsoleEngine().disconnect();
                        this.fConnectionState = 24;
                    }
                    catch (RemoteException e) {
                        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Disconnecting from R remote engine failed.", (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Queue queue2 = this.getQueue();
                    synchronized (queue2) {
                        this.scheduleControllerRunnable((SystemRunnable)new ToolController.ControllerSystemRunnable(this, "common/disconnect/finish", "Disconnect"){

                            public void run(ToolService s, ProgressMonitor m) throws StatusException {
                                if (!RjsController.this.isTerminated()) {
                                    RjsController.this.fRjs.runMainLoopPing(m);
                                    RjsController.this.fRjs.handleServerStatus(new RjsStatus(1, 24), m);
                                }
                            }
                        });
                        this.endInternalTask();
                    }
                    throw throwable;
                }
                Queue queue3 = this.getQueue();
                synchronized (queue3) {
                    this.scheduleControllerRunnable((SystemRunnable)new /* invalid duplicate definition of identical inner class */);
                    this.endInternalTask();
                    break;
                }
            }
        }
    }

    protected ToolRunnable createStartRunnable() {
        return new ToolController.StartRunnable(this){

            public String getLabel() {
                return "Connect to and load remote R engine.";
            }
        };
    }

    protected void startToolL(ProgressMonitor m) throws StatusException {
        this.fRjsId = RjsComConfig.registerClientComHandler((ComHandler)this.fRjs);
        this.fRjs.initClient(this.getTool(), (RService)this, this.rjsProperties, this.fRjsId);
        try {
            long timestamp;
            HashMap<String, Object> data = new HashMap<String, Object>();
            ToolCommandHandler loginHandler = this.getCommandHandler("common/login.request");
            String msg = null;
            boolean connected = false;
            while (!connected) {
                Map connectionInfo = this.getTool().getConnectionInfo();
                ServerLogin login = this.rjsConnection.getServer().createLogin("console.connect");
                try {
                    try {
                        REngine rjServer;
                        ImList callbacks = login.getCallbacks();
                        if (!callbacks.isEmpty()) {
                            ArrayList<Callback> checked = new ArrayList<Callback>();
                            FxCallback fx = null;
                            for (Callback callback : callbacks) {
                                if (callback instanceof FxCallback) {
                                    fx = (FxCallback)callback;
                                    continue;
                                }
                                checked.add(callback);
                            }
                            if (connectionInfo != null) {
                                data.putAll(connectionInfo);
                            }
                            data.put("address", fx != null ? this.address.getHost() : this.address.getAddress());
                            data.put("message", msg);
                            data.put("callbacks", checked.toArray(new Callback[checked.size()]));
                            if (loginHandler == null) {
                                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Login requested but not supported by this configuration."));
                            }
                            if (loginHandler.execute("common/login.request", (ToolService)this, data, m).getSeverity() != 0) {
                                throw new StatusException(Status.CANCEL_STATUS);
                            }
                            if (fx != null) {
                                RjsUtil.handleFxCallback(RjsUtil.getSession(data, m.newSubMonitor(1)), fx, m.newSubMonitor(1));
                            }
                        }
                        msg = null;
                        m.checkCanceled();
                        HashMap<String, Object> args = new HashMap<String, Object>();
                        args.putAll(this.rjsProperties);
                        if ((this.rjsFlags & 0x100) != 0) {
                            args.put("args", this.rArgs);
                            rjServer = (REngine)this.rjsConnection.getServer().execute("console.start", args, login.createAnswer());
                        } else {
                            rjServer = (REngine)this.rjsConnection.getServer().execute("console.connect", args, login.createAnswer());
                        }
                        this.fRjs.setServer(rjServer, 0);
                        connected = true;
                        if (!callbacks.isEmpty()) {
                            loginHandler.execute("common/login.ok", (ToolService)this, data, m);
                            if (connectionInfo != null) {
                                connectionInfo.put("username", data.get("username"));
                            }
                        }
                    }
                    catch (LoginException e) {
                        msg = e.getLocalizedMessage();
                        if (login == null) continue;
                        login.clearData();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (login != null) {
                        login.clearData();
                    }
                    throw throwable;
                }
                if (login == null) continue;
                login.clearData();
            }
            ServerInfo info = this.rjsConnection.getServer().getInfo();
            if (this.getWorkspaceData().isRemote()) {
                try {
                    String wd = FileUtil.toString((IFileStore)this.getWorkspaceData().toFileStore(info.getDirectory()));
                    if (wd != null) {
                        this.setStartupWD(wd);
                    }
                }
                catch (CoreException wd) {
                    // empty catch block
                }
                try {
                    String osName;
                    String sep = this.fRjs.getProperty("file.separator");
                    if (sep == null && (osName = this.fRjs.getProperty("os.name")) != null && SystemUtils.getOs((String)osName) == 1) {
                        sep = "\\";
                    }
                    if (sep != null && !sep.isEmpty()) {
                        this.setFileSeparatorL(sep.charAt(0));
                    }
                }
                catch (Exception sep) {}
            } else {
                this.setStartupWD(info.getDirectory());
            }
            if ((timestamp = info.getTimestamp()) != 0L) {
                this.setStartupTimestamp(timestamp);
            }
            ArrayList<Status> warnings = new ArrayList<Status>();
            this.initTracks(m.newSubMonitor(1), warnings);
            if ((this.rjsFlags & 0x100) != 0 && !this.startupsRunnables.isEmpty()) {
                this.getQueue().add(this.startupsRunnables);
                this.startupsRunnables.clear();
            }
            if ((this.rjsFlags & 0x100) == 0) {
                this.handleStatus((Status)new InfoStatus("org.eclipse.statet.r.console.core", this.addTimestampToMessage(RNicoMessages.R_Info_Reconnected_message, this.getTool().getConnectionTimestamp())), m);
            }
            this.fRjs.activateConsole();
            class RStart2Runnable
            extends ToolController.ControllerSystemRunnable
            implements ConsoleRunnable {
                private final /* synthetic */ List val$warnings;

                RStart2Runnable(List list) {
                    this.val$warnings = list;
                    super((ToolController)RjsController.this, "r/rj/start2", "Finish Initialization / Read Output");
                }

                public SubmitType getSubmitType() {
                    return SubmitType.CONSOLE;
                }

                public void run(ToolService s, ProgressMonitor m) throws StatusException {
                    if (!RjsController.this.fRjs.isConsoleReady()) {
                        RjsController.this.fRjs.runMainLoop(null, null, m);
                        RjsController.this.briefChanged(1);
                    }
                    for (Status status : this.val$warnings) {
                        RjsController.this.handleStatus(status, m);
                    }
                }
            }
            this.scheduleControllerRunnable((SystemRunnable)new RStart2Runnable(warnings));
        }
        catch (RemoteException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "The R engine could not be started.", (Throwable)e));
        }
        catch (RjException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "An error occured when creating login data.", (Throwable)e));
        }
    }

    protected String addTimestampToMessage(String message, long timestamp) {
        String datetime = DateFormat.getDateTimeInstance().format((Object)System.currentTimeMillis());
        return String.valueOf(datetime) + " - " + message;
    }

    protected void requestHotMode(boolean async) {
        this.fRjs.requestHotMode(async);
    }

    protected boolean initilizeHotMode() {
        return this.fRjs.startHotMode();
    }

    protected void onHotModeExit(ProgressMonitor m) {
        super.onHotModeExit(m);
        try {
            this.fRjs.finishTask(m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onTaskFinished(ToolController.RunnableData runnableData, int event, ProgressMonitor m) {
        try {
            this.fRjs.finishTask(m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onTaskFinished(runnableData, event, m);
    }

    protected int setSuspended(int level, int enterDetail, Object enterData) {
        int diff = super.setSuspended(level, enterDetail, enterData);
        if (level > 0 && diff > 0) {
            this.fRjs.requestExtraMode(3);
        }
        return diff;
    }

    @Override
    protected CallStack doEvalCallStack(ProgressMonitor m) throws StatusException {
        return (CallStack)this.fRjs.execSyncDbgOp((byte)1, null, m);
    }

    @Override
    protected FrameContext doEvalFrameContext(int position, ProgressMonitor m) throws Exception {
        return (FrameContext)this.fRjs.execSyncDbgOp((byte)2, (RJIOExternalizable)new FrameContextDetailRequest(position), m);
    }

    protected void interruptTool() throws UnsupportedOperationException {
        this.fRjs.runAsyncInterrupt();
    }

    @Override
    protected void postCancelTask(int options, ProgressMonitor m) throws StatusException {
        super.postCancelTask(options, m);
        if (this.fRjs.isConsoleReady()) {
            this.fCurrentInput = "";
            this.doSubmitL(m);
            this.fCurrentInput = "";
            this.doSubmitL(m);
        }
    }

    protected boolean isToolAlive() {
        if (this.fConnectionState != 0 || !this.fRjs.runAsyncPing()) {
            return false;
        }
        return Thread.currentThread() != this.getControllerThread() || this.isInHotModeL() || this.fRjs.isConsoleReady();
    }

    protected void killTool(ProgressMonitor m) {
        this.fRjs.setClosed(true);
        RTool consoleProcess = this.getTool();
        IProcess[] processes = consoleProcess.getLaunch().getProcesses();
        int i = 0;
        while (i < processes.length) {
            if (processes[i] != consoleProcess && !processes[i].isTerminated()) {
                try {
                    processes[i].terminate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    protected void clear() {
        this.fRjs.setClosed(true);
        super.clear();
        if ((this.rjsFlags & 1) != 0 && !this.isDisconnected()) {
            try {
                Naming.unbind(this.address.getAddress());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.fRjs.disposeAllGraphics();
        if (this.fRjsId > 0) {
            RjsComConfig.unregisterClientComHandler((int)this.fRjsId);
            this.fRjsId = 0;
        }
    }

    protected int finishToolL() {
        int exitCode = 0;
        if (this.isDisconnected()) {
            exitCode = 101;
        }
        return exitCode;
    }

    @Override
    protected boolean canSuspend(ProgressMonitor m) {
        return this.fRjs.getDataLevel() == 0;
    }

    @Override
    protected void doRequestSuspend(ProgressMonitor m) throws StatusException {
        this.fRjs.execSyncDbgOp((byte)4, null, m);
    }

    @Override
    protected SetDebugReport doExec(SetDebugRequest request, ProgressMonitor m) throws StatusException {
        return (SetDebugReport)this.fRjs.execSyncDbgOp((byte)3, (RJIOExternalizable)request, m);
    }

    @Override
    protected CtrlReport doExec(DbgRequest request, ProgressMonitor m) throws StatusException {
        return (CtrlReport)this.fRjs.execSyncDbgOp(request.getOp(), (RJIOExternalizable)request, m);
    }

    @Override
    protected void doPrepareSrcfile(String srcfile, String statetPath, ProgressMonitor m) throws StatusException {
        FunctionCall prepare = this.createFunctionCall("rj:::.statet.prepareSrcfile");
        prepare.addChar("filename", srcfile);
        prepare.addChar("path", statetPath);
        prepare.evalVoid(m);
    }

    @Override
    public void exec(TracepointInstallationRequest request, ProgressMonitor m) throws StatusException {
        if (request instanceof FlagTracepointInstallationRequest) {
            this.fRjs.execSyncDbgOp((byte)16, (RJIOExternalizable)request, m);
        } else if (request instanceof ElementTracepointInstallationRequest) {
            this.fRjs.execSyncDbgOp((byte)17, (RJIOExternalizable)request, m);
        } else {
            throw new IllegalArgumentException("request type not supported");
        }
    }

    @Override
    public void exec(DbgEnablement request) throws StatusException {
        this.fRjs.execAsyncDbgOp((byte)25, (RJIOExternalizable)request);
    }

    @Override
    public void exec(DbgFilterState request) throws StatusException {
        this.fRjs.execAsyncDbgOp((byte)26, (RJIOExternalizable)request);
    }

    @Override
    public void exec(TracepointStatesUpdate request) throws StatusException {
        this.fRjs.execAsyncDbgOp((byte)28, (RJIOExternalizable)request);
    }

    @Override
    public void exec(TracepointStatesUpdate request, ProgressMonitor m) throws StatusException {
        this.fRjs.execSyncDbgOp((byte)28, (RJIOExternalizable)request, m);
    }

    @Override
    protected void doSubmitCommandL(String[] lines, SrcfileData srcfile, IRSrcref srcref, ProgressMonitor m) throws StatusException {
        if ((this.fCurrentPrompt.meta & 6) == 0) {
            super.doSubmitCommandL(lines, srcfile, srcref, m);
            return;
        }
        FunctionCall prepare = this.createFunctionCall("rj:::.statet.prepareCommand");
        prepare.add("lines", (RObject)this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createCharData(lines)));
        if (srcfile != null && srcref != null && srcref.getFirstLine() >= 0) {
            IRModelSrcref modelSrcref;
            List<RLangSourceElement> elements;
            ArrayList<String> attributeNames = new ArrayList<String>();
            ArrayList<RVector> attributeValues = new ArrayList<RVector>();
            if (srcfile.getName() != null) {
                prepare.addChar("filename", srcfile.getName());
            }
            if (srcfile.getTimestamp() != 0L) {
                attributeNames.add("timestamp");
                attributeValues.add(this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createNumData(new double[]{srcfile.getTimestamp()})));
            }
            attributeNames.add("linesSrcref");
            attributeValues.add(this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createIntData(RDbg.createRJSrcref(srcref))));
            if (attributeNames.size() > 0) {
                prepare.add("srcfileAttributes", (RObject)this.fRObjectFactory.createList(attributeValues.toArray(new RObject[attributeValues.size()]), attributeNames.toArray(new String[attributeNames.size()])));
            }
            if (srcref instanceof IRModelSrcref && (elements = (modelSrcref = (IRModelSrcref)srcref).getElements()).size() > 0) {
                ArrayList<String> elementIds = new ArrayList<String>(elements.size());
                ArrayList<RVector> elementIndexes = new ArrayList<RVector>(elements.size());
                for (RLangSourceElement element : elements) {
                    FDef fdef;
                    if (!TAG_ELEMENT_FILTER.include((LtkModelElement)element) || (fdef = (FDef)element.getAdapter(FDef.class)) == null) continue;
                    String elementId = RDbg.getElementId(element);
                    RAstNode cont = fdef.getContChild();
                    int[] path = RAsts.computeRExpressionIndex((RAstNode)cont, (RAstNode)RAsts.getRRootNode((RAstNode)cont, (IRegion)modelSrcref));
                    if (elementId == null || path == null) continue;
                    int[] fullPath = new int[path.length + 1];
                    fullPath[0] = 1;
                    System.arraycopy(path, 0, fullPath, 1, path.length);
                    elementIds.add(elementId);
                    elementIndexes.add(this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createIntData(fullPath)));
                }
                if (elementIds.size() > 0) {
                    prepare.add("elementIds", (RObject)this.fRObjectFactory.createList(elementIndexes.toArray(new RObject[elementIndexes.size()]), elementIds.toArray(new String[elementIds.size()])));
                }
            }
        }
        prepare.evalVoid(m);
        boolean addToHistory = (this.fCurrentPrompt.meta & 1) == 0;
        this.fCurrentInput = lines[0];
        this.doBeforeSubmitL();
        int i = 1;
        while (i < lines.length) {
            this.setCurrentPromptL(this.continuePromptText, addToHistory);
            this.fCurrentInput = lines[i];
            this.doBeforeSubmitL();
            ++i;
        }
        this.fCurrentInput = "rj:::.statet.evalCommand()";
        this.doSubmitL(m);
    }

    @Override
    public void doSubmitFileCommandToConsole(String[] lines, SrcfileData srcfile, SourceUnit su, ProgressMonitor m) throws StatusException {
        if (srcfile != null && su instanceof RWorkspaceSourceUnit && su.getModelTypeId() == "R") {
            try {
                RSourceUnitModelInfo modelInfo = (RSourceUnitModelInfo)su.getModelInfo("R", 2, EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(0)));
                if (modelInfo != null) {
                    RLangSourceElement fileElement = modelInfo.getSourceElement();
                    RAstNode rootNode = (RAstNode)fileElement.getAdapter(AstNode.class);
                    List elements = modelInfo.getSourceElement().getSourceChildren(TAG_ELEMENT_FILTER);
                    ArrayList<String> elementIds = new ArrayList<String>(elements.size());
                    ArrayList<RVector> elementIndexes = new ArrayList<RVector>(elements.size());
                    for (RLangSourceElement element : elements) {
                        FDef fdef = (FDef)element.getAdapter(FDef.class);
                        if (fdef == null) continue;
                        String elementId = RDbg.getElementId(element);
                        RAstNode cont = fdef.getContChild();
                        int[] path = RAsts.computeRExpressionIndex((RAstNode)cont, (RAstNode)rootNode);
                        if (elementId == null || path == null) continue;
                        elementIds.add(elementId);
                        elementIndexes.add(this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createIntData(path)));
                    }
                    FunctionCall prepare = this.createFunctionCall("rj:::.statet.prepareSource");
                    prepare.add((RObject)this.fRObjectFactory.createList(new RObject[]{this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createCharData(new String[]{srcfile.getPath()})), this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createNumData(new double[]{srcfile.getTimestamp()})), this.fRObjectFactory.createVector((RStore)this.fRObjectFactory.createIntData(new int[]{rootNode.getChildCount()})), this.fRObjectFactory.createList(elementIndexes.toArray(new RObject[elementIndexes.size()]), elementIds.toArray(new String[elementIds.size()]))}, new String[]{"path", "timestamp", "exprsLength", "elementIds"}));
                    prepare.evalVoid(m);
                }
            }
            catch (StatusException e) {
                RConsoleCorePlugin.logError(NLS.bind((String)"An error occurred when preparing element tagging for file ''{0}''.", (Object)srcfile.getPath()), e);
            }
        }
        super.doSubmitFileCommandToConsole(lines, srcfile, su, m);
    }

    protected void doSubmitL(ProgressMonitor m) throws StatusException {
        this.fRjs.answerConsole(String.valueOf(this.fCurrentInput) + this.fLineSeparator, m);
    }

    public String getProperty(String key) {
        return this.fRjs.getProperty(key);
    }

    public RPlatform getPlatform() {
        return this.fRjs.getRPlatform();
    }

    public void evalVoid(String command, ProgressMonitor m) throws StatusException {
        this.fRjs.evalVoid(command, null, m);
    }

    public void evalVoid(String command, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        this.fRjs.evalVoid(command, envir, m);
    }

    public RObject evalData(String command, ProgressMonitor m) throws StatusException {
        return this.fRjs.evalData(command, null, null, 0, -1, m);
    }

    public RObject evalData(String command, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.fRjs.evalData(command, null, factoryId, options, depth, m);
    }

    public RObject evalData(String command, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.fRjs.evalData(command, envir, factoryId, options, depth, m);
    }

    public RObject evalData(RReference reference, ProgressMonitor m) throws StatusException {
        return this.fRjs.evalData(reference, null, 0, -1, m);
    }

    public RObject evalData(RReference reference, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.fRjs.evalData(reference, factoryId, options, depth, m);
    }

    public FQRObject<RProcess> findData(String symbol, @Nullable RObject env, boolean inherits, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        RObject[] data = this.fRjs.findData(symbol, env, inherits, factoryId, options, depth, m);
        if (data != null) {
            return new BasicFQRObject((Object)this.getTool(), (REnvironment)data[1], symbol, data[0]);
        }
        return null;
    }

    private BasicCombinedRElement checkCombinedRElement(@Nullable RObject data, int options, @Nullable RElementName name) {
        if (data instanceof BasicCombinedRElement) {
            BasicCombinedRElement e = (BasicCombinedRElement)data;
            if (e.getRObjectType() == 8) {
                ((REnvironmentVar)e).setSource((RProcess)this.getTool(), this.getChangeStamp(), options);
            }
            if (name != null) {
                e.setElementName(name);
            }
            return e;
        }
        return null;
    }

    @Override
    public CombinedRElement evalCombinedStruct(String command, int options, int depth, @Nullable RElementName name, ProgressMonitor m) throws StatusException {
        RObject data = this.fRjs.evalData(command, null, "combined", options | 1, depth, m);
        return this.checkCombinedRElement(data, options, name);
    }

    @Override
    public CombinedRElement evalCombinedStruct(String command, @Nullable RObject envir, int options, int depth, @Nullable RElementName name, ProgressMonitor m) throws StatusException {
        RObject data = this.fRjs.evalData(command, envir, "combined", options | 1, depth, m);
        return this.checkCombinedRElement(data, options, name);
    }

    private CombinedRElement evalCombinedStructSpecialEnv(RElementName name, int options, int depth, ProgressMonitor m) throws StatusException {
        byte envType;
        switch (name.getType()) {
            case 33: {
                envType = 12;
                break;
            }
            case 34: {
                envType = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        RObject data = this.fRjs.evalData(envType, name.getSegmentName(), "combined", options | 1, depth, m);
        return this.checkCombinedRElement(data, options, name);
    }

    @Override
    public CombinedRElement evalCombinedStruct(RElementName name, int options, int depth, ProgressMonitor m) throws StatusException {
        switch (name.getType()) {
            case 33: 
            case 34: {
                if (name.getNextSegment() != null) break;
                return this.evalCombinedStructSpecialEnv(name, options, depth, m);
            }
        }
        String command = name.getDisplayName(3);
        if (command == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Illegal R element name."));
        }
        return this.evalCombinedStruct(command, options, depth, name, m);
    }

    @Override
    public CombinedRElement evalCombinedStruct(RReference reference, int options, int depth, @Nullable RElementName name, ProgressMonitor m) throws StatusException {
        RObject data = this.evalData(reference, "combined", options | 1, depth, m);
        return this.checkCombinedRElement(data, options, name);
    }

    private boolean isValidSymbol(RElementName name) {
        return name.getType() == 17 && name.getSegmentName() != null && name.getNextSegment() == null;
    }

    private RLanguage createLangObject(RElementName name, String arg) {
        String expr = name.getDisplayName(3);
        if (expr == null) {
            throw new IllegalArgumentException(arg);
        }
        return new RLanguageImpl(3, expr, null);
    }

    @Override
    public @Nullable CombinedRElement findCombinedStruct(RElementName symbol, @Nullable RObject env, boolean inherits, int options, int depth, ProgressMonitor m) throws StatusException {
        BasicCombinedRElement element;
        if (!this.isValidSymbol(symbol)) {
            throw new IllegalArgumentException("symbol");
        }
        RObject[] data = this.fRjs.findData(symbol.getSegmentName(), env, inherits, "combined", options | 1, depth, m);
        if (data != null && (element = this.checkCombinedRElement(data[0], options, symbol)) != null) {
            element.setParent(this.checkCombinedRElement(data[1], options, env instanceof CombinedRElement ? ((CombinedRElement)env).getElementName() : null));
            return element;
        }
        return null;
    }

    @Override
    public @Nullable CombinedRElement findCombinedStruct(RElementName symbol, @Nullable RElementName envName, boolean inherits, int options, int depth, ProgressMonitor m) throws StatusException {
        BasicCombinedRElement element;
        if (!this.isValidSymbol(symbol)) {
            throw new IllegalArgumentException("symbol");
        }
        RLanguage env = envName != null ? this.createLangObject(envName, "envName") : null;
        RObject[] data = this.fRjs.findData(symbol.getSegmentName(), (RObject)env, inherits, "combined", options | 1, depth, m);
        if (data != null && (element = this.checkCombinedRElement(data[0], options, symbol)) != null) {
            element.setParent(this.checkCombinedRElement(data[1], options, envName));
            return element;
        }
        return null;
    }

    public void assignData(String expression, RObject data, ProgressMonitor m) throws StatusException {
        this.fRjs.assignData(expression, data, null, m);
    }

    public void downloadFile(OutputStream out, String fileName, int options, ProgressMonitor m) throws StatusException {
        this.fRjs.downloadFile(out, fileName, options, m);
    }

    public byte[] downloadFile(String fileName, int options, ProgressMonitor m) throws StatusException {
        return this.fRjs.downloadFile(fileName, options, m);
    }

    public void uploadFile(InputStream in, long length, String fileName, int options, ProgressMonitor m) throws StatusException {
        this.fRjs.uploadFile(in, length, fileName, options, m);
    }

    public FunctionCall createFunctionCall(String name) throws StatusException {
        return new FunctionCallImpl((AbstractRJComClient)this.fRjs, name, this.fRObjectFactory);
    }

    public RGraphicCreator createRGraphicCreator(int options) throws StatusException {
        return new RGraphicCreatorImpl((RService)this, (AbstractRJComClient)this.fRjs, options);
    }

    public void addCancelHandler(Callable<Boolean> handler) {
        this.fRjs.addCancelHandler(handler);
    }

    public void removeCancelHandler(Callable<Boolean> handler) {
        this.fRjs.removeCancelHandler(handler);
    }

    public Lock getWaitLock() {
        return this.fRjs.getWaitLock();
    }

    public void waitingForUser(ProgressMonitor m) {
        this.fRjs.waitingForUser();
    }

    public void resume() {
        this.fRjs.resume();
    }

    private class NicoComClient
    extends AbstractRJComClient {
        protected void initGraphicFactory() {
            ToolCommandHandler handler = RjsController.this.getCommandHandler("r/initRGraphicFactory");
            HashMap data = new HashMap();
            Status status = RjsController.this.executeHandler("r/initRGraphicFactory", handler, data, null);
            RClientGraphicFactory factory = (RClientGraphicFactory)data.get("factory");
            if (status != null && status.getSeverity() < 4 && factory != null) {
                this.setGraphicFactory(factory, (RClientGraphicActions)new ERClientGraphicActions((AbstractRJComClient)this, RjsController.this.getTool()));
            }
        }

        protected void updateBusy(boolean isBusy) {
            RjsController.this.isBusy = isBusy;
        }

        protected void updatePrompt(String text, boolean addToHistory) {
            try {
                RjsController.this.setCurrentPromptL(text, addToHistory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void writeConsoleOutput(byte streamId, String text) {
            try {
                ToolStreamProxy streams = RjsController.this.getStreams();
                SubmitType submitType = RjsController.this.getCurrentSubmitType();
                switch (streamId) {
                    case 1: {
                        streams.getOutputStreamMonitor().append(text, submitType, 0);
                        return;
                    }
                    case 2: {
                        streams.getErrorStreamMonitor().append(text, submitType, 0);
                        return;
                    }
                }
                streams.getSystemOutputMonitor().append(text, submitType, 0);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        protected void showMessage(String text) {
            try {
                ToolStreamProxy streams = RjsController.this.getStreams();
                SubmitType submitType = RjsController.this.getCurrentSubmitType();
                streams.getInfoStreamMonitor().append(text, submitType, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected RList handleUICallback(String commandId, RList args, ProgressMonitor m) throws Exception {
            String s;
            ToolCommandHandler handler = RjsController.this.getCommandHandler(commandId);
            if (handler == null && commandId.startsWith("r/") && (handler = RjsController.this.getCommandHandler(s = commandId.substring(2))) != null) {
                commandId = s;
            }
            if (handler != null) {
                RDataJConverter converter = new RDataJConverter();
                converter.setKeepArray1(false);
                converter.setRObjectFactory(RjsController.this.fRObjectFactory);
                HashMap<String, Object> javaArgs = new HashMap<String, Object>();
                if (args != null) {
                    int i = 0;
                    while ((long)i < args.getLength()) {
                        javaArgs.put(args.getName(i), converter.toJava(args.get(i)));
                        ++i;
                    }
                }
                Status status = handler.execute(commandId, (ToolService)RjsController.this, javaArgs, m);
                switch (status.getSeverity()) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new StatusException(status);
                    }
                }
                Map javaAnswer = null;
                if (commandId.equals("common/chooseFile")) {
                    javaAnswer = Collections.singletonMap("filename", javaArgs.get("filename"));
                }
                if (javaAnswer != null) {
                    RList answer = (RList)converter.toRJ(javaAnswer);
                    return answer;
                }
                return null;
            }
            return super.handleUICallback(commandId, args, m);
        }

        protected void handleDbgEvents(byte dbgOp, Object events) {
            if (dbgOp == 65) {
                RjsController.this.handleTracepointEvents((List)events);
            }
            super.handleDbgEvents(dbgOp, events);
        }

        protected void log(Status status) {
            RConsoleCorePlugin.log(status);
        }

        protected void handleServerStatus(RjsStatus serverStatus, ProgressMonitor m) throws StatusException {
            String specialMessage = null;
            switch (serverStatus.getCode()) {
                case 0: {
                    return;
                }
                case 24: {
                    RjsController.this.fConnectionState = 24;
                }
                case 25: {
                    if (RjsController.this.fConnectionState == 24) {
                        specialMessage = RNicoMessages.R_Info_Disconnected_message;
                        break;
                    }
                    if ((RjsController.this.rjsFlags & 1) == 0) {
                        RjsController.this.fConnectionState = 25;
                        specialMessage = RNicoMessages.R_Info_ConnectionLost_message;
                        break;
                    }
                }
                case 26: {
                    RjsController.this.fConnectionState = 26;
                    specialMessage = RNicoMessages.R_Info_Stopped_message;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!this.isClosed()) {
                RjsController.this.markAsTerminated();
                this.setClosed(true);
                this.handleStatus((Status)new InfoStatus("org.eclipse.statet.r.console.core", RjsController.this.addTimestampToMessage(specialMessage, System.currentTimeMillis())), m);
            }
            throw new StatusException((Status)new CancelStatus("org.eclipse.statet.r.console.core", specialMessage));
        }

        protected void handleStatus(Status status, ProgressMonitor m) {
            RjsController.this.handleStatus(status, m);
        }

        protected void processHotMode() {
            RjsController.this.runHotModeLoop();
        }

        protected void processExtraMode(int position) {
            RjsController.this.runSuspendedLoopL(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scheduleConnectionCheck() {
            Queue queue = RjsController.this.getQueue();
            synchronized (queue) {
                if (RjsController.this.getStatusL().isWaiting()) {
                    RjsController.this.scheduleControllerRunnable((SystemRunnable)new ToolController.ControllerSystemRunnable(RjsController.this, "r/check", "Connection Check"){

                        public void run(ToolService s, ProgressMonitor m) throws StatusException {
                            ((NicoComClient)NicoComClient.this).RjsController.this.fRjs.runMainLoopPing(m);
                        }
                    });
                }
            }
        }
    }

    public static class RjsConnection {
        private final RMIAddress rmiAddress;
        private final Server server;

        private RjsConnection(RMIAddress rmiAddress, Server server) {
            this.rmiAddress = rmiAddress;
            this.server = server;
        }

        public RMIAddress getRMIAddress() {
            return this.rmiAddress;
        }

        public Server getServer() {
            return this.server;
        }
    }
}

